/*
 * Decompiled with CFR 0.152.
 */
package boofcv.javacv;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeRadial;
import java.io.File;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.indexer.DoubleRawIndexer;
import org.bytedeco.javacpp.opencv_core;
import org.ejml.data.DMatrixRMaj;

public class UtilOpenCV {
    public static CameraPinholeRadial loadPinholeRadial(String fileName) {
        opencv_core.FileStorage fs = new opencv_core.FileStorage(new File(fileName).getAbsolutePath(), 0);
        IntPointer width = new IntPointer(1L);
        IntPointer height = new IntPointer(1L);
        opencv_core.read((opencv_core.FileNode)fs.get("image_width"), (IntPointer)width, (int)-1);
        opencv_core.read((opencv_core.FileNode)fs.get("image_height"), (IntPointer)height, (int)-1);
        opencv_core.Mat K = new opencv_core.Mat();
        opencv_core.read((opencv_core.FileNode)fs.get("camera_matrix"), (opencv_core.Mat)K);
        opencv_core.Mat distortion = new opencv_core.Mat();
        opencv_core.read((opencv_core.FileNode)fs.get("distortion_coefficients"), (opencv_core.Mat)distortion);
        CameraPinholeRadial boof = new CameraPinholeRadial();
        boof.width = width.get();
        boof.height = height.get();
        DoubleRawIndexer indexerK = (DoubleRawIndexer)K.createIndexer();
        boof.fx = indexerK.get(0L, 0L);
        boof.skew = indexerK.get(0L, 1L);
        boof.fy = indexerK.get(1L, 1L);
        boof.cx = indexerK.get(0L, 2L);
        boof.cy = indexerK.get(1L, 2L);
        DoubleRawIndexer indexerD = (DoubleRawIndexer)distortion.createIndexer();
        if (distortion.rows() == 5) {
            boof.setRadial(new double[]{indexerD.get(0L, 0L), indexerD.get(1L, 0L), indexerD.get(4L, 0L)});
        } else if (distortion.rows() >= 2) {
            boof.setRadial(new double[]{indexerD.get(0L, 0L), indexerD.get(1L, 0L)});
        }
        if (distortion.rows() >= 5) {
            boof.fsetTangental(indexerD.get(2L, 0L), indexerD.get(3L, 0L));
        }
        return boof;
    }

    public static void save(CameraPinholeRadial model, String fileName) {
        opencv_core.FileStorage fs = new opencv_core.FileStorage(new File(fileName).getAbsolutePath(), 1);
        DMatrixRMaj K = PerspectiveOps.calibrationMatrix((CameraPinhole)model, (DMatrixRMaj)null);
        opencv_core.write((opencv_core.FileStorage)fs, (String)"image_width", (int)model.width);
        opencv_core.write((opencv_core.FileStorage)fs, (String)"image_height", (int)model.height);
        opencv_core.write((opencv_core.FileStorage)fs, (String)"camera_matrix", (opencv_core.Mat)UtilOpenCV.toMat(K));
        DMatrixRMaj D = new DMatrixRMaj(2 + model.radial.length, 1);
        D.set(0, 0, model.radial[0]);
        D.set(1, 0, model.radial[1]);
        D.set(4, 0, model.radial[2]);
        D.set(2, 0, model.t1);
        D.set(3, 0, model.t2);
        opencv_core.write((opencv_core.FileStorage)fs, (String)"distortion_coefficients", (opencv_core.Mat)UtilOpenCV.toMat(D));
        try {
            fs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static opencv_core.Mat toMat(DMatrixRMaj in) {
        opencv_core.Mat out = new opencv_core.Mat(in.numRows, in.numCols, 6);
        DoubleRawIndexer indexer = (DoubleRawIndexer)out.createIndexer();
        for (int i = 0; i < in.numRows; ++i) {
            for (int j = 0; j < in.numCols; ++j) {
                indexer.put((long)i, (long)j, in.get(i, j));
            }
        }
        return out;
    }
}

