/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.jcodec;

import boofcv.io.MediaManager;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.image.UtilImageIO;
import boofcv.io.jcodec.JCodecSimplified;
import boofcv.io.video.VideoMjpegCodec;
import boofcv.io.wrapper.images.ImageStreamSequence;
import boofcv.io.wrapper.images.JpegByteImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JCodecMediaManager
implements MediaManager {
    public static final JCodecMediaManager INSTANCE = new JCodecMediaManager();
    Map<String, BufferedImage> cachedImage = new HashMap<String, BufferedImage>();

    public Reader openFile(String fileName) {
        try {
            return new FileReader(fileName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public BufferedImage openImage(String fileName) {
        BufferedImage b = this.cachedImage.get(fileName);
        if (b == null) {
            b = UtilImageIO.loadImage((String)fileName);
            if (b == null) {
                throw new RuntimeException("Image cannot be found! " + fileName);
            }
            this.cachedImage.put(fileName, b);
        }
        BufferedImage c = new BufferedImage(b.getWidth(), b.getHeight(), b.getType());
        Graphics2D g2 = c.createGraphics();
        g2.drawImage((Image)b, 0, 0, null);
        return c;
    }

    public <T extends ImageBase<T>> SimpleImageSequence<T> openVideo(String fileName, ImageType<T> type) {
        if (fileName.endsWith("mjpeg") || fileName.endsWith("MJPEG")) {
            try {
                VideoMjpegCodec codec = new VideoMjpegCodec();
                List data = codec.read((InputStream)new FileInputStream(fileName));
                return new JpegByteImageSequence(type, data, false);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (fileName.endsWith("mpng") || fileName.endsWith("MPNG")) {
            try {
                return new ImageStreamSequence(fileName, true, type);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return new JCodecSimplified<T>(fileName, type);
    }

    public <T extends ImageBase<T>> SimpleImageSequence<T> openCamera(String device, int width, int height, ImageType<T> imageType) {
        throw new RuntimeException("Not supported");
    }
}

