/*
 * Decompiled with CFR 0.152.
 */
package org.openkinect.freenect;

import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import org.openkinect.freenect.DepthFormat;
import org.openkinect.freenect.Resolution;
import org.openkinect.freenect.VideoFormat;

public class FrameMode
extends Structure {
    public int reserved;
    public int resolution;
    public int format;
    public int bytes;
    public short width;
    public short height;
    public byte dataBitsPerPixel;
    public byte paddingBitsPerPixel;
    public byte framerate;
    public byte valid = 0;

    protected List getFieldOrder() {
        return Arrays.asList("reserved", "resolution", "format", "bytes", "width", "height", "dataBitsPerPixel", "paddingBitsPerPixel", "framerate", "valid");
    }

    public Resolution getResolution() {
        return Resolution.fromInt(this.resolution);
    }

    public DepthFormat getDepthFormat() {
        return DepthFormat.fromInt(this.format);
    }

    public VideoFormat getVideoFormat() {
        return VideoFormat.fromInt(this.format);
    }

    public int getFrameSize() {
        return this.bytes;
    }

    public short getWidth() {
        return this.width;
    }

    public short getHeight() {
        return this.height;
    }

    public int getFrameRate() {
        return this.framerate;
    }

    public boolean isValid() {
        return this.valid != 0;
    }

    public static class ByValue
    extends FrameMode
    implements Structure.ByValue {
    }
}

