/*
 * Decompiled with CFR 0.152.
 */
package boofcv.openkinect;

import boofcv.openkinect.UtilOpenKinect;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;
import java.nio.ByteBuffer;
import org.openkinect.freenect.DepthFormat;
import org.openkinect.freenect.DepthHandler;
import org.openkinect.freenect.Device;
import org.openkinect.freenect.FrameMode;
import org.openkinect.freenect.Resolution;
import org.openkinect.freenect.VideoFormat;
import org.openkinect.freenect.VideoHandler;

public class StreamOpenKinectRgbDepth {
    private long timeout = 10000L;
    private volatile long timeDepthData;
    private volatile long timeRgbData;
    private byte[] dataDepth;
    private byte[] dataRgb;
    private Listener listener;
    private GrayU16 depth = new GrayU16(1, 1);
    private Planar<GrayU8> rgb = new Planar(GrayU8.class, 1, 1, 3);
    private CombineThread thread;
    private Device device;

    public void start(Device device, Resolution resolution, Listener listener) {
        if (resolution != Resolution.MEDIUM) {
            throw new IllegalArgumentException("Depth image is always at medium resolution.  Possible bug in kinect driver");
        }
        this.device = device;
        this.listener = listener;
        device.setDepthFormat(DepthFormat.REGISTERED, resolution);
        device.setVideoFormat(VideoFormat.RGB, resolution);
        int w = UtilOpenKinect.getWidth(resolution);
        int h = UtilOpenKinect.getHeight(resolution);
        this.dataDepth = new byte[w * h * 2];
        this.dataRgb = new byte[w * h * 3];
        this.depth.reshape(w, h);
        this.rgb.reshape(w, h);
        this.thread = new CombineThread();
        this.thread.start();
        while (!this.thread.running) {
            Thread.yield();
        }
        device.startDepth(new DepthHandler(){

            @Override
            public void onFrameReceived(FrameMode mode, ByteBuffer frame, int timestamp) {
                StreamOpenKinectRgbDepth.this.processDepth(frame, timestamp);
            }
        });
        device.startVideo(new VideoHandler(){

            @Override
            public void onFrameReceived(FrameMode mode, ByteBuffer frame, int timestamp) {
                StreamOpenKinectRgbDepth.this.processRgb(frame, timestamp);
            }
        });
    }

    public void stop() {
        this.thread.requestStop = true;
        long start = System.currentTimeMillis() + this.timeout;
        while (start > System.currentTimeMillis() && this.thread.running) {
            Thread.yield();
        }
        this.device.stopDepth();
        this.device.stopVideo();
        this.device.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDepth(ByteBuffer frame, int timestamp) {
        byte[] byArray = this.dataDepth;
        synchronized (this.dataDepth) {
            for (int i = 0; i < this.dataDepth.length; ++i) {
                this.dataDepth[i] = frame.get(i);
            }
            this.timeDepthData = (long)timestamp & 0xFFFFFFFFFFL;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRgb(ByteBuffer frame, int timestamp) {
        byte[] byArray = this.dataRgb;
        synchronized (this.dataRgb) {
            for (int i = 0; i < this.dataRgb.length; ++i) {
                this.dataRgb[i] = frame.get(i);
            }
            this.timeRgbData = (long)timestamp & 0xFFFFFFFFFFL;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.thread.interrupt();
            return;
        }
    }

    public static interface Listener {
        public void processKinect(Planar<GrayU8> var1, GrayU16 var2, long var3, long var5);
    }

    private class CombineThread
    extends Thread {
        public volatile boolean running = false;
        public volatile boolean requestStop = false;

        private CombineThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running = true;
            long previousTimeStamp = 0L;
            while (!this.requestStop) {
                long timeRgb;
                long timeDepth;
                CombineThread combineThread = this;
                synchronized (combineThread) {
                    try {
                        this.wait(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (previousTimeStamp == StreamOpenKinectRgbDepth.this.timeRgbData) continue;
                byte[] byArray = StreamOpenKinectRgbDepth.this.dataDepth;
                synchronized (byArray) {
                    timeDepth = StreamOpenKinectRgbDepth.this.timeDepthData;
                    UtilOpenKinect.bufferDepthToU16(StreamOpenKinectRgbDepth.this.dataDepth, StreamOpenKinectRgbDepth.this.depth);
                }
                byArray = StreamOpenKinectRgbDepth.this.dataRgb;
                synchronized (byArray) {
                    previousTimeStamp = StreamOpenKinectRgbDepth.this.timeRgbData;
                    timeRgb = StreamOpenKinectRgbDepth.this.timeRgbData;
                    UtilOpenKinect.bufferRgbToMsU8(StreamOpenKinectRgbDepth.this.dataRgb, (Planar<GrayU8>)StreamOpenKinectRgbDepth.this.rgb);
                }
                StreamOpenKinectRgbDepth.this.listener.processKinect((Planar<GrayU8>)StreamOpenKinectRgbDepth.this.rgb, StreamOpenKinectRgbDepth.this.depth, timeRgb, timeDepth);
            }
            this.running = false;
        }
    }
}

