/*
 * Decompiled with CFR 0.152.
 */
package org.openkinect.freenect;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import org.openkinect.freenect.Context;
import org.openkinect.freenect.DepthFormat;
import org.openkinect.freenect.DepthHandler;
import org.openkinect.freenect.Device;
import org.openkinect.freenect.FrameMode;
import org.openkinect.freenect.LedStatus;
import org.openkinect.freenect.LogHandler;
import org.openkinect.freenect.LogLevel;
import org.openkinect.freenect.Resolution;
import org.openkinect.freenect.TiltStatus;
import org.openkinect.freenect.VideoFormat;
import org.openkinect.freenect.VideoHandler;

public class Freenect
implements Library {
    protected Freenect() {
    }

    public static Context createContext() {
        PointerByReference ctxPtr = new PointerByReference();
        int rval = Freenect.freenect_init(ctxPtr, Pointer.NULL);
        if (rval == 0) {
            NativeContext ctx = new NativeContext(ctxPtr.getValue());
            ctx.startEventThread();
            return ctx;
        }
        throw new IllegalStateException("init() returned " + rval);
    }

    private static native int freenect_init(PointerByReference var0, Pointer var1);

    private static native int freenect_shutdown(NativeContext var0);

    private static native void freenect_set_log_level(NativeContext var0, int var1);

    private static native void freenect_set_log_callback(NativeContext var0, NativeLogCallback var1);

    private static native int freenect_process_events(NativeContext var0);

    private static native int freenect_num_devices(NativeContext var0);

    private static native int freenect_open_device(NativeContext var0, PointerByReference var1, int var2);

    private static native int freenect_close_device(NativeDevice var0);

    private static native void freenect_set_user(NativeDevice var0, Pointer var1);

    private static native Pointer freenect_get_user(NativeDevice var0);

    private static native void freenect_set_depth_callback(NativeDevice var0, NativeDepthCallback var1);

    private static native void freenect_set_video_callback(NativeDevice var0, NativeVideoCallback var1);

    private static native int freenect_set_depth_buffer(NativeDevice var0, ByteBuffer var1);

    private static native int freenect_set_video_buffer(NativeDevice var0, ByteBuffer var1);

    private static native int freenect_start_depth(NativeDevice var0);

    private static native int freenect_start_video(NativeDevice var0);

    private static native int freenect_stop_depth(NativeDevice var0);

    private static native int freenect_stop_video(NativeDevice var0);

    private static native int freenect_update_tilt_state(NativeDevice var0);

    private static native TiltState freenect_get_tilt_state(NativeDevice var0);

    private static native byte freenect_get_tilt_status(TiltState var0);

    private static native double freenect_get_tilt_degs(TiltState var0);

    private static native int freenect_set_tilt_degs(NativeDevice var0, double var1);

    private static native int freenect_set_led(NativeDevice var0, int var1);

    private static native void freenect_get_mks_accel(TiltState var0, DoubleBuffer var1, DoubleBuffer var2, DoubleBuffer var3);

    private static native int freenect_select_subdevices(NativeContext var0, int var1);

    private static native int freenect_get_video_mode_count();

    private static native FrameMode.ByValue freenect_get_video_mode(int var0);

    private static native FrameMode.ByValue freenect_get_current_video_mode(NativeDevice var0);

    private static native FrameMode.ByValue freenect_find_video_mode(int var0, int var1);

    private static native int freenect_set_video_mode(NativeDevice var0, FrameMode.ByValue var1);

    private static native int freenect_get_depth_mode_count();

    private static native FrameMode.ByValue freenect_get_depth_mode(int var0);

    private static native FrameMode.ByValue freenect_get_current_depth_mode(NativeDevice var0);

    private static native FrameMode.ByValue freenect_find_depth_mode(int var0, int var1);

    private static native int freenect_set_depth_mode(NativeDevice var0, FrameMode.ByValue var1);

    static {
        try {
            NativeLibrary.addSearchPath((String)"freenect", (String)"/usr/local/lib");
            NativeLibrary instance = NativeLibrary.getInstance((String)"freenect");
            System.err.println("Loaded " + instance.getName() + " from " + instance.getFile().getCanonicalPath());
            Native.register((NativeLibrary)instance);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static interface NativeVideoCallback
    extends Callback {
        public void callback(Pointer var1, Pointer var2, int var3);
    }

    private static interface NativeDepthCallback
    extends Callback {
        public void callback(Pointer var1, Pointer var2, int var3);
    }

    public static interface NativeLogCallback
    extends Callback {
        public void callback(NativeDevice var1, int var2, String var3);
    }

    protected static class TiltState
    extends PointerType {
    }

    private static class EventThread
    extends Thread {
        private final NativeContext ctx;
        private volatile boolean alive = true;

        public EventThread(NativeContext ctx) {
            this.ctx = ctx;
            this.setDaemon(true);
            this.setName("FreenectEventThread");
        }

        public void kill() {
            this.alive = false;
        }

        @Override
        public void run() {
            while (this.alive) {
                Freenect.freenect_process_events(this.ctx);
            }
        }
    }

    protected static class NativeDevice
    extends PointerType
    implements Device {
        private FrameMode videoMode;
        private ByteBuffer videoBuffer;
        private VideoHandler videoHandler;
        private FrameMode depthMode;
        private ByteBuffer depthBuffer;
        private DepthHandler depthHandler;
        private final DoubleBuffer accelX = DoubleBuffer.allocate(1);
        private final DoubleBuffer accelY = DoubleBuffer.allocate(1);
        private final DoubleBuffer accelZ = DoubleBuffer.allocate(1);
        private int index;
        private TiltState rawTiltState;
        private TiltStatus tiltStatus;
        private double tiltAngle;
        private double[] accel;
        private final NativeVideoCallback videoCallback = new NativeVideoCallback(this){
            final /* synthetic */ NativeDevice this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void callback(Pointer dev, Pointer depth, int timestamp) {
                this.this$0.videoHandler.onFrameReceived(this.this$0.videoMode, this.this$0.videoBuffer, timestamp);
            }
        };
        private final NativeDepthCallback depthCallback = new NativeDepthCallback(this){
            final /* synthetic */ NativeDevice this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void callback(Pointer dev, Pointer depth, int timestamp) {
                this.this$0.depthHandler.onFrameReceived(this.this$0.depthMode, this.this$0.depthBuffer, timestamp);
            }
        };

        public NativeDevice() {
        }

        protected NativeDevice(Pointer ptr, int index) {
            super(ptr);
            this.index = index;
            this.rawTiltState = Freenect.freenect_get_tilt_state(this);
            this.accel = new double[3];
            this.refreshTiltState();
        }

        protected void setDeviceIndex(int index) {
            this.index = index;
        }

        @Override
        public int getDeviceIndex() {
            return this.index;
        }

        @Override
        public void close() {
            Freenect.freenect_close_device(this);
        }

        @Override
        public void setDepthFormat(DepthFormat fmt) {
            this.setDepthFormat(fmt, Resolution.MEDIUM);
        }

        @Override
        public void setVideoFormat(VideoFormat fmt) {
            this.setVideoFormat(fmt, Resolution.MEDIUM);
        }

        @Override
        public void setDepthFormat(DepthFormat fmt, Resolution res) {
            FrameMode.ByValue mode = Freenect.freenect_find_depth_mode(res.intValue(), fmt.intValue());
            if (mode.isValid()) {
                Freenect.freenect_set_depth_mode(this, mode);
                this.depthBuffer = ByteBuffer.allocateDirect(mode.getFrameSize());
                this.depthBuffer.order(ByteOrder.nativeOrder());
                Freenect.freenect_set_depth_buffer(this, this.depthBuffer);
                this.depthMode = mode;
            }
        }

        @Override
        public void setVideoFormat(VideoFormat fmt, Resolution res) {
            FrameMode.ByValue mode = Freenect.freenect_find_video_mode(res.intValue(), fmt.intValue());
            if (mode.isValid()) {
                Freenect.freenect_set_video_mode(this, mode);
                this.videoBuffer = ByteBuffer.allocateDirect(mode.getFrameSize());
                this.videoBuffer.order(ByteOrder.nativeOrder());
                Freenect.freenect_set_video_buffer(this, this.videoBuffer);
                this.videoMode = mode;
            }
        }

        @Override
        public FrameMode getDepthMode() {
            return this.depthMode;
        }

        @Override
        public FrameMode getVideoMode() {
            return this.videoMode;
        }

        @Override
        public int setLed(LedStatus status) {
            return Freenect.freenect_set_led(this, status.intValue());
        }

        @Override
        public void refreshTiltState() {
            Freenect.freenect_update_tilt_state(this);
            this.rawTiltState = Freenect.freenect_get_tilt_state(this);
            this.tiltAngle = Freenect.freenect_get_tilt_degs(this.rawTiltState);
            this.tiltStatus = TiltStatus.fromInt(Freenect.freenect_get_tilt_status(this.rawTiltState));
            Freenect.freenect_get_mks_accel(this.rawTiltState, this.accelX, this.accelY, this.accelZ);
            this.accel[0] = this.accelX.get(0);
            this.accel[1] = this.accelY.get(0);
            this.accel[2] = this.accelZ.get(0);
        }

        @Override
        public double getTiltAngle() {
            return this.tiltAngle;
        }

        @Override
        public int setTiltAngle(double angle) {
            return Freenect.freenect_set_tilt_degs(this, angle);
        }

        @Override
        public TiltStatus getTiltStatus() {
            return this.tiltStatus;
        }

        @Override
        public double[] getAccel() {
            return new double[]{this.accelX.get(0), this.accelY.get(0), this.accelZ.get(0)};
        }

        @Override
        public int startVideo(VideoHandler handler) {
            this.videoHandler = handler;
            Freenect.freenect_set_video_callback(this, this.videoCallback);
            return Freenect.freenect_start_video(this);
        }

        @Override
        public int stopVideo() {
            int rval = Freenect.freenect_stop_video(this);
            Freenect.freenect_set_video_callback(this, null);
            this.videoHandler = null;
            return rval;
        }

        @Override
        public int startDepth(DepthHandler handler) {
            this.depthHandler = handler;
            Freenect.freenect_set_depth_callback(this, this.depthCallback);
            return Freenect.freenect_start_depth(this);
        }

        @Override
        public int stopDepth() {
            int rval = Freenect.freenect_stop_depth(this);
            Freenect.freenect_set_depth_callback(this, null);
            this.depthHandler = null;
            return rval;
        }
    }

    protected static class NativeContext
    extends PointerType
    implements Context {
        private EventThread eventThread;
        private LogHandler logHandler;
        private final NativeLogCallback logCallback = new NativeLogCallback(this){
            final /* synthetic */ NativeContext this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void callback(NativeDevice dev, int level, String msg) {
                this.this$0.logHandler.onMessage(dev, LogLevel.fromInt(level), msg);
            }
        };

        public NativeContext() {
        }

        protected NativeContext(Pointer ptr) {
            super(ptr);
        }

        @Override
        public void setLogHandler(LogHandler handler) {
            this.logHandler = handler;
            if (this.logHandler == null) {
                Freenect.freenect_set_log_callback(this, null);
            } else {
                Freenect.freenect_set_log_callback(this, this.logCallback);
            }
        }

        @Override
        public void setLogLevel(LogLevel level) {
            Freenect.freenect_set_log_level(this, level.intValue());
        }

        @Override
        public int numDevices() {
            return Freenect.freenect_num_devices(this);
        }

        @Override
        public Device openDevice(int index) {
            PointerByReference devicePtr = new PointerByReference();
            int rval = Freenect.freenect_open_device(this, devicePtr, index);
            if (rval != 0) {
                throw new IllegalStateException("freenect_open_device() returned " + rval);
            }
            return new NativeDevice(devicePtr.getValue(), index);
        }

        protected void processEvents() {
            Freenect.freenect_process_events(this);
        }

        protected void startEventThread() {
            if (this.eventThread == null || !this.eventThread.isAlive()) {
                this.eventThread = new EventThread(this);
                this.eventThread.start();
            }
        }

        protected void stopEventThread() {
            if (this.eventThread != null) {
                this.eventThread.kill();
                this.eventThread = null;
            }
        }

        @Override
        public void shutdown() {
            this.stopEventThread();
            Freenect.freenect_shutdown(this);
        }
    }
}

