/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.geo.calibration.DetectorFiducialCalibration;
import boofcv.alg.fiducial.calib.grid.DetectSquareGridFiducial;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class CalibrationDetectorSquareGrid
implements DetectorFiducialCalibration {
    DetectSquareGridFiducial<GrayF32> detect;
    List<Point2D_F64> layoutPoints;
    CalibrationObservation detected;

    public CalibrationDetectorSquareGrid(ConfigSquareGrid config) {
        config.square.refine = config.refineWithCorners ? config.configRefineCorners : config.configRefineLines;
        double spaceToSquareRatio = config.spaceWidth / config.squareWidth;
        InputToBinary inputToBinary = FactoryThresholdBinary.threshold((ConfigThreshold)config.thresholding, GrayF32.class);
        BinaryPolygonDetector detectorSquare = FactoryShapeDetector.polygon((ConfigPolygonDetector)config.square, GrayF32.class);
        this.detect = new DetectSquareGridFiducial(config.numRows, config.numCols, spaceToSquareRatio, inputToBinary, detectorSquare);
        this.layoutPoints = CalibrationDetectorSquareGrid.createLayout(config.numRows, config.numCols, config.squareWidth, config.spaceWidth);
    }

    public boolean process(GrayF32 input) {
        this.detected = new CalibrationObservation();
        if (this.detect.process(input)) {
            List<Point2D_F64> found = this.detect.getCalibrationPoints();
            for (int i = 0; i < found.size(); ++i) {
                this.detected.add(found.get(i), i);
            }
            return true;
        }
        return false;
    }

    public static List<Point2D_F64> createLayout(int numRows, int numCols, double squareWidth, double spaceWidth) {
        ArrayList<Point2D_F64> all = new ArrayList<Point2D_F64>();
        double width = (double)numCols * squareWidth + (double)(numCols - 1) * spaceWidth;
        double height = (double)numRows * squareWidth + (double)(numRows - 1) * spaceWidth;
        double startX = -width / 2.0;
        double startY = -height / 2.0;
        for (int i = numRows - 1; i >= 0; --i) {
            double y = startY + (double)i * (squareWidth + spaceWidth) + squareWidth;
            ArrayList<Point2D_F64> top = new ArrayList<Point2D_F64>();
            ArrayList<Point2D_F64> bottom = new ArrayList<Point2D_F64>();
            for (int j = 0; j < numCols; ++j) {
                double x = startX + (double)j * (squareWidth + spaceWidth);
                top.add(new Point2D_F64(x, y));
                top.add(new Point2D_F64(x + squareWidth, y));
                bottom.add(new Point2D_F64(x, y - squareWidth));
                bottom.add(new Point2D_F64(x + squareWidth, y - squareWidth));
            }
            all.addAll(top);
            all.addAll(bottom);
        }
        return all;
    }

    public CalibrationObservation getDetectedPoints() {
        return this.detected;
    }

    public List<Point2D_F64> getLayout() {
        return this.layoutPoints;
    }

    public DetectSquareGridFiducial<GrayF32> getAlgorithm() {
        return this.detect;
    }

    public int getGridRows() {
        return this.detect.getRows();
    }

    public int getGridColumns() {
        return this.detect.getColumns();
    }

    public int getPointRows() {
        return this.detect.getCalibrationRows();
    }

    public int getPointColumns() {
        return this.detect.getCalibrationCols();
    }
}

