/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.calib.circle.DetectCircleGrid;
import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoAsymmetricGrid;
import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetector;
import boofcv.struct.image.ImageGray;
import georegression.struct.shapes.EllipseRotated_F64;

public class DetectCircleAsymmetricGrid<T extends ImageGray<T>>
extends DetectCircleGrid<T> {
    public DetectCircleAsymmetricGrid(int numRows, int numCols, InputToBinary<T> inputToBinary, BinaryEllipseDetector<T> ellipseDetector, EllipsesIntoClusters clustering) {
        super(numRows, numCols, inputToBinary, ellipseDetector, clustering, new EllipseClustersIntoAsymmetricGrid());
    }

    @Override
    public int totalEllipses(int numRows, int numCols) {
        return numRows / 2 * (numCols / 2) + (numRows + 1) / 2 * ((numCols + 1) / 2);
    }

    @Override
    protected void putGridIntoCanonical(EllipseClustersIntoGrid.Grid g) {
        if (g.columns != this.numCols) {
            this.rotateGridCCW(g);
        }
        if (g.get(0, 0) == null) {
            this.reverse(g);
        }
        if (g.columns % 2 == 1 && g.rows % 2 == 1) {
            if (DetectCircleAsymmetricGrid.isClockWise(g)) {
                this.flipHorizontal(g);
            }
            int numRotationsCCW = DetectCircleAsymmetricGrid.closestCorner4(g);
            if (g.columns == g.rows) {
                for (int i = 0; i < numRotationsCCW; ++i) {
                    this.rotateGridCCW(g);
                }
            } else if (numRotationsCCW == 2) {
                this.rotateGridCCW(g);
                this.rotateGridCCW(g);
            }
        } else if (g.columns % 2 == 1) {
            if (DetectCircleAsymmetricGrid.isClockWise(g)) {
                this.flipHorizontal(g);
            }
        } else if (g.rows % 2 == 1 && DetectCircleAsymmetricGrid.isClockWise(g)) {
            this.flipVertical(g);
        }
    }

    private static boolean isClockWise(EllipseClustersIntoGrid.Grid g) {
        EllipseRotated_F64 v00 = g.get(0, 0);
        EllipseRotated_F64 v02 = g.columns < 3 ? g.get(1, 1) : g.get(0, 2);
        EllipseRotated_F64 v20 = g.rows < 3 ? g.get(1, 1) : g.get(2, 0);
        double a_x = v02.center.x - v00.center.x;
        double a_y = v02.center.y - v00.center.y;
        double b_x = v20.center.x - v00.center.x;
        double b_y = v20.center.y - v00.center.y;
        return a_x * b_y - a_y * b_x < 0.0;
    }
}

