/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import georegression.struct.shapes.EllipseRotated_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class EllipsesIntoClusters {
    private double maxDistanceToMajorAxisRatio;
    private double sizeSimilarityTolerance = 0.5;
    private int minimumClusterSize = 2;
    private NearestNeighbor<Node> search = FactoryNearestNeighbor.kdtree();
    private FastQueue<double[]> searchPoints;
    private FastQueue<NnData<Node>> searchResults = new FastQueue(NnData.class, true);
    FastQueue<Node> nodes = new FastQueue(Node.class, true);
    FastQueue<List<Node>> clusters;

    public EllipsesIntoClusters(double maxDistanceToMajorAxisRatio, double sizeSimilarityTolerance) {
        this.maxDistanceToMajorAxisRatio = maxDistanceToMajorAxisRatio;
        this.sizeSimilarityTolerance = sizeSimilarityTolerance;
        this.search.init(2);
        this.searchPoints = new FastQueue<double[]>(double[].class, true){

            protected double[] createInstance() {
                return new double[2];
            }
        };
        this.clusters = new FastQueue(List.class, true){

            protected List<Node> createInstance() {
                return new ArrayList<Node>();
            }
        };
    }

    public void process(List<EllipseRotated_F64> ellipses, List<List<Node>> output) {
        this.init(ellipses);
        this.connect(ellipses);
        output.clear();
        for (int i = 0; i < this.clusters.size(); ++i) {
            List c = (List)this.clusters.get(i);
            if (c.size() < this.minimumClusterSize) continue;
            output.add(c);
        }
    }

    void connect(List<EllipseRotated_F64> ellipses) {
        for (int i = 0; i < ellipses.size(); ++i) {
            List cluster1;
            EllipseRotated_F64 e1 = ellipses.get(i);
            Node node1 = (Node)this.nodes.get(i);
            double maxDistance = e1.a * this.maxDistanceToMajorAxisRatio;
            maxDistance *= maxDistance;
            this.searchResults.reset();
            this.search.findNearest((double[])this.searchPoints.get(i), maxDistance, Integer.MAX_VALUE, this.searchResults);
            if (node1.cluster == -1) {
                node1.cluster = this.clusters.size;
                cluster1 = (List)this.clusters.grow();
                cluster1.clear();
                cluster1.add(node1);
            } else {
                cluster1 = (List)this.clusters.get(node1.cluster);
            }
            for (int j = 0; j < this.searchResults.size(); ++j) {
                NnData d = (NnData)this.searchResults.get(j);
                EllipseRotated_F64 e2 = ellipses.get(((Node)d.data).which);
                if (e2 == e1 || EllipsesIntoClusters.axisAdjustedDistance(e1, e2) > maxDistance) continue;
                double ratioA = e1.a > e2.a ? e2.a / e1.a : e1.a / e2.a;
                double ratioB = e1.b > e2.b ? e2.b / e1.b : e1.b / e2.b;
                int indexNode2 = ((Node)d.data).which;
                Node node2 = (Node)this.nodes.get(indexNode2);
                if (!(ratioA >= this.sizeSimilarityTolerance) || !(ratioB >= this.sizeSimilarityTolerance)) continue;
                if (node2.cluster == -1) {
                    node2.cluster = node1.cluster;
                    cluster1.add(node2);
                    node1.connections.add(indexNode2);
                    node2.connections.add(i);
                    continue;
                }
                if (node2.cluster != node1.cluster) {
                    this.joinClusters(node1.cluster, node2.cluster);
                    node1.connections.add(indexNode2);
                    node2.connections.add(i);
                    continue;
                }
                if (node1.connections.indexOf(indexNode2) != -1) continue;
                node1.connections.add(indexNode2);
                node2.connections.add(i);
            }
        }
    }

    static double axisAdjustedDistance(EllipseRotated_F64 a, EllipseRotated_F64 b) {
        double dx = b.center.x - a.center.x;
        double dy = b.center.y - a.center.y;
        double c = Math.cos(a.phi);
        double s = Math.sin(a.phi);
        double x = dx * c + dy * s;
        double y = (-dx * s + dy * c) * a.a / a.b;
        return x * x + y * y;
    }

    private void init(List<EllipseRotated_F64> ellipses) {
        this.searchPoints.resize(ellipses.size());
        this.nodes.resize(ellipses.size());
        this.clusters.reset();
        int i = 0;
        while (i < ellipses.size()) {
            EllipseRotated_F64 e = ellipses.get(i);
            double[] p = (double[])this.searchPoints.get(i);
            p[0] = e.center.x;
            p[1] = e.center.y;
            Node n = (Node)this.nodes.get(i);
            n.connections.reset();
            n.which = i++;
            n.cluster = -1;
        }
        this.search.setPoints(this.searchPoints.toList(), this.nodes.toList());
    }

    void joinClusters(int mouth, int food) {
        List listMouth = (List)this.clusters.get(mouth);
        List listFood = (List)this.clusters.get(food);
        for (int i = 0; i < listFood.size(); ++i) {
            listMouth.add(listFood.get(i));
            ((Node)listFood.get((int)i)).cluster = mouth;
        }
        listFood.clear();
    }

    public double getMaxDistanceToMajorAxisRatio() {
        return this.maxDistanceToMajorAxisRatio;
    }

    public void setMaxDistanceToMajorAxisRatio(double maxDistanceToMajorAxisRatio) {
        this.maxDistanceToMajorAxisRatio = maxDistanceToMajorAxisRatio;
    }

    public double getSizeSimilarityTolerance() {
        return this.sizeSimilarityTolerance;
    }

    public void setSizeSimilarityTolerance(double sizeSimilarityTolerance) {
        this.sizeSimilarityTolerance = sizeSimilarityTolerance;
    }

    public int getMinimumClusterSize() {
        return this.minimumClusterSize;
    }

    public void setMinimumClusterSize(int minimumClusterSize) {
        this.minimumClusterSize = minimumClusterSize;
    }

    public static class Node {
        public int which;
        public int cluster;
        public GrowQueue_I32 connections = new GrowQueue_I32();
    }
}

