/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.grid;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.calib.squares.SquareGrid;
import boofcv.alg.fiducial.calib.squares.SquareGridTools;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.fiducial.calib.squares.SquareRegularClustersIntoGrids;
import boofcv.alg.fiducial.calib.squares.SquaresIntoRegularClusters;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class DetectSquareGridFiducial<T extends ImageGray<T>> {
    int numCols;
    int numRows;
    InputToBinary<T> inputToBinary;
    BinaryPolygonDetector<T> detectorSquare;
    SquaresIntoRegularClusters s2c;
    SquareRegularClustersIntoGrids c2g;
    List<Point2D_F64> calibrationPoints = new ArrayList<Point2D_F64>();
    int calibRows;
    int calibCols;
    SquareGridTools tools = new SquareGridTools();
    GrayU8 binary = new GrayU8(1, 1);
    List<List<SquareNode>> clusters;
    List<Point2D_F64> row0 = new ArrayList<Point2D_F64>();
    List<Point2D_F64> row1 = new ArrayList<Point2D_F64>();

    public DetectSquareGridFiducial(int numRows, int numCols, double spaceToSquareRatio, InputToBinary<T> inputToBinary, BinaryPolygonDetector<T> detectorSquare) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.inputToBinary = inputToBinary;
        this.detectorSquare = detectorSquare;
        this.s2c = new SquaresIntoRegularClusters(spaceToSquareRatio, Integer.MAX_VALUE, 1.35);
        this.c2g = new SquareRegularClustersIntoGrids(numCols * numRows);
        this.calibRows = numRows * 2;
        this.calibCols = numCols * 2;
    }

    public boolean process(T image) {
        this.binary.reshape(((ImageGray)image).width, ((ImageGray)image).height);
        this.inputToBinary.process(image, (ImageBase)this.binary);
        this.detectorSquare.process(image, this.binary);
        FastQueue found = this.detectorSquare.getFoundPolygons();
        this.clusters = this.s2c.process(found.toList());
        this.c2g.process(this.clusters);
        List<SquareGrid> grids = this.c2g.getGrids();
        SquareGrid match = null;
        double matchSize = 0.0;
        for (SquareGrid g : grids) {
            double size;
            if (g.columns != this.numCols || g.rows != this.numRows) {
                if (g.columns != this.numRows || g.rows != this.numCols) continue;
                this.tools.transpose(g);
            }
            if (!((size = this.tools.computeSize(g)) > matchSize)) continue;
            matchSize = size;
            match = g;
        }
        if (match != null) {
            if (this.tools.checkFlip(match)) {
                this.tools.flipRows(match);
            }
            this.tools.putIntoCanonical(match);
            if (!this.tools.orderSquareCorners(match)) {
                return false;
            }
            this.extractCalibrationPoints(match);
            return true;
        }
        return false;
    }

    void extractCalibrationPoints(SquareGrid grid) {
        this.calibrationPoints.clear();
        for (int row = 0; row < grid.rows; ++row) {
            this.row0.clear();
            this.row1.clear();
            for (int col = 0; col < grid.columns; ++col) {
                Polygon2D_F64 square = grid.get((int)row, (int)col).corners;
                this.row0.add(square.get(0));
                this.row0.add(square.get(1));
                this.row1.add(square.get(3));
                this.row1.add(square.get(2));
            }
            this.calibrationPoints.addAll(this.row0);
            this.calibrationPoints.addAll(this.row1);
        }
    }

    public List<Point2D_F64> getCalibrationPoints() {
        return this.calibrationPoints;
    }

    public int getCalibrationRows() {
        return this.calibRows;
    }

    public int getCalibrationCols() {
        return this.calibCols;
    }

    public BinaryPolygonDetector<T> getDetectorSquare() {
        return this.detectorSquare;
    }

    public List<List<SquareNode>> getClusters() {
        return this.clusters;
    }

    public SquaresIntoRegularClusters getSquaresIntoClusters() {
        return this.s2c;
    }

    public SquareRegularClustersIntoGrids getGrids() {
        return this.c2g;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }

    public int getColumns() {
        return this.numCols;
    }

    public int getRows() {
        return this.numRows;
    }
}

