/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.circulant;

import boofcv.abst.feature.detect.peak.SearchLocalPeak;
import boofcv.abst.transform.fft.DiscreteFourierTransform;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.misc.PixelMath;
import boofcv.alg.transform.fft.DiscreteFourierTransformOps;
import boofcv.factory.feature.detect.peak.FactorySearchLocalPeak;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.InterleavedF64;
import georegression.struct.shapes.RectangleLength2D_F32;
import java.util.Random;

public class CirculantTracker<T extends ImageGray<T>> {
    private double output_sigma_factor;
    private double sigma;
    private double lambda;
    private double interp_factor;
    private double maxPixelValue;
    private double padding;
    private DiscreteFourierTransform<GrayF64, InterleavedF64> fft = DiscreteFourierTransformOps.createTransformF64();
    protected GrayF64 templateNew = new GrayF64(1, 1);
    protected GrayF64 template = new GrayF64(1, 1);
    protected GrayF64 cosine = new GrayF64(1, 1);
    private GrayF64 k = new GrayF64(1, 1);
    private InterleavedF64 kf = new InterleavedF64(1, 1, 2);
    private InterleavedF64 alphaf = new InterleavedF64(1, 1, 2);
    private InterleavedF64 newAlphaf = new InterleavedF64(1, 1, 2);
    protected RectangleLength2D_F32 regionTrack = new RectangleLength2D_F32();
    protected RectangleLength2D_F32 regionOut = new RectangleLength2D_F32();
    protected GrayF64 gaussianWeight = new GrayF64(1, 1);
    protected InterleavedF64 gaussianWeightDFT = new InterleavedF64(1, 1, 2);
    private GrayF64 response = new GrayF64(1, 1);
    private GrayF64 tmpReal0 = new GrayF64(1, 1);
    private GrayF64 tmpReal1 = new GrayF64(1, 1);
    private InterleavedF64 tmpFourier0 = new InterleavedF64(1, 1, 2);
    private InterleavedF64 tmpFourier1 = new InterleavedF64(1, 1, 2);
    private InterleavedF64 tmpFourier2 = new InterleavedF64(1, 1, 2);
    private InterpolatePixelS<T> interp;
    private SearchLocalPeak<GrayF64> localPeak = FactorySearchLocalPeak.meanShiftUniform((int)5, (float)1.0E-4f, GrayF64.class);
    protected float offX;
    protected float offY;
    private int workRegionSize;
    private float stepX;
    private float stepY;
    private Random rand = new Random(234L);

    public CirculantTracker(double output_sigma_factor, double sigma, double lambda, double interp_factor, double padding, int workRegionSize, double maxPixelValue, InterpolatePixelS<T> interp) {
        if (workRegionSize < 3) {
            throw new IllegalArgumentException("Minimum size of work region is 3 pixels.");
        }
        this.output_sigma_factor = output_sigma_factor;
        this.sigma = sigma;
        this.lambda = lambda;
        this.interp_factor = interp_factor;
        this.maxPixelValue = maxPixelValue;
        this.interp = interp;
        this.padding = padding;
        this.workRegionSize = workRegionSize;
        this.resizeImages(workRegionSize);
        CirculantTracker.computeCosineWindow(this.cosine);
        this.computeGaussianWeights(workRegionSize);
        this.localPeak.setImage((ImageGray)this.response);
    }

    public void initialize(T image, int x0, int y0, int regionWidth, int regionHeight) {
        if (((ImageGray)image).width < regionWidth || ((ImageGray)image).height < regionHeight) {
            throw new IllegalArgumentException("Track region is larger than input image: " + regionWidth + " " + regionHeight);
        }
        this.regionOut.width = regionWidth;
        this.regionOut.height = regionHeight;
        int w = (int)((double)regionWidth * (1.0 + this.padding));
        int h = (int)((double)regionHeight * (1.0 + this.padding));
        int cx = x0 + regionWidth / 2;
        int cy = y0 + regionHeight / 2;
        this.regionTrack.width = w;
        this.regionTrack.height = h;
        this.regionTrack.x0 = cx - w / 2;
        this.regionTrack.y0 = cy - h / 2;
        this.stepX = (float)(w - 1) / (float)(this.workRegionSize - 1);
        this.stepY = (float)(h - 1) / (float)(this.workRegionSize - 1);
        this.updateRegionOut();
        this.initialLearning(image);
    }

    protected void initialLearning(T image) {
        this.get_subwindow(image, this.template);
        this.dense_gauss_kernel(this.sigma, this.template, this.template, this.k);
        this.fft.forward((ImageBase)this.k, (ImageBase)this.kf);
        CirculantTracker.computeAlphas(this.gaussianWeightDFT, this.kf, this.lambda, this.alphaf);
    }

    protected static void computeCosineWindow(GrayF64 cosine) {
        double[] cosX = new double[cosine.width];
        for (int x = 0; x < cosine.width; ++x) {
            cosX[x] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)x / (double)(cosine.width - 1)));
        }
        for (int y = 0; y < cosine.height; ++y) {
            int index = cosine.startIndex + y * cosine.stride;
            double cosY = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)y / (double)(cosine.height - 1)));
            for (int x = 0; x < cosine.width; ++x) {
                cosine.data[index++] = cosX[x] * cosY;
            }
        }
    }

    protected void computeGaussianWeights(int width) {
        double output_sigma = Math.sqrt(width * width) * this.output_sigma_factor;
        double left = -0.5 / (output_sigma * output_sigma);
        int radius = width / 2;
        for (int y = 0; y < this.gaussianWeight.height; ++y) {
            int index = this.gaussianWeight.startIndex + y * this.gaussianWeight.stride;
            double ry = y - radius;
            for (int x = 0; x < width; ++x) {
                double rx = x - radius;
                this.gaussianWeight.data[index++] = Math.exp(left * (ry * ry + rx * rx));
            }
        }
        this.fft.forward((ImageBase)this.gaussianWeight, (ImageBase)this.gaussianWeightDFT);
    }

    protected void resizeImages(int workRegionSize) {
        this.templateNew.reshape(workRegionSize, workRegionSize);
        this.template.reshape(workRegionSize, workRegionSize);
        this.cosine.reshape(workRegionSize, workRegionSize);
        this.k.reshape(workRegionSize, workRegionSize);
        this.kf.reshape(workRegionSize, workRegionSize);
        this.alphaf.reshape(workRegionSize, workRegionSize);
        this.newAlphaf.reshape(workRegionSize, workRegionSize);
        this.response.reshape(workRegionSize, workRegionSize);
        this.tmpReal0.reshape(workRegionSize, workRegionSize);
        this.tmpReal1.reshape(workRegionSize, workRegionSize);
        this.tmpFourier0.reshape(workRegionSize, workRegionSize);
        this.tmpFourier1.reshape(workRegionSize, workRegionSize);
        this.tmpFourier2.reshape(workRegionSize, workRegionSize);
        this.gaussianWeight.reshape(workRegionSize, workRegionSize);
        this.gaussianWeightDFT.reshape(workRegionSize, workRegionSize);
    }

    public void performTracking(T image) {
        this.updateTrackLocation(image);
        if (this.interp_factor != 0.0) {
            this.performLearning(image);
        }
    }

    protected void updateTrackLocation(T image) {
        this.get_subwindow(image, this.templateNew);
        this.dense_gauss_kernel(this.sigma, this.templateNew, this.template, this.k);
        this.fft.forward((ImageBase)this.k, (ImageBase)this.kf);
        DiscreteFourierTransformOps.multiplyComplex((InterleavedF64)this.alphaf, (InterleavedF64)this.kf, (InterleavedF64)this.tmpFourier0);
        this.fft.inverse((ImageBase)this.tmpFourier0, (ImageBase)this.response);
        int N = this.response.width * this.response.height;
        int indexBest = -1;
        double valueBest = -1.0;
        for (int i = 0; i < N; ++i) {
            double v = this.response.data[i];
            if (!(v > valueBest)) continue;
            valueBest = v;
            indexBest = i;
        }
        int peakX = indexBest % this.response.width;
        int peakY = indexBest / this.response.width;
        this.subpixelPeak(peakX, peakY);
        float deltaX = (float)peakX + this.offX - (float)(this.templateNew.width / 2);
        float deltaY = (float)peakY + this.offY - (float)(this.templateNew.height / 2);
        this.regionTrack.x0 += deltaX * this.stepX;
        this.regionTrack.y0 += deltaY * this.stepY;
        this.updateRegionOut();
    }

    protected void subpixelPeak(int peakX, int peakY) {
        int r = Math.min(2, this.response.width / 25);
        if (r < 0) {
            return;
        }
        this.localPeak.setSearchRadius(r);
        this.localPeak.search((float)peakX, (float)peakY);
        this.offX = this.localPeak.getPeakX() - (float)peakX;
        this.offY = this.localPeak.getPeakY() - (float)peakY;
    }

    private void updateRegionOut() {
        this.regionOut.x0 = this.regionTrack.x0 + (float)((int)this.regionTrack.width / 2) - (float)((int)this.regionOut.width / 2);
        this.regionOut.y0 = this.regionTrack.y0 + (float)((int)this.regionTrack.height / 2) - (float)((int)this.regionOut.height / 2);
    }

    public void performLearning(T image) {
        int i;
        this.get_subwindow(image, this.templateNew);
        this.dense_gauss_kernel(this.sigma, this.templateNew, this.templateNew, this.k);
        this.fft.forward((ImageBase)this.k, (ImageBase)this.kf);
        CirculantTracker.computeAlphas(this.gaussianWeightDFT, this.kf, this.lambda, this.newAlphaf);
        int N = this.alphaf.width * this.alphaf.height * 2;
        for (i = 0; i < N; ++i) {
            this.alphaf.data[i] = (1.0 - this.interp_factor) * this.alphaf.data[i] + this.interp_factor * this.newAlphaf.data[i];
        }
        N = this.templateNew.width * this.templateNew.height;
        for (i = 0; i < N; ++i) {
            this.template.data[i] = (1.0 - this.interp_factor) * this.template.data[i] + this.interp_factor * this.templateNew.data[i];
        }
    }

    public void dense_gauss_kernel(double sigma, GrayF64 x, GrayF64 y, GrayF64 k) {
        double yy;
        InterleavedF64 yf;
        InterleavedF64 xf = this.tmpFourier0;
        InterleavedF64 xyf = this.tmpFourier2;
        GrayF64 xy = this.tmpReal0;
        this.fft.forward((ImageBase)x, (ImageBase)xf);
        double xx = CirculantTracker.imageDotProduct(x);
        if (x != y) {
            yf = this.tmpFourier1;
            this.fft.forward((ImageBase)y, (ImageBase)yf);
            yy = CirculantTracker.imageDotProduct(y);
        } else {
            yf = xf;
            yy = xx;
        }
        CirculantTracker.elementMultConjB(xf, yf, xyf);
        this.fft.inverse((ImageBase)xyf, (ImageBase)xy);
        CirculantTracker.circshift(xy, this.tmpReal1);
        CirculantTracker.gaussianKernel(xx, yy, this.tmpReal1, sigma, k);
    }

    public static void circshift(GrayF64 a, GrayF64 b) {
        int w2 = a.width / 2;
        int h2 = b.height / 2;
        for (int y = 0; y < a.height; ++y) {
            int yy = (y + h2) % a.height;
            for (int x = 0; x < a.width; ++x) {
                int xx = (x + w2) % a.width;
                b.set(xx, yy, a.get(x, y));
            }
        }
    }

    public static double imageDotProduct(GrayF64 a) {
        double total = 0.0;
        int N = a.width * a.height;
        for (int index = 0; index < N; ++index) {
            double value = a.data[index];
            total += value * value;
        }
        return total;
    }

    public static void elementMultConjB(InterleavedF64 a, InterleavedF64 b, InterleavedF64 output) {
        for (int y = 0; y < a.height; ++y) {
            int index = a.startIndex + y * a.stride;
            int x = 0;
            while (x < a.width) {
                double realA = a.data[index];
                double imgA = a.data[index + 1];
                double realB = b.data[index];
                double imgB = b.data[index + 1];
                output.data[index] = realA * realB + imgA * imgB;
                output.data[index + 1] = -realA * imgB + imgA * realB;
                ++x;
                index += 2;
            }
        }
    }

    protected static void computeAlphas(InterleavedF64 yf, InterleavedF64 kf, double lambda, InterleavedF64 alphaf) {
        for (int y = 0; y < kf.height; ++y) {
            int index = yf.startIndex + y * yf.stride;
            int x = 0;
            while (x < kf.width) {
                double a = yf.data[index];
                double b = yf.data[index + 1];
                double c = kf.data[index] + lambda;
                double d = kf.data[index + 1];
                double bottom = c * c + d * d;
                alphaf.data[index] = (a * c + b * d) / bottom;
                alphaf.data[index + 1] = (b * c - a * d) / bottom;
                ++x;
                index += 2;
            }
        }
    }

    protected static void gaussianKernel(double xx, double yy, GrayF64 xy, double sigma, GrayF64 output) {
        double sigma2 = sigma * sigma;
        double N = xy.width * xy.height;
        for (int y = 0; y < xy.height; ++y) {
            int index = xy.startIndex + y * xy.stride;
            int x = 0;
            while (x < xy.width) {
                double v;
                double value = (xx + yy - 2.0 * xy.data[index]) / N;
                output.data[index] = v = Math.exp(-Math.max(0.0, value) / sigma2);
                ++x;
                ++index;
            }
        }
    }

    protected void get_subwindow(T image, GrayF64 output) {
        this.interp.setImage(image);
        int index = 0;
        for (int y = 0; y < this.workRegionSize; ++y) {
            float yy = this.regionTrack.y0 + (float)y * this.stepY;
            for (int x = 0; x < this.workRegionSize; ++x) {
                float xx = this.regionTrack.x0 + (float)x * this.stepX;
                output.data[index++] = this.interp.isInFastBounds(xx, yy) ? (double)this.interp.get_fast(xx, yy) : (BoofMiscOps.checkInside(image, (float)xx, (float)yy) ? (double)this.interp.get(xx, yy) : (double)this.rand.nextFloat() * this.maxPixelValue);
            }
        }
        PixelMath.divide((GrayF64)output, (double)this.maxPixelValue, (GrayF64)output);
        PixelMath.plus((GrayF64)output, (double)-0.5, (GrayF64)output);
        PixelMath.multiply((GrayF64)output, (GrayF64)this.cosine, (GrayF64)output);
    }

    public RectangleLength2D_F32 getTargetLocation() {
        return this.regionOut;
    }

    public GrayF64 getTargetTemplate() {
        return this.template;
    }

    public GrayF64 getResponse() {
        return this.response;
    }
}

