/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.fiducial.CalibrationFiducialDetector;
import boofcv.abst.fiducial.SquareBinary_to_FiducialDetector;
import boofcv.abst.fiducial.SquareImage_to_FiducialDetector;
import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.fiducial.calib.ConfigCircleAsymmetricGrid;
import boofcv.abst.fiducial.calib.ConfigCircleRegularGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGridBinary;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.square.DetectFiducialSquareBinary;
import boofcv.alg.fiducial.square.DetectFiducialSquareImage;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.factory.fiducial.ConfigFiducialBinary;
import boofcv.factory.fiducial.ConfigFiducialImage;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.struct.image.ImageGray;

public class FactoryFiducial {
    public static <T extends ImageGray<T>> SquareBinary_to_FiducialDetector<T> squareBinary(ConfigFiducialBinary configFiducial, ConfigThreshold configThreshold, Class<T> imageType) {
        if (configThreshold == null) {
            configThreshold = ConfigThreshold.local((ThresholdType)ThresholdType.LOCAL_SQUARE, (int)10);
        }
        configFiducial.checkValidity();
        configFiducial.squareDetector.clockwise = false;
        InputToBinary binary = FactoryThresholdBinary.threshold((ConfigThreshold)configThreshold, imageType);
        BinaryPolygonDetector squareDetector = FactoryShapeDetector.polygon((ConfigPolygonDetector)configFiducial.squareDetector, imageType);
        DetectFiducialSquareBinary<T> alg = new DetectFiducialSquareBinary<T>(configFiducial.gridWidth, configFiducial.borderWidthFraction, configFiducial.minimumBlackBorderFraction, binary, squareDetector, imageType);
        alg.setAmbiguityThreshold(configFiducial.ambiguousThreshold);
        return new SquareBinary_to_FiducialDetector<T>(alg, configFiducial.targetWidth);
    }

    public static <T extends ImageGray<T>> SquareImage_to_FiducialDetector<T> squareImage(ConfigFiducialImage configFiducial, ConfigThreshold configThreshold, Class<T> imageType) {
        if (configThreshold == null) {
            configThreshold = ConfigThreshold.local((ThresholdType)ThresholdType.LOCAL_SQUARE, (int)10);
        }
        configFiducial.squareDetector.clockwise = false;
        InputToBinary binary = FactoryThresholdBinary.threshold((ConfigThreshold)configThreshold, imageType);
        BinaryPolygonDetector squareDetector = FactoryShapeDetector.polygon((ConfigPolygonDetector)configFiducial.squareDetector, imageType);
        DetectFiducialSquareImage<T> alg = new DetectFiducialSquareImage<T>(binary, squareDetector, configFiducial.borderWidthFraction, configFiducial.minimumBlackBorderFraction, configFiducial.maxErrorFraction, imageType);
        return new SquareImage_to_FiducialDetector<T>(alg);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibChessboard(ConfigChessboard config, Class<T> imageType) {
        config.refineWithCorners = false;
        return new CalibrationFiducialDetector<T>(config, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibSquareGrid(ConfigSquareGrid config, Class<T> imageType) {
        config.refineWithCorners = false;
        return new CalibrationFiducialDetector<T>(config, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibSquareGridBinary(ConfigSquareGridBinary config, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibCircleAsymGrid(ConfigCircleAsymmetricGrid config, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, imageType);
    }

    public static <T extends ImageGray<T>> CalibrationFiducialDetector<T> calibCircleRegularGrid(ConfigCircleRegularGrid config, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, imageType);
    }
}

