/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.alg.tracker.meanshift.TrackerMeanShiftLikelihood;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.Rectangle2D_F64;
import georegression.struct.shapes.RectangleLength2D_I32;

public class Msl_to_TrackerObjectQuad<T extends ImageBase<T>>
implements TrackerObjectQuad<T> {
    TrackerMeanShiftLikelihood<T> tracker;
    PixelLikelihood<T> likelihood;
    ImageType<T> type;
    Rectangle2D_F64 rect = new Rectangle2D_F64();
    RectangleLength2D_I32 target = new RectangleLength2D_I32();

    public Msl_to_TrackerObjectQuad(TrackerMeanShiftLikelihood<T> tracker, PixelLikelihood<T> likelihood, ImageType<T> imageType) {
        this.tracker = tracker;
        this.likelihood = likelihood;
        this.type = imageType;
    }

    @Override
    public boolean initialize(T image, Quadrilateral_F64 location) {
        UtilPolygons2D_F64.bounding((Quadrilateral_F64)location, (Rectangle2D_F64)this.rect);
        this.target.x0 = (int)this.rect.p0.x;
        this.target.y0 = (int)this.rect.p0.y;
        this.target.width = (int)this.rect.getWidth() + 1;
        this.target.height = (int)this.rect.getHeight() + 1;
        this.likelihood.setImage(image);
        this.likelihood.createModel(this.target);
        this.tracker.initialize(image, this.target);
        return true;
    }

    @Override
    public void hint(Quadrilateral_F64 hint) {
        UtilPolygons2D_F64.bounding((Quadrilateral_F64)hint, (Rectangle2D_F64)this.rect);
        this.target.x0 = (int)this.rect.p0.x;
        this.target.y0 = (int)this.rect.p0.y;
        this.target.width = (int)this.rect.getWidth() + 1;
        this.target.height = (int)this.rect.getHeight() + 1;
        this.tracker.setTrackLocation(this.target);
    }

    @Override
    public boolean process(T image, Quadrilateral_F64 results) {
        if (!this.tracker.process(image)) {
            return false;
        }
        RectangleLength2D_I32 rect = this.tracker.getLocation();
        UtilPolygons2D_F64.convert((RectangleLength2D_I32)rect, (Quadrilateral_F64)results);
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.type;
    }

    @Override
    public TrackerMeanShiftLikelihood<T> getLowLevelTracker() {
        return this.tracker;
    }

    public PixelLikelihood<T> getLikelihood() {
        return this.likelihood;
    }
}

