/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.abst.filter.binary.BinaryContourFinder;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.calib.circle.DetectCircleGrid;
import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoGrid;
import boofcv.alg.fiducial.calib.circle.EllipseClustersIntoRegularGrid;
import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetector;
import boofcv.struct.image.ImageGray;
import georegression.struct.shapes.EllipseRotated_F64;

public class DetectCircleRegularGrid<T extends ImageGray<T>>
extends DetectCircleGrid<T> {
    private double[] closestCorner = new double[4];

    public DetectCircleRegularGrid(int numRows, int numCols, InputToBinary<T> inputToBinary, BinaryEllipseDetector<T> ellipseDetector, EllipsesIntoClusters clustering) {
        super(numRows, numCols, inputToBinary, ellipseDetector, clustering, new EllipseClustersIntoRegularGrid());
    }

    @Override
    protected void configureContourDetector(T gray) {
        int diameter = Math.max(((ImageGray)gray).width, ((ImageGray)gray).height) / Math.max(this.numCols, this.numRows);
        BinaryContourFinder contourFinder = this.ellipseDetector.getEllipseDetector().getContourFinder();
        contourFinder.setMaxContour((int)(Math.PI * (double)diameter) * 2);
        contourFinder.setSaveInnerContour(false);
    }

    @Override
    public int totalEllipses(int numRows, int numCols) {
        return numRows * numCols;
    }

    @Override
    protected void putGridIntoCanonical(EllipseClustersIntoGrid.Grid g) {
        if (g.columns != this.numCols) {
            this.rotateGridCCW(g);
        }
        if (DetectCircleRegularGrid.isClockWise(g)) {
            this.flipHorizontal(g);
        }
        if (g.columns == g.rows) {
            int i;
            this.closestCorner[0] = g.get((int)0, (int)0).center.normSq();
            this.closestCorner[1] = g.get((int)(this.numRows - 1), (int)0).center.normSq();
            this.closestCorner[2] = g.get((int)(this.numRows - 1), (int)(this.numCols - 1)).center.normSq();
            this.closestCorner[3] = g.get((int)0, (int)(this.numCols - 1)).center.normSq();
            int best = 0;
            for (i = 0; i < 4; ++i) {
                if (!(this.closestCorner[i] < this.closestCorner[best])) continue;
                best = i;
            }
            for (i = 0; i < best; ++i) {
                this.rotateGridCCW(g);
            }
        } else {
            double d00 = g.get((int)0, (int)0).center.normSq();
            double d11 = g.get((int)(this.numRows - 1), (int)(this.numCols - 1)).center.normSq();
            if (d11 < d00) {
                this.rotateGridCCW(g);
                this.rotateGridCCW(g);
            }
        }
    }

    private static boolean isClockWise(EllipseClustersIntoGrid.Grid g) {
        EllipseRotated_F64 v00 = g.get(0, 0);
        EllipseRotated_F64 v02 = g.get(0, 1);
        EllipseRotated_F64 v20 = g.get(1, 0);
        double a_x = v02.center.x - v00.center.x;
        double b_y = v20.center.y - v00.center.y;
        double a_y = v02.center.y - v00.center.y;
        double b_x = v20.center.x - v00.center.x;
        return a_x * b_y - a_y * b_x < 0.0;
    }
}

