/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.circle;

import boofcv.alg.fiducial.calib.circle.EllipsesIntoClusters;
import georegression.metric.UtilAngle;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseRotated_F64;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.ddogleg.sorting.QuickSortComparator;
import org.ddogleg.struct.FastQueue;

public abstract class EllipseClustersIntoGrid {
    protected FastQueue<Grid> foundGrids = new FastQueue(Grid.class, true);
    protected static double MAX_LINE_ANGLE_CHANGE = UtilAngle.degreeToRadian((float)30.0f);
    protected FastQueue<NodeInfo> listInfo = new FastQueue(NodeInfo.class, true);
    protected QuickSortComparator<Edge> sorter;
    protected FastQueue<NodeInfo> contour = new FastQueue(NodeInfo.class, false);
    protected boolean verbose = false;

    public EllipseClustersIntoGrid() {
        this.sorter = new QuickSortComparator((Comparator)new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                if (o1.angle < o2.angle) {
                    return -1;
                }
                if (o1.angle > o2.angle) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public abstract void process(List<EllipseRotated_F64> var1, List<List<EllipsesIntoClusters.Node>> var2);

    protected static List<NodeInfo> findLine(NodeInfo seed, NodeInfo next, int clusterSize, List<NodeInfo> line, boolean ccw) {
        if (next == null) {
            return null;
        }
        if (line == null) {
            line = new ArrayList<NodeInfo>();
        } else {
            line.clear();
        }
        next.marked = true;
        double anglePrev = EllipseClustersIntoGrid.direction(next, seed);
        double prevDist = next.ellipse.center.distance((GeoTuple2D_F64)seed.ellipse.center);
        line.add(seed);
        line.add(next);
        NodeInfo previous = seed;
        for (int i = 0; i < clusterSize + 1; ++i) {
            double bestScore = Double.MAX_VALUE;
            double bestDistance = Double.MAX_VALUE;
            double bestAngle = Double.NaN;
            double closestDistance = Double.MAX_VALUE;
            NodeInfo best = null;
            double previousLength = next.ellipse.center.distance((GeoTuple2D_F64)previous.ellipse.center);
            for (int j = 0; j < next.edges.size(); ++j) {
                double angleDist;
                double angle = ((Edge)next.edges.get((int)j)).angle;
                NodeInfo c = ((Edge)next.edges.get((int)j)).target;
                if (c.marked) continue;
                double candidateLength = next.ellipse.center.distance((GeoTuple2D_F64)c.ellipse.center);
                double ratioLengths = previousLength / candidateLength;
                double ratioSize = previous.ellipse.a / c.ellipse.a;
                if (ratioLengths > 1.0) {
                    ratioLengths = 1.0 / ratioLengths;
                    ratioSize = 1.0 / ratioSize;
                }
                if (Math.abs(ratioLengths - ratioSize) > 0.4) continue;
                double d = angleDist = ccw ? UtilAngle.distanceCCW((double)anglePrev, (double)angle) : UtilAngle.distanceCW((double)anglePrev, (double)angle);
                if (!(angleDist <= Math.PI + MAX_LINE_ANGLE_CHANGE)) continue;
                double d2 = c.ellipse.center.distance((GeoTuple2D_F64)next.ellipse.center);
                double score = d2 / prevDist + angleDist;
                if (score < bestScore) {
                    bestDistance = d2;
                    bestScore = score;
                    bestAngle = angle;
                    best = c;
                }
                closestDistance = Math.min(d2, closestDistance);
            }
            if (best == null || bestDistance > closestDistance * 2.0) {
                return line;
            }
            best.marked = true;
            prevDist = bestDistance;
            line.add(best);
            anglePrev = UtilAngle.bound((double)(bestAngle + Math.PI));
            previous = next;
            next = best;
        }
        return null;
    }

    protected static NodeInfo selectSeedNext(NodeInfo prevSeed, NodeInfo prevNext, NodeInfo currentSeed, boolean ccw) {
        double referenceAngle = EllipseClustersIntoGrid.direction(prevNext, prevSeed);
        double bestScore = Double.MAX_VALUE;
        NodeInfo best = null;
        Point2D_F64 c = currentSeed.ellipse.center;
        for (int i = 0; i < currentSeed.edges.size(); ++i) {
            Point2D_F64 p;
            double score;
            double angleDist;
            Edge edge = (Edge)currentSeed.edges.get(i);
            if (edge.target.marked) continue;
            double angle = edge.angle;
            double d = angleDist = ccw ? UtilAngle.distanceCCW((double)referenceAngle, (double)angle) : UtilAngle.distanceCW((double)referenceAngle, (double)angle);
            if (angleDist > Math.PI + MAX_LINE_ANGLE_CHANGE || !((score = angleDist * c.distance((GeoTuple2D_F64)(p = edge.target.ellipse.center))) < bestScore)) continue;
            bestScore = score;
            best = edge.target;
        }
        if (best != null) {
            best.marked = true;
        }
        return best;
    }

    protected static NodeInfo findClosestEdge(NodeInfo n, Point2D_F64 p) {
        double bestDistance = Double.MAX_VALUE;
        NodeInfo best = null;
        for (int i = 0; i < n.edges.size(); ++i) {
            double d;
            Edge e = (Edge)n.edges.get(i);
            if (e.target.marked || !((d = e.target.ellipse.center.distance2((GeoTuple2D_F64)p)) < bestDistance)) continue;
            bestDistance = d;
            best = e.target;
        }
        return best;
    }

    boolean checkDuplicates(List<List<NodeInfo>> grid) {
        int i;
        for (i = 0; i < this.listInfo.size; ++i) {
            ((NodeInfo)this.listInfo.get((int)i)).marked = false;
        }
        for (i = 0; i < grid.size(); ++i) {
            List<NodeInfo> list = grid.get(i);
            for (int j = 0; j < list.size(); ++j) {
                NodeInfo n = list.get(j);
                if (n.marked) {
                    return true;
                }
                n.marked = true;
            }
        }
        return false;
    }

    static double direction(NodeInfo src, NodeInfo dst) {
        return Math.atan2(dst.ellipse.center.y - src.ellipse.center.y, dst.ellipse.center.x - src.ellipse.center.x);
    }

    void computeNodeInfo(List<EllipseRotated_F64> ellipses, List<EllipsesIntoClusters.Node> cluster) {
        this.listInfo.reset();
        for (int i = 0; i < cluster.size(); ++i) {
            EllipsesIntoClusters.Node n = cluster.get(i);
            EllipseRotated_F64 t = ellipses.get(n.which);
            NodeInfo info = (NodeInfo)this.listInfo.grow();
            info.reset();
            info.ellipse = t;
        }
        this.addEdgesToInfo(cluster);
        this.pruneNearlyIdenticalAngles();
        this.findLargestAnglesForAllNodes();
    }

    void addEdgesToInfo(List<EllipsesIntoClusters.Node> cluster) {
        for (int i = 0; i < cluster.size(); ++i) {
            EllipsesIntoClusters.Node n = cluster.get(i);
            NodeInfo infoA = (NodeInfo)this.listInfo.get(i);
            EllipseRotated_F64 a = infoA.ellipse;
            for (int j = 0; j < n.connections.size(); ++j) {
                NodeInfo infoB = (NodeInfo)this.listInfo.get(EllipseClustersIntoGrid.indexOf(cluster, n.connections.get(j)));
                EllipseRotated_F64 b = infoB.ellipse;
                Edge edge = (Edge)infoA.edges.grow();
                edge.target = infoB;
                edge.angle = Math.atan2(b.center.y - a.center.y, b.center.x - a.center.x);
            }
            this.sorter.sort(infoA.edges.data, infoA.edges.size);
        }
    }

    void pruneNearlyIdenticalAngles() {
        for (int i = 0; i < this.listInfo.size(); ++i) {
            NodeInfo infoN = (NodeInfo)this.listInfo.get(i);
            int j = 0;
            while (j < infoN.edges.size()) {
                int k = (j + 1) % infoN.edges.size;
                double angularDiff = UtilAngle.dist((double)((Edge)infoN.edges.get((int)j)).angle, (double)((Edge)infoN.edges.get((int)k)).angle);
                if (angularDiff < (double)UtilAngle.radian((float)5.0f)) {
                    double distK;
                    NodeInfo infoJ = ((Edge)infoN.edges.get((int)j)).target;
                    NodeInfo infoK = ((Edge)infoN.edges.get((int)k)).target;
                    double distJ = infoN.ellipse.center.distance((GeoTuple2D_F64)infoJ.ellipse.center);
                    if (distJ < (distK = infoN.ellipse.center.distance((GeoTuple2D_F64)infoK.ellipse.center))) {
                        infoN.edges.remove(k);
                        continue;
                    }
                    infoN.edges.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }

    void findLargestAnglesForAllNodes() {
        for (int i = 0; i < this.listInfo.size(); ++i) {
            NodeInfo info = (NodeInfo)this.listInfo.get(i);
            if (info.edges.size < 2) continue;
            int k = 0;
            int j = info.edges.size - 1;
            while (k < info.edges.size) {
                double angleA = ((Edge)info.edges.get((int)j)).angle;
                double angleB = ((Edge)info.edges.get((int)k)).angle;
                double distance = UtilAngle.distanceCCW((double)angleA, (double)angleB);
                if (distance > info.angleBetween) {
                    info.angleBetween = distance;
                    info.left = ((Edge)info.edges.get((int)j)).target;
                    info.right = ((Edge)info.edges.get((int)k)).target;
                }
                j = k++;
            }
        }
    }

    boolean findContour(boolean mustHaveInner) {
        NodeInfo seed = (NodeInfo)this.listInfo.get(0);
        for (int i = 1; i < this.listInfo.size(); ++i) {
            NodeInfo info = (NodeInfo)this.listInfo.get(i);
            if (!(info.angleBetween > seed.angleBetween)) continue;
            seed = info;
        }
        this.contour.reset();
        this.contour.add((Object)seed);
        seed.contour = true;
        NodeInfo prev = seed;
        NodeInfo current = seed.right;
        while (current != null && current != seed && this.contour.size() < this.listInfo.size()) {
            if (prev != current.left) {
                return false;
            }
            this.contour.add((Object)current);
            current.contour = true;
            prev = current;
            current = current.right;
        }
        return this.contour.size >= 4 && (!mustHaveInner || this.contour.size < this.listInfo.size());
    }

    public static int indexOf(List<EllipsesIntoClusters.Node> list, int value) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).which != value) continue;
            return i;
        }
        return -1;
    }

    NodeInfo selectSeedCorner() {
        NodeInfo best = null;
        double bestAngle = 0.0;
        for (int i = 0; i < this.contour.size; ++i) {
            NodeInfo info = (NodeInfo)this.contour.get(i);
            if (!(info.angleBetween > bestAngle)) continue;
            bestAngle = info.angleBetween;
            best = info;
        }
        best.marked = true;
        return best;
    }

    public FastQueue<Grid> getGrids() {
        return this.foundGrids;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static class Grid {
        public List<EllipseRotated_F64> ellipses = new ArrayList<EllipseRotated_F64>();
        public int rows;
        public int columns;

        public void reset() {
            this.columns = -1;
            this.rows = -1;
            this.ellipses.clear();
        }

        public EllipseRotated_F64 get(int row, int col) {
            return this.ellipses.get(row * this.columns + col);
        }

        public int idx(int row, int col) {
            return row * this.columns + col;
        }

        public void setShape(int rows, int columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public int getIndexOfHexEllipse(int row, int col) {
            int index = 0;
            return (index += row / 2 * this.columns + row % 2 * (this.columns / 2 + this.columns % 2)) + col / 2;
        }

        public int getIndexOfRegEllipse(int row, int col) {
            return row * this.columns + col;
        }
    }

    public static class Edge {
        NodeInfo target;
        double angle;

        public Edge() {
        }

        public Edge(NodeInfo target, double angle) {
            this.target = target;
            this.angle = angle;
        }
    }

    public static class NodeInfo {
        EllipseRotated_F64 ellipse;
        FastQueue<Edge> edges = new FastQueue(Edge.class, true);
        boolean contour;
        NodeInfo left;
        NodeInfo right;
        double angleBetween;
        boolean marked;

        public Edge findEdge(NodeInfo target) {
            for (int i = 0; i < this.edges.size; ++i) {
                if (((Edge)this.edges.get((int)i)).target != target) continue;
                return (Edge)this.edges.get(i);
            }
            return null;
        }

        public double distance(NodeInfo target) {
            return this.ellipse.center.distance((GeoTuple2D_F64)target.ellipse.center);
        }

        public void reset() {
            this.contour = false;
            this.ellipse = null;
            this.right = null;
            this.left = null;
            this.angleBetween = 0.0;
            this.marked = false;
            this.edges.reset();
        }
    }
}

