/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.fiducial.calib.squares.SquaresIntoClusters;
import boofcv.alg.shapes.polygon.DetectPolygonFromContour;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.FastQueue;

public class SquaresIntoCrossClusters
extends SquaresIntoClusters {
    public int maxNeighbors;
    double maxCornerDistance;
    double tooFarFraction = 0.3;
    private NearestNeighbor<SquareNode> search = FactoryNearestNeighbor.kdtree();
    private FastQueue<double[]> searchPoints;
    private List<SquareNode> searchSquareList = new ArrayList<SquareNode>();
    private FastQueue<NnData<SquareNode>> searchResults = new FastQueue(NnData.class, true);

    public SquaresIntoCrossClusters(double maxCornerDistance, int maxNeighbors) {
        this.maxCornerDistance = maxCornerDistance;
        int n = this.maxNeighbors = maxNeighbors > 0 ? maxNeighbors : Integer.MAX_VALUE;
        if (this.maxNeighbors == Integer.MAX_VALUE) {
            this.maxNeighbors = 0x7FFFFFFE;
        }
        this.searchPoints = new FastQueue<double[]>(double[].class, true){

            protected double[] createInstance() {
                return new double[2];
            }
        };
        this.search.init(2);
    }

    public List<List<SquareNode>> process(List<DetectPolygonFromContour.Info> squares) {
        this.recycleData();
        this.computeNodeInfo(squares);
        this.connectNodes();
        this.findClusters();
        return this.clusters.toList();
    }

    void computeNodeInfo(List<DetectPolygonFromContour.Info> squares) {
        for (int i = 0; i < squares.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.grow();
            n.reset();
            DetectPolygonFromContour.Info info = squares.get(i);
            Polygon2D_F64 polygon = info.polygon;
            if (info.borderCorners.size() > 0) {
                boolean allBorder = true;
                for (int j = 0; j < info.borderCorners.size(); ++j) {
                    if (info.borderCorners.get(j)) continue;
                    allBorder = false;
                    break;
                }
                if (allBorder) {
                    this.nodes.removeTail();
                    continue;
                }
            }
            UtilPoint2D_F64.mean((Point2D_F64[])((Point2D_F64[])polygon.vertexes.data), (int)0, (int)polygon.size(), (Point2D_F64)n.center);
            int j = 0;
            int k = polygon.size() - 1;
            while (j < polygon.size()) {
                double l = polygon.get(j).distance((GeoTuple2D_F64)polygon.get(k));
                n.largestSide = Math.max(n.largestSide, l);
                k = j++;
            }
            n.square = polygon;
            n.touch = info.borderCorners;
            n.updateArrayLength();
        }
    }

    void connectNodes() {
        this.setupSearch();
        int indexCornerList = 0;
        for (int indexNode = 0; indexNode < this.nodes.size(); ++indexNode) {
            SquareNode n = (SquareNode)this.nodes.get(indexNode);
            for (int indexLocal = 0; indexLocal < n.square.size(); ++indexLocal) {
                if (n.touch.size > 0 && n.touch.get(indexLocal)) continue;
                double[] point = (double[])this.searchPoints.get(indexCornerList++);
                this.searchResults.reset();
                this.search.findNearest(point, this.maxCornerDistance * this.maxCornerDistance, this.maxNeighbors + 1, this.searchResults);
                for (int indexResults = 0; indexResults < this.searchResults.size(); ++indexResults) {
                    NnData neighborData = (NnData)this.searchResults.get(indexResults);
                    SquareNode neighborNode = (SquareNode)neighborData.data;
                    if (neighborNode == n) continue;
                    int neighborCornerIndex = this.getCornerIndex(neighborNode, neighborData.point[0], neighborData.point[1]);
                    if (!this.candidateIsMuchCloser(n, neighborNode, neighborData.distance)) continue;
                    this.graph.checkConnect(n, indexLocal, neighborNode, neighborCornerIndex, neighborData.distance);
                }
            }
        }
    }

    int getCornerIndex(SquareNode node, double x, double y) {
        for (int i = 0; i < node.square.size(); ++i) {
            Point2D_F64 c = node.square.get(i);
            if (c.x != x || c.y != y) continue;
            return i;
        }
        throw new RuntimeException("BUG!");
    }

    private void setupSearch() {
        this.searchPoints.reset();
        this.searchSquareList.clear();
        for (int i = 0; i < this.nodes.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.get(i);
            for (int j = 0; j < n.square.size(); ++j) {
                if (n.touch.size > 0 && n.touch.get(j)) continue;
                Point2D_F64 c = n.square.get(j);
                double[] point = (double[])this.searchPoints.grow();
                point[0] = c.x;
                point[1] = c.y;
                this.searchSquareList.add(n);
            }
        }
        this.search.setPoints(this.searchPoints.toList(), this.searchSquareList);
    }

    boolean candidateIsMuchCloser(SquareNode node0, SquareNode node1, double distance2) {
        double length = Math.max(node0.largestSide, node1.largestSide) * this.tooFarFraction;
        if (distance2 > (length *= length)) {
            return false;
        }
        return distance2 <= length;
    }

    public double getMaxCornerDistance() {
        return this.maxCornerDistance;
    }

    public void setMaxCornerDistance(double maxCornerDistance) {
        this.maxCornerDistance = maxCornerDistance;
    }
}

