/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.geo.robust.GenerateHomographyLinear;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.ConvertFloatType;
import georegression.struct.homography.Homography2D_F32;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.transform.homography.HomographyPointOps_F32;
import georegression.transform.homography.HomographyPointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.struct.FastQueue;

public class QrCodeBinaryGridToPixel {
    ModelGenerator<Homography2D_F64, AssociatedPair> generator = new GenerateHomographyLinear(true);
    FastQueue<AssociatedPair> storagePairs = new FastQueue(AssociatedPair.class, true);
    List<AssociatedPair> pairs = new ArrayList<AssociatedPair>();
    FastQueue<Point2D_F64> adjustments = new FastQueue(Point2D_F64.class, true);
    Homography2D_F64 H = new Homography2D_F64();
    Homography2D_F64 Hinv = new Homography2D_F64();
    Homography2D_F32 Hinv32 = new Homography2D_F32();
    Homography2D_F32 H32 = new Homography2D_F32();
    Point2D_F64 tmp64 = new Point2D_F64();
    boolean adjustWithFeatures;

    public void setTransformFromSquare(Polygon2D_F64 square) {
        this.adjustWithFeatures = false;
        this.storagePairs.reset();
        this.pairs.clear();
        this.set(0.0f, 0.0f, square, 0);
        this.set(0.0f, 7.0f, square, 1);
        this.set(7.0f, 7.0f, square, 2);
        this.set(7.0f, 0.0f, square, 3);
        this.computeTransform();
    }

    public void addAllFeatures(QrCode qr) {
        this.adjustWithFeatures = false;
        this.storagePairs.reset();
        this.pairs.clear();
        int N = qr.getNumberOfModules();
        this.set(0.0f, 0.0f, qr.ppCorner, 0);
        this.set(0.0f, 7.0f, qr.ppCorner, 1);
        this.set(7.0f, 7.0f, qr.ppCorner, 2);
        this.set(7.0f, 0.0f, qr.ppCorner, 3);
        this.set(0.0f, N - 7, qr.ppRight, 0);
        this.set(0.0f, N, qr.ppRight, 1);
        this.set(7.0f, N, qr.ppRight, 2);
        this.set(7.0f, N - 7, qr.ppRight, 3);
        this.set(N - 7, 0.0f, qr.ppDown, 0);
        this.set(N - 7, 7.0f, qr.ppDown, 1);
        this.set(N, 7.0f, qr.ppDown, 2);
        this.set(N, 0.0f, qr.ppDown, 3);
        for (int i = 0; i < qr.alignment.size; ++i) {
            QrCode.Alignment a = (QrCode.Alignment)qr.alignment.get(i);
            AssociatedPair p = (AssociatedPair)this.storagePairs.grow();
            p.set(a.pixel.x, a.pixel.y, (double)((float)a.moduleX + 0.5f), (double)((float)a.moduleY + 0.5f));
            this.pairs.add(p);
        }
    }

    public void removeOutsideCornerFeatures() {
        if (this.pairs.size() != this.storagePairs.size) {
            throw new RuntimeException("This can only be called when all the features have been added");
        }
        this.pairs.remove(11);
        this.pairs.remove(5);
        this.pairs.remove(0);
    }

    public boolean removeFeatureWithLargestError() {
        int selected = -1;
        double largestError = 0.0;
        for (int i = 0; i < this.pairs.size(); ++i) {
            AssociatedPair p = this.pairs.get(i);
            HomographyPointOps_F64.transform((Homography2D_F64)this.Hinv, (double)p.p2.x, (double)p.p2.y, (Point2D_F64)this.tmp64);
            double dx = this.tmp64.x - p.p1.x;
            double dy = this.tmp64.y - p.p1.y;
            double error = dx * dx + dy * dy;
            if (!(error > largestError)) continue;
            largestError = error;
            selected = i;
        }
        if (selected != -1 && largestError > 4.0) {
            this.pairs.remove(selected);
            return true;
        }
        return false;
    }

    public void computeTransform() {
        this.generator.generate(this.pairs, (Object)this.H);
        this.H.invert(this.Hinv);
        ConvertFloatType.convert((Homography2D_F64)this.Hinv, (Homography2D_F32)this.Hinv32);
        ConvertFloatType.convert((Homography2D_F64)this.H, (Homography2D_F32)this.H32);
        this.adjustments.reset();
        if (this.adjustWithFeatures) {
            for (int i = 0; i < this.pairs.size(); ++i) {
                AssociatedPair p = this.pairs.get(i);
                Point2D_F64 a = (Point2D_F64)this.adjustments.grow();
                HomographyPointOps_F64.transform((Homography2D_F64)this.Hinv, (double)p.p2.x, (double)p.p2.y, (Point2D_F64)this.tmp64);
                a.x = p.p1.x - this.tmp64.x;
                a.y = p.p1.y - this.tmp64.y;
            }
        }
    }

    private void set(float row, float col, Polygon2D_F64 polygon, int corner) {
        AssociatedPair p = (AssociatedPair)this.storagePairs.grow();
        Point2D_F64 c = polygon.get(corner);
        p.set(c.x, c.y, (double)col, (double)row);
        this.pairs.add(p);
    }

    public final void imageToGrid(float x, float y, Point2D_F32 grid) {
        HomographyPointOps_F32.transform((Homography2D_F32)this.H32, (float)x, (float)y, (Point2D_F32)grid);
    }

    public final void imageToGrid(double x, double y, Point2D_F64 grid) {
        HomographyPointOps_F64.transform((Homography2D_F64)this.H, (double)x, (double)y, (Point2D_F64)grid);
    }

    public final void gridToImage(float row, float col, Point2D_F32 pixel) {
        HomographyPointOps_F32.transform((Homography2D_F32)this.Hinv32, (float)col, (float)row, (Point2D_F32)pixel);
        if (this.adjustWithFeatures) {
            int closest = -1;
            double best = Double.MAX_VALUE;
            for (int i = 0; i < this.pairs.size(); ++i) {
                double d = this.pairs.get((int)i).p2.distance2((double)col, (double)row);
                if (!(d < best)) continue;
                best = d;
                closest = i;
            }
            Point2D_F64 adj = (Point2D_F64)this.adjustments.get(closest);
            pixel.x = (float)((double)pixel.x + adj.x);
            pixel.y = (float)((double)pixel.y + adj.y);
        }
    }

    public void setAdjustWithFeatures(boolean adjustWithFeatures) {
        this.adjustWithFeatures = adjustWithFeatures;
    }

    public void setHomographyInv(Homography2D_F64 Hinv) {
        this.Hinv.set(Hinv);
        ConvertFloatType.convert((Homography2D_F64)Hinv, (Homography2D_F32)this.Hinv32);
    }
}

