/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeEncoder;
import boofcv.alg.fiducial.qrcode.ReidSolomonCodes;
import java.io.UnsupportedEncodingException;
import org.ddogleg.struct.GrowQueue_I8;

public class QrCodeDecoderBits {
    ReidSolomonCodes rscodes = new ReidSolomonCodes(8, 285);
    GrowQueue_I8 message = new GrowQueue_I8();
    GrowQueue_I8 ecc = new GrowQueue_I8();
    StringBuilder workString = new StringBuilder();

    public boolean applyErrorCorrection(QrCode qr) {
        QrCode.VersionInfo info = QrCode.VERSION_INFO[qr.version];
        QrCode.BlockInfo block = info.levels.get((Object)qr.error);
        int wordsBlockAllA = block.codewords;
        int wordsBlockDataA = block.dataCodewords;
        int wordsEcc = wordsBlockAllA - wordsBlockDataA;
        int numBlocksA = block.blocks;
        int wordsBlockAllB = wordsBlockAllA + 1;
        int wordsBlockDataB = wordsBlockDataA + 1;
        int numBlocksB = (info.codewords - wordsBlockAllA * numBlocksA) / wordsBlockAllB;
        int totalBlocks = numBlocksA + numBlocksB;
        int totalDataBytes = wordsBlockDataA * numBlocksA + wordsBlockDataB * numBlocksB;
        qr.corrected = new byte[totalDataBytes];
        this.ecc.resize(wordsEcc);
        this.rscodes.generator(wordsEcc);
        if (!this.decodeBlocks(qr, wordsBlockDataA, numBlocksA, 0, 0, totalDataBytes, totalBlocks)) {
            return false;
        }
        return this.decodeBlocks(qr, wordsBlockDataB, numBlocksB, numBlocksA * wordsBlockDataA, numBlocksA, totalDataBytes, totalBlocks);
    }

    private boolean decodeBlocks(QrCode qr, int bytesInDataBlock, int numberOfBlocks, int bytesDataRead, int offsetBlock, int offsetEcc, int stride) {
        this.message.resize(bytesInDataBlock);
        for (int idxBlock = 0; idxBlock < numberOfBlocks; ++idxBlock) {
            this.copyFromRawData(qr.rawbits, this.message, this.ecc, offsetBlock + idxBlock, stride, offsetEcc);
            QrCodeEncoder.flipBits8(this.message);
            QrCodeEncoder.flipBits8(this.ecc);
            if (!this.rscodes.correct(this.message, this.ecc)) {
                return false;
            }
            QrCodeEncoder.flipBits8(this.message);
            System.arraycopy(this.message.data, 0, qr.corrected, bytesDataRead, this.message.size);
            bytesDataRead += this.message.size;
        }
        return true;
    }

    private void copyFromRawData(byte[] input, GrowQueue_I8 message, GrowQueue_I8 ecc, int offsetBlock, int stride, int offsetEcc) {
        int i;
        for (i = 0; i < message.size; ++i) {
            message.data[i] = input[i * stride + offsetBlock];
        }
        for (i = 0; i < ecc.size; ++i) {
            ecc.data[i] = input[i * stride + offsetBlock + offsetEcc];
        }
    }

    public boolean decodeMessage(QrCode qr) {
        int lengthBytes;
        PackedBits8 bits = new PackedBits8();
        bits.data = qr.corrected;
        bits.size = qr.corrected.length * 8;
        this.workString.setLength(0);
        qr.message = null;
        int location = 0;
        while (location + 4 <= bits.size) {
            int modeBits = bits.read(location, 4, true);
            location += 4;
            if (modeBits == 0) break;
            QrCode.Mode mode = QrCode.Mode.lookup(modeBits);
            qr.mode = this.updateModeLogic(qr.mode, mode);
            switch (mode) {
                case NUMERIC: {
                    location = this.decodeNumeric(qr, bits, location);
                    break;
                }
                case ALPHANUMERIC: {
                    location = this.decodeAlphanumeric(qr, bits, location);
                    break;
                }
                case BYTE: {
                    location = this.decodeByte(qr, bits, location);
                    break;
                }
                case KANJI: {
                    location = this.decodeKanji(qr, bits, location);
                    break;
                }
                case ECI: {
                    qr.failureCause = QrCode.Failure.UNKNOWN_MODE;
                    return false;
                }
                case FNC1_FIRST: 
                case FNC1_SECOND: {
                    break;
                }
                default: {
                    qr.failureCause = QrCode.Failure.UNKNOWN_MODE;
                    return false;
                }
            }
            if (location >= 0) continue;
            return false;
        }
        if (!this.checkPaddingBytes(qr, lengthBytes = (location = QrCodeDecoderBits.alignToBytes(location)) / 8)) {
            qr.failureCause = QrCode.Failure.READING_PADDING;
            return false;
        }
        qr.message = this.workString.toString();
        return true;
    }

    private QrCode.Mode updateModeLogic(QrCode.Mode current, QrCode.Mode candidate) {
        if (candidate.ordinal() <= QrCode.Mode.KANJI.ordinal()) {
            current = current.ordinal() > candidate.ordinal() ? current : candidate;
        }
        return current;
    }

    public static int alignToBytes(int lengthBits) {
        return lengthBits + (8 - lengthBits % 8) % 8;
    }

    boolean checkPaddingBytes(QrCode qr, int lengthBytes) {
        boolean a = true;
        for (int i = lengthBytes; i < qr.corrected.length; ++i) {
            if (a) {
                if (55 != (qr.corrected[i] & 0xFF)) {
                    return false;
                }
            } else if (136 != (qr.corrected[i] & 0xFF)) {
                if (55 == (qr.corrected[i] & 0xFF)) {
                    a = true;
                } else {
                    return false;
                }
            }
            a = !a;
        }
        return true;
    }

    private int decodeNumeric(QrCode qr, PackedBits8 data, int bitLocation) {
        int valB;
        int valA;
        int chunk;
        int lengthBits = QrCodeEncoder.getLengthBitsNumeric(qr.version);
        int length = data.read(bitLocation, lengthBits, true);
        bitLocation += lengthBits;
        while (length >= 3) {
            if (data.size < bitLocation + 10) {
                qr.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            chunk = data.read(bitLocation, 10, true);
            bitLocation += 10;
            valA = chunk / 100;
            valB = (chunk - valA * 100) / 10;
            int valC = chunk - valA * 100 - valB * 10;
            this.workString.append((char)(valA + 48));
            this.workString.append((char)(valB + 48));
            this.workString.append((char)(valC + 48));
            length -= 3;
        }
        if (length == 2) {
            if (data.size < bitLocation + 7) {
                qr.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            chunk = data.read(bitLocation, 7, true);
            bitLocation += 7;
            valA = chunk / 10;
            valB = chunk - valA * 10;
            this.workString.append((char)(valA + 48));
            this.workString.append((char)(valB + 48));
        } else if (length == 1) {
            if (data.size < bitLocation + 4) {
                qr.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            int valA2 = data.read(bitLocation, 4, true);
            bitLocation += 4;
            this.workString.append((char)(valA2 + 48));
        }
        return bitLocation;
    }

    private int decodeAlphanumeric(QrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = QrCodeEncoder.getLengthBitsAlphanumeric(qr.version);
        int length = data.read(bitLocation, lengthBits, true);
        bitLocation += lengthBits;
        while (length >= 2) {
            if (data.size < bitLocation + 11) {
                qr.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            int chunk = data.read(bitLocation, 11, true);
            bitLocation += 11;
            int valA = chunk / 45;
            int valB = chunk - valA * 45;
            this.workString.append(QrCodeEncoder.valueToAlphanumeric(valA));
            this.workString.append(QrCodeEncoder.valueToAlphanumeric(valB));
            length -= 2;
        }
        if (length == 1) {
            if (data.size < bitLocation + 6) {
                qr.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            int valA = data.read(bitLocation, 6, true);
            bitLocation += 6;
            this.workString.append(QrCodeEncoder.valueToAlphanumeric(valA));
        }
        return bitLocation;
    }

    private int decodeByte(QrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = QrCodeEncoder.getLengthBitsBytes(qr.version);
        int length = data.read(bitLocation, lengthBits, true);
        if (length * 8 > data.size - (bitLocation += lengthBits)) {
            qr.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
            return -1;
        }
        byte[] rawdata = new byte[length];
        for (int i = 0; i < length; ++i) {
            rawdata[i] = (byte)data.read(bitLocation, 8, true);
            bitLocation += 8;
        }
        try {
            this.workString.append(new String(rawdata, "JIS"));
        }
        catch (UnsupportedEncodingException ignored) {
            qr.failureCause = QrCode.Failure.JIS_UNAVAILABLE;
            return -1;
        }
        return bitLocation;
    }

    private int decodeKanji(QrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = QrCodeEncoder.getLengthBitsKanji(qr.version);
        int length = data.read(bitLocation, lengthBits, true);
        bitLocation += lengthBits;
        byte[] rawdata = new byte[length * 2];
        for (int i = 0; i < length; ++i) {
            if (data.size < bitLocation + 13) {
                qr.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return -1;
            }
            int letter = data.read(bitLocation, 13, true);
            bitLocation += 13;
            letter = (letter = letter / 192 << 8 | letter % 192) < 7936 ? (letter += 33088) : (letter += 49472);
            rawdata[i * 2] = (byte)(letter >> 8);
            rawdata[i * 2 + 1] = (byte)letter;
        }
        try {
            this.workString.append(new String(rawdata, "Shift_JIS"));
        }
        catch (UnsupportedEncodingException ignored) {
            qr.failureCause = QrCode.Failure.KANJI_UNAVAILABLE;
            return -1;
        }
        return bitLocation;
    }
}

