/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeGenerator;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;

public class QrCodeGeneratorImage
extends QrCodeGenerator {
    GrayU8 gray = new GrayU8(1, 1);
    int pixelsPerModule;

    public QrCodeGeneratorImage(int pixelsPerModule) {
        super(1.0);
        this.pixelsPerModule = pixelsPerModule;
    }

    @Override
    public void init() {
        int width = this.pixelsPerModule * this.numModules;
        this.gray.reshape(width, width);
        ImageMiscOps.fill((GrayI8)this.gray, (int)255);
    }

    @Override
    public void render(QrCode qr) {
        super.render(qr);
        this.adjustSize(qr.ppRight);
        this.adjustSize(qr.ppCorner);
        this.adjustSize(qr.ppDown);
        this.adjustSize(qr.bounds);
        for (int i = 0; i < qr.alignment.size(); ++i) {
            QrCode.Alignment a = (QrCode.Alignment)qr.alignment.get(i);
            a.pixel.x *= (double)this.gray.width;
            a.pixel.y *= (double)this.gray.height;
            a.threshold = 125.0;
        }
        qr.threshRight = 125.0;
        qr.threshCorner = 125.0;
        qr.threshDown = 125.0;
    }

    private void adjustSize(Polygon2D_F64 poly) {
        for (int i = 0; i < poly.size(); ++i) {
            Point2D_F64 p = poly.get(i);
            p.x *= (double)this.gray.width;
            p.y *= (double)this.gray.width;
        }
    }

    @Override
    public void square(double x0, double y0, double width) {
        int pixelX = (int)(x0 * (double)this.gray.width + 0.5);
        int pixelY = (int)(y0 * (double)this.gray.width + 0.5);
        int pixelsWidth = (int)(width * (double)this.gray.width + 0.5);
        ImageMiscOps.fillRectangle((GrayI8)this.gray, (int)0, (int)pixelX, (int)pixelY, (int)pixelsWidth, (int)pixelsWidth);
    }

    @Override
    public void square(double x0, double y0, double width0, double thickness) {
        int X0 = (int)(x0 * (double)this.gray.width + 0.5);
        int Y0 = (int)(y0 * (double)this.gray.width + 0.5);
        int WIDTH = (int)(width0 * (double)this.gray.width + 0.5);
        int THICKNESS = (int)(thickness * (double)this.gray.width + 0.5);
        ImageMiscOps.fillRectangle((GrayI8)this.gray, (int)0, (int)X0, (int)Y0, (int)WIDTH, (int)THICKNESS);
        ImageMiscOps.fillRectangle((GrayI8)this.gray, (int)0, (int)X0, (int)(Y0 + WIDTH - THICKNESS), (int)WIDTH, (int)THICKNESS);
        ImageMiscOps.fillRectangle((GrayI8)this.gray, (int)0, (int)X0, (int)(Y0 + THICKNESS), (int)THICKNESS, (int)(WIDTH - THICKNESS * 2));
        ImageMiscOps.fillRectangle((GrayI8)this.gray, (int)0, (int)(X0 + WIDTH - THICKNESS), (int)(Y0 + THICKNESS), (int)THICKNESS, (int)(WIDTH - THICKNESS * 2));
    }

    public GrayU8 getGray() {
        return this.gray;
    }
}

