/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import java.util.ArrayList;
import java.util.List;

public abstract class QrCodeMaskPattern {
    public static final QrCodeMaskPattern M000 = new M000();
    public static final QrCodeMaskPattern M001 = new M001();
    public static final QrCodeMaskPattern M010 = new M010();
    public static final QrCodeMaskPattern M011 = new M011();
    public static final QrCodeMaskPattern M100 = new M100();
    public static final QrCodeMaskPattern M101 = new M101();
    public static final QrCodeMaskPattern M110 = new M110();
    public static final QrCodeMaskPattern M111 = new M111();
    int bits;

    public static List<QrCodeMaskPattern> values() {
        ArrayList<QrCodeMaskPattern> values = new ArrayList<QrCodeMaskPattern>();
        values.add(M001);
        values.add(M010);
        values.add(M011);
        values.add(M100);
        values.add(M101);
        values.add(M110);
        values.add(M111);
        return values;
    }

    public QrCodeMaskPattern(int bits) {
        this.bits = bits;
    }

    public abstract int apply(int var1, int var2, int var3);

    public static QrCodeMaskPattern lookupMask(int maskPattern) {
        switch (maskPattern) {
            case 0: {
                return M000;
            }
            case 1: {
                return M001;
            }
            case 2: {
                return M010;
            }
            case 3: {
                return M011;
            }
            case 4: {
                return M100;
            }
            case 5: {
                return M101;
            }
            case 6: {
                return M110;
            }
            case 7: {
                return M111;
            }
        }
        throw new RuntimeException("Unknown mask: " + maskPattern);
    }

    public static QrCodeMaskPattern lookupMask(String maskPattern) {
        switch (maskPattern) {
            case "000": {
                return M000;
            }
            case "001": {
                return M001;
            }
            case "010": {
                return M010;
            }
            case "011": {
                return M011;
            }
            case "100": {
                return M100;
            }
            case "101": {
                return M101;
            }
            case "110": {
                return M110;
            }
            case "111": {
                return M111;
            }
        }
        throw new RuntimeException("Unknown mask: " + maskPattern);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static class M111
    extends QrCodeMaskPattern {
        public M111() {
            super(7);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = (row * col % 3 + (row + col) % 2) % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class M110
    extends QrCodeMaskPattern {
        public M110() {
            super(6);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue ^ ((row * col % 2 + row * col % 3) % 2 == 0 ? 1 : 0);
        }
    }

    static class M101
    extends QrCodeMaskPattern {
        public M101() {
            super(5);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue ^ (row * col % 2 + row * col % 3 == 0 ? 1 : 0);
        }
    }

    static class M100
    extends QrCodeMaskPattern {
        public M100() {
            super(4);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = (row / 2 + col / 3) % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class M011
    extends QrCodeMaskPattern {
        public M011() {
            super(3);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue ^ ((row + col) % 3 == 0 ? 1 : 0);
        }
    }

    static class M010
    extends QrCodeMaskPattern {
        public M010() {
            super(2);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue ^ (col % 3 == 0 ? 1 : 0);
        }
    }

    static class M001
    extends QrCodeMaskPattern {
        public M001() {
            super(1);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = row % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class M000
    extends QrCodeMaskPattern {
        public M000() {
            super(0);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            int mask = (row + col) % 2;
            return bitValue ^ ~mask & 1;
        }
    }

    static class NONE
    extends QrCodeMaskPattern {
        public NONE(int bits) {
            super(bits);
        }

        @Override
        public int apply(int row, int col, int bitValue) {
            return bitValue;
        }
    }
}

