/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.meanshift;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.sparse.SparseImageSample_F32;
import georegression.struct.shapes.Rectangle2D_I32;
import georegression.struct.shapes.RectangleLength2D_I32;

public class TrackerMeanShiftLikelihood<T extends ImageBase<T>> {
    private SparseImageSample_F32<T> targetModel;
    private GrayF32 pdf = new GrayF32(1, 1);
    private RectangleLength2D_I32 location = new RectangleLength2D_I32();
    private Rectangle2D_I32 dirty = new Rectangle2D_I32();
    private int maxIterations;
    private float minimumSum;
    private float minFractionDrop;
    private boolean failed;

    public TrackerMeanShiftLikelihood(PixelLikelihood<T> targetModel, int maxIterations, float minFractionDrop) {
        this.targetModel = targetModel;
        this.maxIterations = maxIterations;
        this.minFractionDrop = minFractionDrop;
    }

    public void initialize(T image, RectangleLength2D_I32 initial) {
        if (!image.isInBounds(initial.x0, initial.y0)) {
            throw new IllegalArgumentException("Initial rectangle is out of bounds!");
        }
        if (!image.isInBounds(initial.x0 + initial.width, initial.y0 + initial.height)) {
            throw new IllegalArgumentException("Initial rectangle is out of bounds!");
        }
        this.pdf.reshape(((ImageBase)image).width, ((ImageBase)image).height);
        ImageMiscOps.fill((GrayF32)this.pdf, (float)-1.0f);
        this.setTrackLocation(initial);
        this.failed = false;
        this.minimumSum = 0.0f;
        this.targetModel.setImage(image);
        for (int y = 0; y < initial.height; ++y) {
            for (int x = 0; x < initial.width; ++x) {
                this.minimumSum += this.targetModel.compute(x + initial.x0, y + initial.y0);
            }
        }
        this.minimumSum *= this.minFractionDrop;
    }

    public void setTrackLocation(RectangleLength2D_I32 location) {
        this.location.set(location);
        this.location.width += 1 - this.location.width % 2;
        this.location.height += 1 - this.location.height % 2;
        this.failed = false;
    }

    public boolean process(T image) {
        if (this.failed) {
            return false;
        }
        this.targetModel.setImage(image);
        this.dirty.set(this.location.x0, this.location.y0, this.location.x0 + this.location.width, this.location.y0 + this.location.height);
        this.updatePdfImage(this.location.x0, this.location.y0, this.location.x0 + this.location.width, this.location.y0 + this.location.height);
        int x0 = this.location.x0;
        int y0 = this.location.y0;
        int prevX = x0;
        int prevY = y0;
        for (int i = 0; i < this.maxIterations; ++i) {
            float totalPdf = 0.0f;
            float sumX = 0.0f;
            float sumY = 0.0f;
            for (int y = 0; y < this.location.height; ++y) {
                int indexPdf = this.pdf.startIndex + this.pdf.stride * (y + y0) + x0;
                for (int x = 0; x < this.location.width; ++x) {
                    float p = this.pdf.data[indexPdf++];
                    totalPdf += p;
                    sumX += (float)(x0 + x) * p;
                    sumY += (float)(y0 + y) * p;
                }
            }
            if (totalPdf <= this.minimumSum) {
                this.failed = true;
                return false;
            }
            x0 = (int)(sumX / totalPdf - (float)(this.location.width / 2) + 0.5f);
            y0 = (int)(sumY / totalPdf - (float)(this.location.height / 2) + 0.5f);
            if (x0 < 0) {
                x0 = 0;
            } else if (x0 >= ((ImageBase)image).width - this.location.width) {
                x0 = ((ImageBase)image).width - this.location.width;
            }
            if (y0 < 0) {
                y0 = 0;
            } else if (y0 >= ((ImageBase)image).height - this.location.height) {
                y0 = ((ImageBase)image).height - this.location.height;
            }
            if (x0 == prevX && y0 == prevY) break;
            prevX = x0;
            prevY = y0;
            this.updatePdfImage(x0, y0, x0 + this.location.width, y0 + this.location.height);
        }
        this.location.x0 = x0;
        this.location.y0 = y0;
        ImageMiscOps.fillRectangle((GrayF32)this.pdf, (float)-1.0f, (int)this.dirty.x0, (int)this.dirty.y0, (int)(this.dirty.x1 - this.dirty.x0), (int)(this.dirty.y1 - this.dirty.y0));
        return true;
    }

    protected void updatePdfImage(int x0, int y0, int x1, int y1) {
        for (int y = y0; y < y1; ++y) {
            int indexOut = this.pdf.startIndex + this.pdf.stride * y + x0;
            int x = x0;
            while (x < x1) {
                if (this.pdf.data[indexOut] < 0.0f) {
                    this.pdf.data[indexOut] = this.targetModel.compute(x, y);
                }
                ++x;
                ++indexOut;
            }
        }
        if (this.dirty.x0 > x0) {
            this.dirty.x0 = x0;
        }
        if (this.dirty.y0 > y0) {
            this.dirty.y0 = y0;
        }
        if (this.dirty.x1 < x1) {
            this.dirty.x1 = x1;
        }
        if (this.dirty.y1 < y1) {
            this.dirty.y1 = y1;
        }
    }

    public RectangleLength2D_I32 getLocation() {
        return this.location;
    }

    public boolean isFailed() {
        return this.failed;
    }
}

