/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ConfigThresholdLocalOtsu;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;

public class ConfigChessboard
implements Configuration {
    public int numRows = -1;
    public int numCols = -1;
    public ConfigLength maximumCornerDistance = ConfigLength.relative((double)0.01, (int)8);
    public ConfigThreshold thresholding = new ConfigThresholdLocalOtsu(ConfigLength.relative((double)0.05, (int)10), 10.0);
    public ConfigPolygonDetector square = new ConfigPolygonDetector();
    public double squareWidth;

    public ConfigChessboard(int numRows, int numCols, double squareWidth) {
        this.thresholding.scale = 0.85;
        ((ConfigPolylineSplitMerge)this.square.detector.contourToPoly).cornerScorePenalty = 0.2;
        ((ConfigPolylineSplitMerge)this.square.detector.contourToPoly).minimumSideLength = 2;
        ((ConfigPolylineSplitMerge)this.square.detector.contourToPoly).thresholdSideSplitScore = 0.0;
        ((ConfigPolylineSplitMerge)this.square.detector.contourToPoly).maxSideError = ConfigLength.relative((double)0.5, (int)4);
        this.square.detector.tangentEdgeIntensity = 2.5;
        this.square.detector.minimumContour = ConfigLength.fixed((double)10.0);
        this.square.detector.canTouchBorder = true;
        this.square.refineGray.cornerOffset = 1.0;
        this.square.refineGray.sampleRadius = 3;
        this.square.refineGray.lineSamples = 15;
        this.square.refineGray.convergeTolPixels = 0.2;
        this.square.refineGray.maxIterations = 5;
        this.numRows = numRows;
        this.numCols = numCols;
        this.squareWidth = squareWidth;
    }

    public void checkValidity() {
        if (this.numCols <= 0 || this.numRows <= 0) {
            throw new IllegalArgumentException("Must specify then number of rows and columns in the target");
        }
    }
}

