/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import georegression.metric.UtilAngle;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public abstract class RenderCalibrationTargets {
    List<Point2D_F64> points;

    private void reset() {
        this.points = new ArrayList<Point2D_F64>();
    }

    public void chessboard(int rows, int cols, double squareWidth) {
        this.reset();
        this.specifySize(squareWidth * (double)cols, squareWidth * (double)rows);
        for (int i = 0; i < rows; ++i) {
            int startJ;
            double y = (double)i * squareWidth;
            for (int j = startJ = i % 2 == 0 ? 0 : 1; j < cols; j += 2) {
                double x = (double)j * squareWidth;
                this.drawSquare(x, y, squareWidth);
            }
        }
    }

    public void squareGrid(int rows, int cols, double squareWidth, double spaceWidth) {
        this.reset();
        this.specifySize(squareWidth * (double)cols, squareWidth * (double)rows);
        double targetWidth = (double)cols * squareWidth + (double)(cols - 1) * spaceWidth;
        double targetHeight = (double)rows * squareWidth + (double)(rows - 1) * spaceWidth;
        this.specifySize(targetWidth, targetHeight);
        for (int i = 0; i < rows; ++i) {
            double y = (double)i * (squareWidth + spaceWidth);
            for (int j = 0; j < cols; ++j) {
                double x = (double)j * (squareWidth + spaceWidth);
                this.drawSquare(x, y, squareWidth);
            }
        }
    }

    public void circleHex(int rows, int cols, double circleDiameter, double centerDistance) {
        this.reset();
        double spaceX = centerDistance / 2.0;
        double spaceY = centerDistance * Math.sin(UtilAngle.radian((float)60.0f));
        double radius = circleDiameter / 2.0;
        double imageWidth = (double)(cols - 1) * spaceX + 2.0 * radius;
        double imageHeight = (double)(rows - 1) * spaceY + 2.0 * radius;
        this.specifySize(imageWidth, imageHeight);
        for (int row = 0; row < rows; ++row) {
            double y = radius + (double)(rows - row - 1) * spaceY;
            for (int col = row % 2; col < cols; col += 2) {
                double x = radius + (double)col * spaceX;
                this.drawCircle(x, y, circleDiameter);
            }
        }
    }

    public void circleRegular(int rows, int cols, double circleDiameter, double centerDistance) {
        this.reset();
        double imageWidth = (double)(cols - 1) * centerDistance + circleDiameter;
        double imageHeight = (double)(rows - 1) * centerDistance + circleDiameter;
        this.specifySize(imageWidth, imageHeight);
        double radius = circleDiameter / 2.0;
        for (int row = 0; row < rows; ++row) {
            double y = radius + (double)row * centerDistance;
            for (int col = 0; col < cols; ++col) {
                double x = radius + (double)col * centerDistance;
                this.drawCircle(x, y, circleDiameter);
            }
        }
    }

    public abstract void specifySize(double var1, double var3);

    public abstract void drawSquare(double var1, double var3, double var5);

    public abstract void drawCircle(double var1, double var3, double var5);
}

