/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeGenerator;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;

public class QrCodeGeneratorImage
extends QrCodeGenerator {
    GrayU8 gray = new GrayU8(1, 1);
    int pixelsPerModule;
    int borderModule = 2;
    private int borderPixels;
    private int markerPixels;

    public QrCodeGeneratorImage(int pixelsPerModule) {
        super(1.0);
        this.pixelsPerModule = pixelsPerModule;
    }

    @Override
    public void init() {
        this.borderPixels = this.borderModule * this.pixelsPerModule;
        this.markerPixels = this.pixelsPerModule * this.numModules;
        int width = this.markerPixels + 2 * this.borderPixels;
        this.gray.reshape(width, width);
        ImageMiscOps.fill((GrayI8)this.gray, (int)255);
    }

    @Override
    public void render(QrCode qr) {
        super.render(qr);
        this.adjustSize(qr.ppRight);
        this.adjustSize(qr.ppCorner);
        this.adjustSize(qr.ppDown);
        this.adjustSize(qr.bounds);
        for (int i = 0; i < qr.alignment.size(); ++i) {
            QrCode.Alignment a = (QrCode.Alignment)qr.alignment.get(i);
            a.pixel.x = (double)this.borderPixels + a.pixel.x * (double)this.markerPixels;
            a.pixel.y = (double)this.borderPixels + a.pixel.y * (double)this.markerPixels;
            a.threshold = 125.0;
        }
        qr.threshRight = 125.0;
        qr.threshCorner = 125.0;
        qr.threshDown = 125.0;
    }

    private void adjustSize(Polygon2D_F64 poly) {
        for (int i = 0; i < poly.size(); ++i) {
            Point2D_F64 p = poly.get(i);
            p.x = (double)this.borderPixels + p.x * (double)this.markerPixels;
            p.y = (double)this.borderPixels + p.y * (double)this.markerPixels;
        }
    }

    @Override
    public void square(double x0, double y0, double width) {
        int pixelX = this.borderPixels + (int)(x0 * (double)this.markerPixels + 0.5);
        int pixelY = this.borderPixels + (int)(y0 * (double)this.markerPixels + 0.5);
        int pixelsWidth = (int)(width * (double)this.markerPixels + 0.5);
        ImageMiscOps.fillRectangle((GrayI8)this.gray, (int)0, (int)pixelX, (int)pixelY, (int)pixelsWidth, (int)pixelsWidth);
    }

    @Override
    public void square(double x0, double y0, double width0, double thickness) {
        int X0 = this.borderPixels + (int)(x0 * (double)this.markerPixels + 0.5);
        int Y0 = this.borderPixels + (int)(y0 * (double)this.markerPixels + 0.5);
        int WIDTH = (int)(width0 * (double)this.markerPixels + 0.5);
        int THICKNESS = (int)(thickness * (double)this.markerPixels + 0.5);
        ImageMiscOps.fillRectangle((GrayI8)this.gray, (int)0, (int)X0, (int)Y0, (int)WIDTH, (int)THICKNESS);
        ImageMiscOps.fillRectangle((GrayI8)this.gray, (int)0, (int)X0, (int)(Y0 + WIDTH - THICKNESS), (int)WIDTH, (int)THICKNESS);
        ImageMiscOps.fillRectangle((GrayI8)this.gray, (int)0, (int)X0, (int)(Y0 + THICKNESS), (int)THICKNESS, (int)(WIDTH - THICKNESS * 2));
        ImageMiscOps.fillRectangle((GrayI8)this.gray, (int)0, (int)(X0 + WIDTH - THICKNESS), (int)(Y0 + THICKNESS), (int)THICKNESS, (int)(WIDTH - THICKNESS * 2));
    }

    public int getBorderModule() {
        return this.borderModule;
    }

    public void setBorderModule(int borderModule) {
        this.borderModule = borderModule;
    }

    public GrayU8 getGray() {
        return this.gray;
    }
}

