/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;

public class ConfigFiducialBinary
implements Configuration {
    public double targetWidth;
    public double ambiguousThreshold = 0.75;
    public int gridWidth = 4;
    public double borderWidthFraction = 0.25;
    public double minimumBlackBorderFraction = 0.65;
    public ConfigPolygonDetector squareDetector = new ConfigPolygonDetector();

    public ConfigFiducialBinary() {
        ((ConfigPolylineSplitMerge)this.squareDetector.detector.contourToPoly).cornerScorePenalty = 0.2;
        ((ConfigPolylineSplitMerge)this.squareDetector.detector.contourToPoly).thresholdSideSplitScore = 0.0;
        this.squareDetector.detector.minimumContour = ConfigLength.fixed((double)20.0);
        this.squareDetector.refineGray.cornerOffset = 0.0;
    }

    public ConfigFiducialBinary(double targetWidth) {
        ((ConfigPolylineSplitMerge)this.squareDetector.detector.contourToPoly).cornerScorePenalty = 0.2;
        ((ConfigPolylineSplitMerge)this.squareDetector.detector.contourToPoly).thresholdSideSplitScore = 0.0;
        this.squareDetector.detector.minimumContour = ConfigLength.fixed((double)20.0);
        this.squareDetector.refineGray.cornerOffset = 0.0;
        this.targetWidth = targetWidth;
    }

    public void checkValidity() {
        if (this.ambiguousThreshold < 0.0 || this.ambiguousThreshold > 1.0) {
            throw new IllegalArgumentException("ambiguousThreshold must be from 0 to 1, inclusive");
        }
        if (this.gridWidth < 3 || this.gridWidth > 8) {
            throw new IllegalArgumentException("Grid width must be at least 3 elements and at most 8");
        }
        if (this.borderWidthFraction <= 0.0 || this.borderWidthFraction >= 0.5) {
            throw new IllegalArgumentException("Border width fraction must be 0 < fraction < 0.5");
        }
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridWidth(int gridWidth) {
        this.gridWidth = gridWidth;
    }

    public double getBorderWidthFraction() {
        return this.borderWidthFraction;
    }

    public void setBorderWidthFraction(double borderWidthFraction) {
        this.borderWidthFraction = borderWidthFraction;
    }

    public double getTargetWidth() {
        return this.targetWidth;
    }

    public void setTargetWidth(double targetWidth) {
        this.targetWidth = targetWidth;
    }

    public ConfigPolygonDetector getSquareDetector() {
        return this.squareDetector;
    }

    public void setSquareDetector(ConfigPolygonDetector squareDetector) {
        this.squareDetector = squareDetector;
    }

    public String toString() {
        return "ConfigFiducialBinary{targetWidth=" + this.targetWidth + ", ambiguousThreshold=" + this.ambiguousThreshold + ", gridWidth=" + this.gridWidth + ", borderWidthFraction=" + this.borderWidthFraction + ", squareDetector=" + this.squareDetector + '}';
    }
}

