/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetectorPnP;
import boofcv.abst.fiducial.calib.CalibrationDetectorChessboardBinary;
import boofcv.abst.fiducial.calib.CalibrationDetectorChessboardX;
import boofcv.abst.fiducial.calib.CalibrationDetectorCircleHexagonalGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorCircleRegularGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorSquareFiducialGrid;
import boofcv.abst.fiducial.calib.CalibrationDetectorSquareGrid;
import boofcv.abst.fiducial.calib.ConfigChessboardBinary;
import boofcv.abst.fiducial.calib.ConfigChessboardX;
import boofcv.abst.fiducial.calib.ConfigCircleHexagonalGrid;
import boofcv.abst.fiducial.calib.ConfigCircleRegularGrid;
import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGridBinary;
import boofcv.abst.geo.calibration.DetectorFiducialCalibration;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.core.image.GConvertImage;
import boofcv.factory.fiducial.FactoryFiducialCalibration;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.fitting.polygon.FitPolygon2D_F64;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.UtilEjml;
import org.jetbrains.annotations.Nullable;

public class CalibrationFiducialDetector<T extends ImageGray<T>>
extends FiducialDetectorPnP<T> {
    private DetectorFiducialCalibration detector;
    private boolean targetDetected;
    private GrayF32 converted;
    private ImageType<T> type;
    private List<Point2D3D> points2D3D;
    double sideWidth;
    double sideHeight;
    private double width;
    int[] boundaryIndexes;
    Point2Transform2_F64 pointUndistToDist;

    public CalibrationFiducialDetector(@Nullable ConfigChessboardBinary configDet, ConfigGridDimen configGrid, Class<T> imageType) {
        CalibrationDetectorChessboardBinary detector = FactoryFiducialCalibration.chessboardB(configDet, configGrid);
        this.sideWidth = (double)configGrid.numCols * configGrid.shapeSize;
        this.sideHeight = (double)configGrid.numRows * configGrid.shapeSize;
        this.width = (this.sideWidth + this.sideHeight) / 2.0;
        this.init(detector, this.width, imageType);
    }

    public CalibrationFiducialDetector(@Nullable ConfigChessboardX configDet, ConfigGridDimen configGrid, Class<T> imageType) {
        CalibrationDetectorChessboardX detector = FactoryFiducialCalibration.chessboardX(configDet, configGrid);
        this.sideWidth = (double)configGrid.numCols * configGrid.shapeSize;
        this.sideHeight = (double)configGrid.numRows * configGrid.shapeSize;
        this.width = (this.sideWidth + this.sideHeight) / 2.0;
        this.init(detector, this.width, imageType);
    }

    public CalibrationFiducialDetector(@Nullable ConfigSquareGrid configDet, ConfigGridDimen configGrid, Class<T> imageType) {
        CalibrationDetectorSquareGrid detector = FactoryFiducialCalibration.squareGrid(configDet, configGrid);
        int squareCols = configGrid.numCols;
        int squareRows = configGrid.numRows;
        this.sideWidth = (double)squareCols * configGrid.shapeSize + (double)(squareCols - 1) * configGrid.shapeDistance;
        this.sideHeight = (double)squareRows * configGrid.shapeSize + (double)(squareRows - 1) * configGrid.shapeDistance;
        double width = (this.sideWidth + this.sideHeight) / 2.0;
        this.init(detector, width, imageType);
    }

    public CalibrationFiducialDetector(ConfigSquareGridBinary config, Class<T> imageType) {
        CalibrationDetectorSquareFiducialGrid detector = FactoryFiducialCalibration.binaryGrid(config);
        int squareCols = config.numCols;
        int squareRows = config.numRows;
        this.sideWidth = (double)squareCols * config.squareWidth + (double)(squareCols - 1) * config.spaceWidth;
        this.sideHeight = (double)squareRows * config.squareWidth + (double)(squareRows - 1) * config.spaceWidth;
        double width = (this.sideWidth + this.sideHeight) / 2.0;
        this.init(detector, width, imageType);
    }

    public CalibrationFiducialDetector(@Nullable ConfigCircleHexagonalGrid configDet, ConfigGridDimen configGrid, Class<T> imageType) {
        CalibrationDetectorCircleHexagonalGrid detector = FactoryFiducialCalibration.circleHexagonalGrid(configDet, configGrid);
        int squareCols = configGrid.numCols;
        int squareRows = configGrid.numRows;
        this.sideWidth = (double)squareCols * configGrid.shapeDistance / 2.0;
        this.sideHeight = (double)squareRows * configGrid.shapeDistance / 2.0;
        double width = (this.sideWidth + this.sideHeight) / 2.0;
        this.init(detector, width, imageType);
    }

    public CalibrationFiducialDetector(@Nullable ConfigCircleRegularGrid configDet, ConfigGridDimen configGrid, Class<T> imageType) {
        CalibrationDetectorCircleRegularGrid detector = FactoryFiducialCalibration.circleRegularGrid(configDet, configGrid);
        this.sideWidth = (double)(configGrid.numCols - 1) * configGrid.shapeDistance;
        this.sideHeight = (double)(configGrid.numRows - 1) * configGrid.shapeDistance;
        double width = (this.sideWidth + this.sideHeight) / 2.0;
        this.init(detector, width, imageType);
    }

    protected void init(DetectorFiducialCalibration detector, double width, Class<T> imageType) {
        this.detector = detector;
        this.type = ImageType.single(imageType);
        this.converted = new GrayF32(1, 1);
        this.width = width;
        List layout = detector.getLayout();
        this.points2D3D = new ArrayList<Point2D3D>();
        for (int i = 0; i < layout.size(); ++i) {
            Point2D_F64 p2 = (Point2D_F64)layout.get(i);
            Point2D3D p = new Point2D3D();
            p.location.setTo(p2.x, p2.y, 0.0);
            this.points2D3D.add(p);
        }
        this.selectBoundaryCorners();
    }

    @Override
    public double getSideWidth(int which) {
        return this.sideWidth;
    }

    @Override
    public double getSideHeight(int which) {
        return this.sideHeight;
    }

    protected void selectBoundaryCorners() {
        List layout = this.detector.getLayout();
        Polygon2D_F64 hull = new Polygon2D_F64();
        FitPolygon2D_F64.convexHull((List)layout, (Polygon2D_F64)hull);
        UtilPolygons2D_F64.removeAlmostParallel((Polygon2D_F64)hull, (double)0.02);
        this.boundaryIndexes = new int[hull.size()];
        for (int i = 0; i < hull.size(); ++i) {
            Point2D_F64 h = hull.get(i);
            boolean matched = false;
            for (int j = 0; j < layout.size(); ++j) {
                if (!h.isIdentical((GeoTuple2D_F64)((Point2D_F64)layout.get(j)), 1.0E-6)) continue;
                matched = true;
                this.boundaryIndexes[i] = j;
                break;
            }
            if (matched) continue;
            throw new RuntimeException("Bug!");
        }
    }

    @Override
    public void detect(T input) {
        if (input instanceof GrayF32) {
            this.converted = (GrayF32)input;
        } else {
            this.converted.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            GConvertImage.convert(input, (ImageBase)this.converted);
        }
        if (!this.detector.process(this.converted)) {
            this.targetDetected = false;
        } else {
            this.targetDetected = true;
            if (this.pointUndistToDist != null) {
                CalibrationObservation detected = this.detector.getDetectedPoints();
                for (int i = 0; i < detected.size(); ++i) {
                    Point2D_F64 p = (Point2D_F64)detected.get((int)i).p;
                    this.pointUndistToDist.compute(p.x, p.y, p);
                }
            }
        }
    }

    @Override
    public void setLensDistortion(LensDistortionNarrowFOV distortion, int width, int height) {
        super.setLensDistortion(distortion, width, height);
        if (distortion == null) {
            this.pointUndistToDist = null;
        } else {
            this.pointUndistToDist = distortion.distort_F64(true, true);
            Point2D_F64 test = new Point2D_F64();
            this.pointUndistToDist.compute(0.0, 0.0, test);
            if (test.norm() <= (double)UtilEjml.TEST_F32) {
                this.detector.setLensDistortion(null, width, height);
                this.pointUndistToDist = null;
            } else {
                this.detector.setLensDistortion(distortion, width, height);
            }
        }
    }

    @Override
    public void getCenter(int which, Point2D_F64 location) {
        CalibrationObservation view = this.detector.getDetectedPoints();
        location.setTo(0.0, 0.0);
        for (int i = 0; i < view.size(); ++i) {
            Point2D_F64 p = (Point2D_F64)view.get((int)i).p;
            location.x += p.x;
            location.y += p.y;
        }
        location.x /= (double)view.size();
        location.y /= (double)view.size();
    }

    @Override
    public Polygon2D_F64 getBounds(int which, @Nullable Polygon2D_F64 storage) {
        if (storage == null) {
            storage = new Polygon2D_F64();
        } else {
            storage.vertexes.reset();
        }
        List<PointIndex2D_F64> control = this.getDetectedControl(which);
        for (int i = 0; i < this.boundaryIndexes.length; ++i) {
            PointIndex2D_F64 p = control.get(this.boundaryIndexes[i]);
            if (p.index == this.boundaryIndexes[i]) {
                ((Point2D_F64)storage.vertexes.grow()).setTo((Point2D_F64)p.p);
                continue;
            }
            System.out.println("control points are out of order or not detected");
        }
        return storage;
    }

    @Override
    public int totalFound() {
        return this.targetDetected ? 1 : 0;
    }

    @Override
    public long getId(int which) {
        return 0L;
    }

    @Override
    public String getMessage(int which) {
        return null;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.type;
    }

    public List<Point2D_F64> getCalibrationPoints() {
        return this.detector.getLayout();
    }

    public DetectorFiducialCalibration getCalibDetector() {
        return this.detector;
    }

    public List<Point2D3D> getPoints2D3D() {
        return this.points2D3D;
    }

    @Override
    public double getWidth(int which) {
        return this.width;
    }

    @Override
    public boolean hasID() {
        return false;
    }

    @Override
    public boolean hasMessage() {
        return false;
    }

    @Override
    public List<PointIndex2D_F64> getDetectedControl(int which) {
        CalibrationObservation view = this.getCalibDetector().getDetectedPoints();
        return view.points;
    }

    @Override
    protected List<Point2D3D> getControl3D(int which) {
        return this.getPoints2D3D();
    }
}

