/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.alg.fiducial.calib.chess.ChessboardCornerGraph;
import georegression.metric.UtilAngle;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import org.ddogleg.sorting.QuickSort_F64;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;

public class ChessboardCornerClusterToGrid {
    QuickSort_F64 sorter = new QuickSort_F64();
    double[] directions = new double[4];
    int[] order = new int[4];
    ChessboardCornerGraph.Node[] tmpEdges = new ChessboardCornerGraph.Node[4];
    DogArray_B marked = new DogArray_B();
    Queue<ChessboardCornerGraph.Node> open = new ArrayDeque<ChessboardCornerGraph.Node>();
    List<ChessboardCornerGraph.Node> edgeList = new ArrayList<ChessboardCornerGraph.Node>();
    List<ChessboardCornerGraph.Node> cornerList = new ArrayList<ChessboardCornerGraph.Node>();
    boolean requireCornerSquares = false;
    PrintStream verbose;
    CheckShape checkShape;
    DogArray<GridElement> sparseGrid = new DogArray(GridElement::new);
    int sparseCols;
    int sparseRows;
    GridElement[] denseGrid = new GridElement[0];

    public boolean convert(ChessboardCornerGraph cluster, GridInfo info) {
        this.sparseGrid.reset();
        info.reset();
        if (!this.orderEdges(cluster)) {
            return false;
        }
        if (!this.createSparseGrid(cluster.corners)) {
            return false;
        }
        this.sparseToDense();
        if (!this.findLargestRectangle(info)) {
            return false;
        }
        int corner = this.selectCorner(info);
        if (corner == -1) {
            if (this.verbose != null) {
                this.verbose.println("Failed to find valid corner.");
            }
            return false;
        }
        for (int i = 0; i < corner; ++i) {
            this.rotateCCW(info);
        }
        return true;
    }

    boolean createSparseGrid(DogArray<ChessboardCornerGraph.Node> corners) {
        Object e;
        ChessboardCornerGraph.Node n;
        this.marked.resize(corners.size);
        this.marked.fill(false);
        this.sparseGrid.resize(corners.size);
        for (int i = 0; i < this.sparseGrid.size; ++i) {
            ((GridElement)this.sparseGrid.get(i)).reset();
        }
        this.open.clear();
        GridElement g = (GridElement)this.sparseGrid.get(0);
        g.node = n = (ChessboardCornerGraph.Node)((Object)corners.get(0));
        g.col = 0;
        g.row = 0;
        this.marked.set(0, true);
        this.open.add(n);
        int minCol = Integer.MAX_VALUE;
        int minRow = Integer.MAX_VALUE;
        this.sparseCols = -1;
        this.sparseRows = -1;
        while (!this.open.isEmpty()) {
            n = this.open.remove();
            g = (GridElement)this.sparseGrid.get(n.index);
            for (int idx = 0; idx < 4; ++idx) {
                e = n.edges[idx];
                if (e == null) continue;
                GridElement ge = (GridElement)this.sparseGrid.get(((ChessboardCornerGraph.Node)((Object)e)).index);
                int row = g.row;
                int col = g.col;
                switch (idx) {
                    case 0: {
                        ++col;
                        break;
                    }
                    case 1: {
                        ++row;
                        break;
                    }
                    case 2: {
                        --col;
                        break;
                    }
                    case 3: {
                        --row;
                    }
                }
                if (!ge.isAssigned()) {
                    ge.node = e;
                    ge.row = row;
                    ge.col = col;
                    if (row < minRow) {
                        minRow = row;
                    }
                    if (col < minCol) {
                        minCol = col;
                    }
                    if (row > this.sparseRows) {
                        this.sparseRows = row;
                    }
                    if (col > this.sparseCols) {
                        this.sparseCols = col;
                    }
                } else if (ge.row != row || ge.col != col) {
                    if (this.verbose != null) {
                        this.verbose.println("Contradiction in graph found.");
                    }
                    return false;
                }
                if (this.marked.get(((ChessboardCornerGraph.Node)((Object)e)).index)) continue;
                this.open.add((ChessboardCornerGraph.Node)((Object)e));
                this.marked.set(((ChessboardCornerGraph.Node)((Object)e)).index, true);
            }
        }
        if (minCol < 0 || minRow < 0) {
            if (minRow < 0) {
                this.sparseRows += -minRow;
            }
            if (minCol < 0) {
                this.sparseCols += -minCol;
            }
            for (int i = 0; i < this.sparseGrid.size; ++i) {
                e = (GridElement)this.sparseGrid.get(i);
                if (!e.isAssigned()) {
                    throw new RuntimeException("BUG! grid element not assigned");
                }
                e.col -= minCol;
                e.row -= minRow;
            }
        }
        ++this.sparseRows;
        ++this.sparseCols;
        return true;
    }

    void sparseToDense() {
        int N = this.sparseCols * this.sparseRows;
        if (this.denseGrid.length < N) {
            this.denseGrid = new GridElement[N];
        }
        Arrays.fill(this.denseGrid, null);
        for (int i = 0; i < this.sparseGrid.size; ++i) {
            GridElement g;
            this.denseGrid[g.row * this.sparseCols + g.col] = g = (GridElement)this.sparseGrid.get(i);
        }
    }

    boolean findLargestRectangle(GridInfo info) {
        int i;
        int row0 = 0;
        int row1 = this.sparseRows;
        int col0 = 0;
        int col1 = this.sparseCols;
        int[] rowZeros = new int[this.sparseRows];
        int[] colZeros = new int[this.sparseCols];
        for (i = 0; i < this.sparseRows; ++i) {
            rowZeros[i] = this.countZeros(i, i + 1, 0, this.sparseCols, 0, 1);
        }
        for (i = 0; i < this.sparseCols; ++i) {
            colZeros[i] = this.countZeros(0, this.sparseRows, i, i + 1, 1, 0);
        }
        boolean success = false;
        while (row0 < row1 && col0 < col1) {
            int i2;
            int rz = Math.max(rowZeros[row0], rowZeros[row1 - 1]);
            int cz = Math.max(colZeros[col0], colZeros[col1 - 1]);
            if (rz == 0 && cz == 0) {
                success = true;
                break;
            }
            if (rz > cz) {
                if (rowZeros[row0] > rowZeros[row1 - 1]) {
                    for (i2 = col0; i2 < col1; ++i2) {
                        if (this.grid(row0, i2) != null) continue;
                        int n = i2;
                        colZeros[n] = colZeros[n] - 1;
                    }
                    ++row0;
                    continue;
                }
                for (i2 = col0; i2 < col1; ++i2) {
                    if (this.grid(row1 - 1, i2) != null) continue;
                    int n = i2;
                    colZeros[n] = colZeros[n] - 1;
                }
                --row1;
                continue;
            }
            if (colZeros[col0] > colZeros[col1 - 1]) {
                for (i2 = row0; i2 < row1; ++i2) {
                    if (this.grid(i2, col0) != null) continue;
                    int n = i2;
                    rowZeros[n] = rowZeros[n] - 1;
                }
                ++col0;
                continue;
            }
            for (i2 = row0; i2 < row1; ++i2) {
                if (this.grid(i2, col1 - 1) != null) continue;
                int n = i2;
                rowZeros[n] = rowZeros[n] - 1;
            }
            --col1;
        }
        if (success) {
            info.nodes.clear();
            info.rows = row1 - row0;
            info.cols = col1 - col0;
            for (int row = row0; row < row1; ++row) {
                for (int col = col0; col < col1; ++col) {
                    GridElement g = this.grid(row, col);
                    if (g == null) {
                        if (this.verbose != null) {
                            this.verbose.println("Failed due to hole inside of grid");
                        }
                        return false;
                    }
                    info.nodes.add(g.node);
                }
            }
        }
        return success;
    }

    int countZeros(int row0, int row1, int col0, int col1, int stepRow, int stepCol) {
        int total = 0;
        while (row0 != row1 && col0 != col1) {
            if (this.grid(row0, col0) == null) {
                ++total;
            }
            row0 += stepRow;
            col0 += stepCol;
        }
        return total;
    }

    final GridElement grid(int row, int col) {
        return this.denseGrid[row * this.sparseCols + col];
    }

    int selectCorner(GridInfo info) {
        info.lookupGridCorners(this.cornerList);
        int bestCorner = -1;
        double bestScore = Double.MAX_VALUE;
        boolean bestIsCornerSquare = false;
        for (int i = 0; i < this.cornerList.size(); ++i) {
            ChessboardCornerGraph.Node n = this.cornerList.get(i);
            boolean corner = this.isCornerValidOrigin(n);
            if (!corner && (this.requireCornerSquares || bestIsCornerSquare) || this.checkShape != null && (i % 2 != 0 ? !this.checkShape.isValidShape(info.cols, info.rows) : !this.checkShape.isValidShape(info.rows, info.cols))) continue;
            double distance = n.normSq();
            if (!(distance < bestScore) && (bestIsCornerSquare || !corner)) continue;
            bestIsCornerSquare |= corner;
            bestScore = distance;
            bestCorner = i;
        }
        info.hasCornerSquare = bestIsCornerSquare;
        return bestCorner;
    }

    boolean isCornerValidOrigin(ChessboardCornerGraph.Node candidate) {
        double dirB;
        candidate.putEdgesIntoList(this.edgeList);
        if (this.edgeList.size() != 2) {
            throw new RuntimeException("BUG! Should be a corner and have two edges");
        }
        ChessboardCornerGraph.Node a = this.edgeList.get(0);
        ChessboardCornerGraph.Node b = this.edgeList.get(1);
        double dirA = Math.atan2(a.y - candidate.y, a.x - candidate.x);
        double dirAB = UtilAngle.boundHalf((double)(dirA + UtilAngle.distanceCCW((double)dirA, (double)(dirB = Math.atan2(b.y - candidate.y, b.x - candidate.x))) / 2.0));
        double acute = UtilAngle.distHalf((double)dirAB, (double)candidate.orientation);
        return acute < 0.7853981633974483;
    }

    boolean orderNodes(DogArray<ChessboardCornerGraph.Node> corners, GridInfo info) {
        ChessboardCornerGraph.Node seed = null;
        for (int i = 0; i < corners.size; ++i) {
            ChessboardCornerGraph.Node n = (ChessboardCornerGraph.Node)((Object)corners.get(i));
            if (n.countEdges() != 2) continue;
            seed = n;
            break;
        }
        if (seed == null) {
            if (this.verbose != null) {
                this.verbose.println("Can't find a corner with just two edges. Aborting");
            }
            return false;
        }
        int rowEdge = 0;
        while (seed.edges[rowEdge] == null) {
            rowEdge = (rowEdge + 1) % 4;
        }
        int colEdge = (rowEdge + 1) % 4;
        while (seed.edges[colEdge] == null) {
            colEdge = (colEdge + 2) % 4;
        }
        if (!ChessboardCornerClusterToGrid.isRightHanded(seed, rowEdge, colEdge)) {
            int tmp = rowEdge;
            rowEdge = colEdge;
            colEdge = tmp;
        }
        while (seed != null) {
            int before = info.nodes.size();
            ChessboardCornerGraph.Node n = seed;
            do {
                info.nodes.add(n);
            } while ((n = n.edges[colEdge]) != null);
            seed = seed.edges[rowEdge];
            if (info.cols == -1) {
                info.cols = info.nodes.size();
                continue;
            }
            int columnsInRow = info.nodes.size() - before;
            if (columnsInRow == info.cols) continue;
            if (this.verbose != null) {
                this.verbose.println("Number of columns in each row is variable");
            }
            return false;
        }
        info.rows = info.nodes.size() / info.cols;
        return true;
    }

    static boolean isRightHanded(ChessboardCornerGraph.Node seed, int idxRow, int idxCol) {
        double dirCol;
        ChessboardCornerGraph.Node r = seed.edges[idxRow];
        ChessboardCornerGraph.Node c = seed.edges[idxCol];
        double dirRow = Math.atan2(r.y - seed.y, r.x - seed.x);
        return UtilAngle.distanceCW((double)dirRow, (double)(dirCol = Math.atan2(c.y - seed.y, c.x - seed.x))) < Math.PI;
    }

    boolean orderEdges(ChessboardCornerGraph cluster) {
        this.sortEdgesCCW(cluster.corners);
        return this.alignEdges(cluster.corners);
    }

    boolean alignEdges(DogArray<ChessboardCornerGraph.Node> corners) {
        this.open.clear();
        this.open.add((ChessboardCornerGraph.Node)((Object)corners.get(0)));
        this.marked.resize(corners.size);
        this.marked.fill(false);
        this.marked.set(((ChessboardCornerGraph.Node)((Object)corners.get((int)0))).index, true);
        while (!this.open.isEmpty()) {
            ChessboardCornerGraph.Node na = this.open.remove();
            for (int i = 0; i < 4; ++i) {
                if (na.edges[i] == null) continue;
                int j = (i + 2) % 4;
                ChessboardCornerGraph.Node nb = na.edges[i];
                if (this.marked.get(nb.index)) {
                    if (nb.edges[j] == na) continue;
                    if (this.verbose != null) {
                        this.verbose.println("BUG! node " + nb.index + " has been processed and edge " + j + " doesn't point to node " + na.index);
                    }
                    return false;
                }
                boolean failed = true;
                for (int attempt = 0; attempt < 4; ++attempt) {
                    if (nb.edges[j] == na) {
                        failed = false;
                        break;
                    }
                    nb.rotateEdgesDown();
                }
                if (failed) {
                    if (this.verbose != null) {
                        this.verbose.println("BUG! Can't align edges");
                    }
                    return false;
                }
                this.marked.set(nb.index, true);
                this.open.add(nb);
            }
        }
        return true;
    }

    void sortEdgesCCW(DogArray<ChessboardCornerGraph.Node> corners) {
        for (int nodeIdx = 0; nodeIdx < corners.size; ++nodeIdx) {
            int i;
            ChessboardCornerGraph.Node na = (ChessboardCornerGraph.Node)((Object)corners.get(nodeIdx));
            double ref = Double.NaN;
            int count = 0;
            for (i = 0; i < 4; ++i) {
                this.order[i] = i;
                this.tmpEdges[i] = na.edges[i];
                if (na.edges[i] == null) {
                    this.directions[i] = Double.MAX_VALUE;
                    continue;
                }
                ChessboardCornerGraph.Node nb = na.edges[i];
                double angleB = Math.atan2(nb.y - na.y, nb.x - na.x);
                if (Double.isNaN(ref)) {
                    ref = angleB;
                    this.directions[i] = 0.0;
                } else {
                    this.directions[i] = UtilAngle.distanceCCW((double)ref, (double)angleB);
                }
                ++count;
            }
            this.sorter.sort(this.directions, 0, 4, this.order);
            for (i = 0; i < 4; ++i) {
                na.edges[i] = this.tmpEdges[this.order[i]];
            }
            if (count == 2) {
                if (this.directions[this.order[1]] > Math.PI) {
                    na.edges[0] = this.tmpEdges[this.order[1]];
                    na.edges[1] = this.tmpEdges[this.order[0]];
                    continue;
                }
                na.edges[0] = this.tmpEdges[this.order[0]];
                na.edges[1] = this.tmpEdges[this.order[1]];
                continue;
            }
            if (count != 3) continue;
            int selected = -1;
            double largestAngle = 0.0;
            int i2 = 0;
            int j = 2;
            while (i2 < 3) {
                double ccw = UtilAngle.distanceCCW((double)this.directions[this.order[j]], (double)this.directions[this.order[i2]]);
                if (ccw > largestAngle) {
                    largestAngle = ccw;
                    selected = j;
                }
                j = i2++;
            }
            for (i2 = 2; i2 > selected; --i2) {
                na.edges[i2 + 1] = na.edges[i2];
            }
            na.edges[selected + 1] = null;
        }
    }

    public void rotateCCW(GridInfo grid) {
        this.cornerList.clear();
        for (int col = 0; col < grid.cols; ++col) {
            for (int row = 0; row < grid.rows; ++row) {
                this.cornerList.add(grid.get(row, grid.cols - col - 1));
            }
        }
        int tmp = grid.rows;
        grid.rows = grid.cols;
        grid.cols = tmp;
        grid.nodes.clear();
        grid.nodes.addAll(this.cornerList);
    }

    public void setVerbose(PrintStream verbose) {
        this.verbose = verbose;
    }

    public void setCheckShape(CheckShape checkShape) {
        this.checkShape = checkShape;
    }

    public boolean isRequireCornerSquares() {
        return this.requireCornerSquares;
    }

    public void setRequireCornerSquares(boolean requireCornerSquares) {
        this.requireCornerSquares = requireCornerSquares;
    }

    public static class GridElement {
        public ChessboardCornerGraph.Node node;
        public int row;
        public int col;
        public int rowLength;
        public int colLength;

        public boolean isAssigned() {
            return this.row != Integer.MAX_VALUE;
        }

        public void reset() {
            this.node = null;
            this.colLength = -1;
            this.rowLength = -1;
            this.row = Integer.MAX_VALUE;
            this.col = Integer.MAX_VALUE;
        }
    }

    public static class GridInfo {
        public List<ChessboardCornerGraph.Node> nodes = new ArrayList<ChessboardCornerGraph.Node>();
        public int rows;
        public int cols;
        public boolean hasCornerSquare;

        public void reset() {
            this.cols = -1;
            this.rows = -1;
            this.hasCornerSquare = true;
            this.nodes.clear();
        }

        public ChessboardCornerGraph.Node get(int row, int col) {
            return this.nodes.get(row * this.cols + col);
        }

        public void lookupGridCorners(List<ChessboardCornerGraph.Node> corners) {
            corners.clear();
            corners.add(this.nodes.get(0));
            corners.add(this.nodes.get(this.cols - 1));
            corners.add(this.nodes.get(this.rows * this.cols - 1));
            corners.add(this.nodes.get((this.rows - 1) * this.cols));
            for (int i = 3; i >= 0; --i) {
                if (corners.get(i).countEdges() == 2) continue;
                corners.remove(i);
            }
        }
    }

    public static interface CheckShape {
        public boolean isValidShape(int var1, int var2);
    }
}

