/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.alg.sfm.robust.DistanceScaleTranslate2DSq;
import boofcv.alg.sfm.robust.GenerateScaleTranslate2D;
import boofcv.alg.sfm.robust.ModelManagerScaleTranslate2D;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.sfm.ScaleTranslate2D;
import georegression.struct.shapes.Rectangle2D_F64;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares;
import org.ddogleg.struct.DogArray;

public class TldAdjustRegion {
    private LeastMedianOfSquares<ScaleTranslate2D, AssociatedPair> estimateMotion;
    int imageWidth;
    int imageHeight;

    public TldAdjustRegion(int numCycles) {
        ModelManagerScaleTranslate2D manager = new ModelManagerScaleTranslate2D();
        GenerateScaleTranslate2D generator = new GenerateScaleTranslate2D();
        DistanceScaleTranslate2DSq distance = new DistanceScaleTranslate2DSq();
        this.estimateMotion = new LeastMedianOfSquares(123123L, numCycles, Double.MAX_VALUE, 0.0, (ModelManager)manager, (ModelGenerator)generator, (DistanceFromModel)distance);
    }

    public void init(int imageWidth, int imageHeight) {
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
    }

    public boolean process(DogArray<AssociatedPair> pairs, Rectangle2D_F64 targetRectangle) {
        if (!this.estimateMotion.process(pairs.toList())) {
            return false;
        }
        ScaleTranslate2D motion = (ScaleTranslate2D)this.estimateMotion.getModelParameters();
        this.adjustRectangle(targetRectangle, motion);
        if (targetRectangle.p0.x < 0.0 || targetRectangle.p0.y < 0.0) {
            return false;
        }
        return !(targetRectangle.p1.x >= (double)this.imageWidth) && !(targetRectangle.p1.y >= (double)this.imageHeight);
    }

    protected void adjustRectangle(Rectangle2D_F64 rect, ScaleTranslate2D motion) {
        rect.p0.x = rect.p0.x * motion.scale + motion.transX;
        rect.p0.y = rect.p0.y * motion.scale + motion.transY;
        rect.p1.x = rect.p1.x * motion.scale + motion.transX;
        rect.p1.y = rect.p1.y * motion.scale + motion.transY;
    }
}

