/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.abst.filter.binary.BinaryContourFinder;
import boofcv.alg.fiducial.calib.chess.ChessboardPolygonHelper;
import boofcv.alg.fiducial.calib.squares.SquareCrossClustersIntoGrids;
import boofcv.alg.fiducial.calib.squares.SquareEdge;
import boofcv.alg.fiducial.calib.squares.SquareGrid;
import boofcv.alg.fiducial.calib.squares.SquareGridTools;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.fiducial.calib.squares.SquaresIntoCrossClusters;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.misc.CircularIndex;
import boofcv.struct.ConfigLength;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Polygon2D_I32;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;

public class DetectChessboardSquarePoints<T extends ImageGray<T>> {
    DetectPolygonBinaryGrayRefine<T> detectorSquare;
    SquaresIntoCrossClusters s2c;
    SquareCrossClustersIntoGrids c2g;
    private int numRows;
    private int numCols;
    private Polygon2D_I32 boundPolygon = new Polygon2D_I32();
    SquareGridTools tools = new SquareGridTools();
    DogArray<PointIndex2D_F64> calibrationPoints = new DogArray(PointIndex2D_F64::new);
    ConfigLength maxCornerDistance;
    List<List<SquareNode>> clusters;
    Polygon2D_F64 work = new Polygon2D_F64();

    public DetectChessboardSquarePoints(int numRows, int numCols, ConfigLength maxCornerDistance, DetectPolygonBinaryGrayRefine<T> detectorSquare) {
        this.maxCornerDistance = maxCornerDistance;
        this.numRows = numRows;
        this.numCols = numCols;
        this.detectorSquare = detectorSquare;
        if (detectorSquare != null) {
            detectorSquare.setHelper(new ChessboardPolygonHelper());
            detectorSquare.getDetector().setOutputClockwiseUpY(true);
            detectorSquare.getDetector().setConvex(true);
            this.detectorSquare.setFunctionAdjust((info, clockwise) -> this.adjustBeforeOptimize(info.polygon, info.borderCorners, clockwise));
        }
        this.s2c = new SquaresIntoCrossClusters(-1.0, -1);
        this.c2g = new SquareCrossClustersIntoGrids();
    }

    public boolean process(T input, GrayU8 binary) {
        double maxCornerDistancePixels = this.maxCornerDistance.computeI((double)Math.min(((ImageGray)input).width, ((ImageGray)input).height));
        this.s2c.setMaxCornerDistance(maxCornerDistancePixels);
        this.configureContourDetector(input);
        this.boundPolygon.vertexes.reset();
        this.detectorSquare.process(input, binary);
        this.detectorSquare.refineAll();
        List found = this.detectorSquare.getPolygonInfo();
        this.clusters = this.s2c.process(found);
        this.c2g.process(this.clusters);
        List grids = this.c2g.getGrids().toList();
        for (int i = 0; i < grids.size(); ++i) {
            SquareGrid grid = (SquareGrid)grids.get(i);
            if (grid.rows == this.numCols && grid.columns == this.numRows) {
                this.tools.transpose(grid);
            }
            if (grid.rows != this.numRows || grid.columns != this.numCols) continue;
            if (grid.get(0, 0) == null) {
                if (grid.get(0, -1) != null) {
                    this.tools.flipColumns(grid);
                } else {
                    if (grid.get(-1, 0) == null) continue;
                    this.tools.flipRows(grid);
                }
            }
            if (!this.ensureCCW(grid)) continue;
            this.putIntoCanonical(grid);
            return this.computeCalibrationPoints(grid);
        }
        return false;
    }

    private void configureContourDetector(T gray) {
        int maxContourSize = Math.max(((ImageGray)gray).width, ((ImageGray)gray).height) / Math.max(this.numCols, this.numRows);
        BinaryContourFinder contourFinder = this.detectorSquare.getDetector().getContourFinder();
        contourFinder.setMaxContour(maxContourSize * 4 * 2);
        contourFinder.setSaveInnerContour(false);
    }

    public void adjustBeforeOptimize(Polygon2D_F64 polygon, DogArray_B touchesBorder, boolean clockwise) {
        int i;
        int N = polygon.size();
        this.work.vertexes.resize(N);
        for (i = 0; i < N; ++i) {
            this.work.get(i).setTo(0.0, 0.0);
        }
        i = N - 1;
        int j = 0;
        while (j < N) {
            int kk;
            int jj;
            int ii;
            int mm;
            if (clockwise) {
                mm = CircularIndex.addOffset((int)-1, (int)i, (int)N);
                ii = i;
                jj = j;
                kk = CircularIndex.addOffset((int)1, (int)j, (int)N);
            } else {
                mm = CircularIndex.addOffset((int)1, (int)j, (int)N);
                ii = j;
                jj = i;
                kk = CircularIndex.addOffset((int)-1, (int)i, (int)N);
            }
            Point2D_F64 a = polygon.get(ii);
            Point2D_F64 b = polygon.get(jj);
            double dx = b.x - a.x;
            double dy = b.y - a.y;
            double l = Math.sqrt(dx * dx + dy * dy);
            if (l == 0.0) {
                throw new RuntimeException("Input polygon has two identical corners. You need to fix that.");
            }
            dx *= 1.5 / l;
            dy *= 1.5 / l;
            Point2D_F64 _a = this.work.get(ii);
            Point2D_F64 _b = this.work.get(jj);
            if (touchesBorder.size > 0 && touchesBorder.get(ii)) {
                if (!touchesBorder.get(mm)) {
                    _a.x -= dx;
                    _a.y -= dy;
                }
            } else {
                _a.x += -dy;
                _a.y += dx;
            }
            if (touchesBorder.size > 0 && touchesBorder.get(jj)) {
                if (!touchesBorder.get(kk)) {
                    _b.x += dx;
                    _b.y += dy;
                }
            } else {
                _b.x += -dy;
                _b.y += dx;
            }
            i = j++;
        }
        for (i = 0; i < N; ++i) {
            Point2D_F64 a = polygon.get(i);
            Point2D_F64 b = this.work.get(i);
            a.x += b.x;
            a.y += b.y;
        }
    }

    boolean ensureCCW(SquareGrid grid) {
        if (grid.columns <= 2 && grid.rows <= 2) {
            return true;
        }
        Point2D_F64 a = grid.get((int)0, (int)0).center;
        Point2D_F64 b = grid.columns > 2 ? grid.get((int)0, (int)2).center : grid.get((int)1, (int)1).center;
        Point2D_F64 c = grid.rows > 2 ? grid.get((int)2, (int)0).center : grid.get((int)1, (int)1).center;
        double x0 = b.x - a.x;
        double y1 = c.y - a.y;
        double y0 = b.y - a.y;
        double x1 = c.x - a.x;
        double z = x0 * y1 - y0 * x1;
        if (z < 0.0) {
            if (grid.columns % 2 == 1) {
                this.tools.flipColumns(grid);
            } else if (grid.rows % 2 == 1) {
                this.tools.flipRows(grid);
            } else {
                return false;
            }
        }
        return true;
    }

    void putIntoCanonical(SquareGrid grid) {
        boolean colOdd;
        boolean rowOdd = grid.rows % 2 == 1;
        boolean bl = colOdd = grid.columns % 2 == 1;
        if (colOdd == rowOdd) {
            if (rowOdd && grid.rows == grid.columns) {
                int i;
                int best = -1;
                double bestDistance = Double.MAX_VALUE;
                for (i = 0; i < 4; ++i) {
                    SquareNode n = grid.getCornerByIndex(i);
                    double d = n.center.normSq();
                    if (!(d < bestDistance)) continue;
                    best = i;
                    bestDistance = d;
                }
                for (i = 0; i < best; ++i) {
                    this.tools.rotateCCW(grid);
                }
            } else {
                double first = grid.get((int)0, (int)0).center.normSq();
                double last = grid.getCornerByIndex((int)2).center.normSq();
                if (last < first) {
                    this.tools.reverse(grid);
                }
            }
        }
    }

    boolean computeCalibrationPoints(SquareGrid grid) {
        this.calibrationPoints.reset();
        int pointID = 0;
        for (int row = 0; row < grid.rows - 1; ++row) {
            int offset;
            for (int col = offset = row % 2; col < grid.columns; col += 2) {
                PointIndex2D_F64 p;
                SquareNode b;
                SquareNode a = grid.get(row, col);
                if (col > 0) {
                    b = grid.get(row + 1, col - 1);
                    p = (PointIndex2D_F64)this.calibrationPoints.grow();
                    p.index = pointID;
                    if (!this.setIntersection(a, b, (Point2D_F64)p.p)) {
                        return false;
                    }
                }
                if (col >= grid.columns - 1) continue;
                b = grid.get(row + 1, col + 1);
                p = (PointIndex2D_F64)this.calibrationPoints.grow();
                p.index = pointID;
                if (this.setIntersection(a, b, (Point2D_F64)p.p)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean setIntersection(SquareNode a, SquareNode n, Point2D_F64 point) {
        for (int i = 0; i < a.edges.length; ++i) {
            SquareEdge edge = a.edges[i];
            if (edge == null || edge.destination(a) != n) continue;
            Point2D_F64 p0 = edge.a.square.get(edge.sideA);
            Point2D_F64 p1 = edge.b.square.get(edge.sideB);
            point.x = (p0.x + p1.x) / 2.0;
            point.y = (p0.y + p1.y) / 2.0;
            return true;
        }
        return false;
    }

    public List<List<SquareNode>> getGraphs() {
        return this.clusters;
    }

    public SquaresIntoCrossClusters getShapeToClusters() {
        return this.s2c;
    }

    public SquareCrossClustersIntoGrids getGrids() {
        return this.c2g;
    }

    public DetectPolygonBinaryGrayRefine<T> getDetectorSquare() {
        return this.detectorSquare;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public DogArray<PointIndex2D_F64> getCalibrationPoints() {
        return this.calibrationPoints;
    }
}

