/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.abst.fiducial.calib.ConfigChessboardX;
import boofcv.alg.feature.detect.chess.DetectChessboardCornersXPyramid;
import boofcv.alg.fiducial.calib.chess.ChessboardCornerClusterFinder;
import boofcv.alg.fiducial.calib.chess.ChessboardCornerClusterToGrid;
import boofcv.alg.fiducial.calib.chess.ChessboardCornerGraph;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.DogArray;

public class DetectChessboardXCornerPatterns<T extends ImageGray<T>> {
    protected DetectChessboardCornersXPyramid<T> detector;
    protected ChessboardCornerClusterFinder<T> clusterFinder;
    protected ChessboardCornerClusterToGrid clusterToGrid = new ChessboardCornerClusterToGrid();
    protected DogArray<ChessboardCornerClusterToGrid.GridInfo> found = new DogArray(ChessboardCornerClusterToGrid.GridInfo::new);

    public DetectChessboardXCornerPatterns(ConfigChessboardX config, Class<T> imageType) {
        this.detector = new DetectChessboardCornersXPyramid(ImageType.single(imageType));
        this.clusterFinder = new ChessboardCornerClusterFinder<T>(imageType);
        this.detector.setPyramidTopSize(config.detPyramidTopSize);
        this.detector.getDetector().setNonmaxRadius(config.detNonMaxRadius);
        this.detector.getDetector().setNonmaxThresholdRatio((float)config.detNonMaxThresholdRatio);
        this.detector.getDetector().setRefinedXCornerThreshold(config.detRefinedXCornerThreshold);
        this.clusterFinder.setAmbiguousTol(config.connAmbiguousTol);
        this.clusterFinder.setDirectionTol(config.connDirectionTol);
        this.clusterFinder.setOrientationTol(config.connOrientationTol);
        this.clusterFinder.setMaxNeighbors(config.connMaxNeighbors);
        this.clusterFinder.setMaxNeighborDistance(config.connMaxNeighborDistance);
        this.clusterFinder.setThresholdEdgeIntensity(config.connEdgeThreshold);
        this.clusterToGrid.setRequireCornerSquares(config.gridRequireCornerSquares);
    }

    public void setCheckShape(ChessboardCornerClusterToGrid.CheckShape checkShape) {
        this.clusterToGrid.setCheckShape(checkShape);
    }

    public void findPatterns(T input) {
        this.found.reset();
        this.detector.process(input);
        this.clusterFinder.process(input, this.detector.getCorners().toList(), this.detector.getNumberOfLevels());
        DogArray<ChessboardCornerGraph> clusters = this.clusterFinder.getOutputClusters();
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            ChessboardCornerGraph c = (ChessboardCornerGraph)clusters.get(clusterIdx);
            if (!this.clusterToGrid.clusterToSparse(c) || this.clusterToGrid.sparseToGrid((ChessboardCornerClusterToGrid.GridInfo)this.found.grow())) continue;
            this.found.removeTail();
        }
    }

    public DogArray<ChessboardCornerClusterToGrid.GridInfo> getFoundChessboard() {
        return this.found;
    }

    public DetectChessboardCornersXPyramid<T> getDetector() {
        return this.detector;
    }

    public ChessboardCornerClusterFinder<T> getClusterFinder() {
        return this.clusterFinder;
    }

    public ChessboardCornerClusterToGrid getClusterToGrid() {
        return this.clusterToGrid;
    }
}

