/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.ecocheck;

import boofcv.abst.fiducial.calib.ConfigECoCheckMarkers;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckCodec;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckFound;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckLayout;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.geo.h.HomographyDirectLinearTransform;
import boofcv.struct.GridCoordinate;
import boofcv.struct.GridShape;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PointIndex;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.shapes.Rectangle2D_F64;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;
import org.ejml.data.DMatrixRMaj;

public class ECoCheckUtils {
    public double dataBitWidthFraction = 0.7;
    public double dataBorderFraction = 0.15;
    public final List<GridShape> markers = new ArrayList<GridShape>();
    public int bitSampleGridSize = 2;
    protected int bitSampleCount;
    public final ECoCheckCodec codec = new ECoCheckCodec();
    public final DogArray_I32 bitOrder = new DogArray_I32();
    HomographyDirectLinearTransform dlt = new HomographyDirectLinearTransform(true);
    DogArray<AssociatedPair> storagePairs2D = new DogArray(AssociatedPair::new);
    DMatrixRMaj squareToPixel = new DMatrixRMaj(3, 3);
    Rectangle2D_F64 rect = new Rectangle2D_F64();
    Point2D_F64 bitSquare = new Point2D_F64();
    DogArray_I32 histogram = new DogArray_I32();

    public ECoCheckUtils() {
        this.histogram.resize(100);
    }

    public void setParametersFromConfig(ConfigECoCheckMarkers config) {
        this.dataBitWidthFraction = config.dataBitWidthFraction;
        this.dataBorderFraction = config.dataBorderFraction;
        this.codec.setChecksumBitCount(config.checksumBits);
        this.codec.setErrorCorrectionLevel(config.errorCorrectionLevel);
        config.convertToGridList(this.markers);
    }

    public void addMarker(int squareRows, int squareCols) {
        this.markers.add(new GridShape(squareRows, squareCols));
    }

    public void fixate() {
        this.codec.configure(this.markers.size(), this.findMaxEncodedSquares());
        this.bitSampleCount = this.bitSampleGridSize * 2 + 1;
        new ECoCheckLayout().selectSnake(this.codec.gridBitLength, this.bitOrder);
    }

    public void checkFixate() {
        if (this.bitSampleCount == 0) {
            throw new RuntimeException("BUG you forgot to call fixate()");
        }
    }

    int findMaxEncodedSquares() {
        int largest = 0;
        for (int i = 0; i < this.markers.size(); ++i) {
            GridShape g = this.markers.get(i);
            int rows = g.rows - 2;
            int cols = g.cols - 2;
            int count = rows / 2 * cols + rows % 2 * (cols / 2);
            if (count <= largest) continue;
            largest = count;
        }
        return largest;
    }

    public void bitRect(int row, int col, Rectangle2D_F64 rect) {
        int bitGridLength = this.codec.getGridBitLength();
        double cellWidth = (1.0 - this.dataBorderFraction * 2.0) / (double)bitGridLength;
        double offset = this.dataBorderFraction + cellWidth * (1.0 - this.dataBitWidthFraction) / 2.0;
        rect.p0.x = (double)col * cellWidth + offset;
        rect.p0.y = (double)row * cellWidth + offset;
        rect.p1.x = rect.p0.x + cellWidth * this.dataBitWidthFraction;
        rect.p1.y = rect.p0.y + cellWidth * this.dataBitWidthFraction;
    }

    public boolean computeGridToImage(Point2D_F64 a, Point2D_F64 b, Point2D_F64 c, Point2D_F64 d) {
        this.storagePairs2D.resetResize(4);
        ((AssociatedPair)this.storagePairs2D.get(0)).setTo(0.0, 0.0, a.x, a.y);
        ((AssociatedPair)this.storagePairs2D.get(1)).setTo(1.0, 0.0, b.x, b.y);
        ((AssociatedPair)this.storagePairs2D.get(2)).setTo(1.0, 1.0, c.x, c.y);
        ((AssociatedPair)this.storagePairs2D.get(3)).setTo(0.0, 1.0, d.x, d.y);
        return this.dlt.process(this.storagePairs2D.toList(), this.squareToPixel);
    }

    public float otsuThreshold(DogArray_F32 values) {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (int i = 0; i < values.size; ++i) {
            min = Math.min(min, values.data[i]);
            max = Math.max(max, values.data[i]);
        }
        float range = max - min;
        this.histogram.fill(0);
        for (int i = 0; i < values.size; ++i) {
            float v = values.data[i];
            int index = (int)((float)this.histogram.size * (v - min) / range);
            int n = Math.min(this.histogram.size - 1, index);
            this.histogram.data[n] = this.histogram.data[n] + 1;
        }
        int selected = GThresholdImageOps.computeOtsu((int[])this.histogram.data, (int)this.histogram.size, (int)values.size);
        return range * (float)selected / (float)(this.histogram.size - 1) + min;
    }

    public void gridToPixel(double x, double y, Point2D_F64 pixel) {
        this.bitSquare.setTo(x, y);
        GeometryMath_F64.mult((DMatrixRMaj)this.squareToPixel, (GeoTuple2D_F64)this.bitSquare, (GeoTuple2D_F64)pixel);
    }

    public void selectPixelsToSample(DogArray<Point2D_F64> pixels) {
        int bitGridLength = this.codec.getGridBitLength();
        pixels.reset();
        double sampleLength = 0.5 * this.dataBitWidthFraction;
        double padding = (1.0 - sampleLength) / 2.0;
        for (int row = 0; row < bitGridLength; ++row) {
            for (int col = 0; col < bitGridLength; ++col) {
                this.bitRect(row, col, this.rect);
                for (int i = 0; i < this.bitSampleGridSize; ++i) {
                    this.bitSquare.y = (this.rect.p1.y - this.rect.p0.y) * (padding + sampleLength * (double)i / (double)(this.bitSampleGridSize - 1)) + this.rect.p0.y;
                    for (int j = 0; j < this.bitSampleGridSize; ++j) {
                        this.bitSquare.x = (this.rect.p1.x - this.rect.p0.x) * (padding + sampleLength * (double)j / (double)(this.bitSampleGridSize - 1)) + this.rect.p0.x;
                        GeometryMath_F64.mult((DMatrixRMaj)this.squareToPixel, (GeoTuple2D_F64)this.bitSquare, (GeoTuple2D_F64)((Point2D_F64)pixels.grow()));
                    }
                }
                this.bitSquare.y = (this.rect.p1.y + this.rect.p0.y) * 0.5;
                this.bitSquare.x = (this.rect.p1.x + this.rect.p0.x) * 0.5;
                GeometryMath_F64.mult((DMatrixRMaj)this.squareToPixel, (GeoTuple2D_F64)this.bitSquare, (GeoTuple2D_F64)((Point2D_F64)pixels.grow()));
            }
        }
    }

    public void cellIdToCornerCoordinate(int markerID, int cellID, GridCoordinate coordinate) {
        GridShape grid = this.markers.get(markerID);
        int setCount = grid.cols - 2;
        int setHalf = setCount / 2;
        int squareRow = 1 + 2 * (cellID / setCount) + (cellID % setCount < setHalf ? 0 : 1);
        int squareCol = squareRow % 2 == 0 ? (cellID % setCount - setHalf) * 2 + 1 : (cellID % setCount + 1) * 2;
        coordinate.row = squareRow - 1;
        coordinate.col = squareCol - 1;
    }

    static void rotateObserved(int numRows, int numCols, int row, int col, int orientation, GridCoordinate found) {
        switch (orientation) {
            case 0: {
                found.setTo(row, col);
                break;
            }
            case 1: {
                found.setTo(-col, row);
                break;
            }
            case 2: {
                found.setTo(-row, -col);
                break;
            }
            case 3: {
                found.setTo(col, -row);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown orientation");
            }
        }
    }

    public static void adjustTopLeft(int orientation, GridCoordinate coordinate) {
        switch (orientation) {
            case 0: {
                break;
            }
            case 1: {
                --coordinate.row;
                break;
            }
            case 2: {
                --coordinate.row;
                --coordinate.col;
                break;
            }
            case 3: {
                --coordinate.col;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown orientation: " + orientation);
            }
        }
    }

    public int countEncodedSquaresInMarker(int markerID) {
        GridShape grid = this.markers.get(markerID);
        int setCount = grid.cols - 2;
        int total = (grid.rows - 2) / 2 * setCount;
        if (grid.rows % 2 == 1) {
            total += (grid.cols - 1) / 2;
        }
        return total;
    }

    public void cornerToMarker3D(int markerID, int cornerID, Point3D_F64 coordinate) {
        GridShape grid = this.markers.get(markerID);
        double squareToUnit = 1.0 / (double)(Math.max(grid.cols, grid.rows) - 1);
        this.cornerToMarker3D(markerID, cornerID, squareToUnit, coordinate);
    }

    public void cornerToMarker3D(int markerID, int cornerID, double squareLength, Point3D_F64 coordinate) {
        GridShape grid = this.markers.get(markerID);
        double width = (double)(grid.cols - 1) * squareLength;
        double height = (double)(grid.rows - 1) * squareLength;
        int row = cornerID / (grid.cols - 1);
        int col = cornerID % (grid.cols - 1);
        coordinate.x = (0.5 + (double)col) * squareLength - width / 2.0;
        coordinate.y = (0.5 + (double)row) * squareLength - height / 2.0;
        coordinate.z = 0.0;
        coordinate.y *= -1.0;
    }

    public List<Point2D_F64> createCornerList(int markerID, double squareLength) {
        ArrayList<Point2D_F64> corners = new ArrayList<Point2D_F64>();
        GridShape grid = this.markers.get(markerID);
        double width = (double)(grid.cols - 1) * squareLength;
        double height = (double)(grid.rows - 1) * squareLength;
        int numCorners = (grid.rows - 1) * (grid.cols - 1);
        for (int cornerID = 0; cornerID < numCorners; ++cornerID) {
            int row = cornerID / (grid.cols - 1);
            int col = cornerID % (grid.cols - 1);
            Point2D_F64 coordinate = new Point2D_F64();
            coordinate.x = (0.5 + (double)col) * squareLength - width / 2.0;
            coordinate.y = (0.5 + (double)row) * squareLength - height / 2.0;
            coordinate.y *= -1.0;
            corners.add(coordinate);
        }
        return corners;
    }

    public static int maxCorners(int rows, int cols) {
        return (rows - 1) * (cols - 1);
    }

    public boolean isLegalCornerIds(ECoCheckFound found) {
        GridShape shape = this.markers.get(found.markerID);
        int maxCornerID = ECoCheckUtils.maxCorners(shape.rows, shape.cols);
        for (int cornerIdx = 0; cornerIdx < found.corners.size; ++cornerIdx) {
            if (((PointIndex2D_F64)found.corners.get((int)cornerIdx)).index < maxCornerID) continue;
            return false;
        }
        return true;
    }

    public List<ECoCheckFound> mergeAndRemoveUnknown(List<ECoCheckFound> found) {
        ArrayList<ECoCheckFound> merged = new ArrayList<ECoCheckFound>();
        DogArray_B used = new DogArray_B();
        for (int foundIdx = 0; foundIdx < found.size(); ++foundIdx) {
            ECoCheckFound f = found.get(foundIdx);
            if (f.markerID < 0 || !this.isLegalCornerIds(f)) continue;
            GridShape shape = this.markers.get(f.markerID);
            used.resetResize(ECoCheckUtils.maxCorners(shape.rows, shape.cols), false);
            ECoCheckFound match = null;
            for (int mergedIdx = 0; mergedIdx < merged.size(); ++mergedIdx) {
                int cornerIdx;
                ECoCheckFound m = (ECoCheckFound)merged.get(mergedIdx);
                if (f.markerID != m.markerID) continue;
                boolean conflict = false;
                for (cornerIdx = 0; cornerIdx < m.corners.size; ++cornerIdx) {
                    used.data[((PointIndex2D_F64)m.corners.get((int)cornerIdx)).index] = true;
                }
                for (cornerIdx = 0; cornerIdx < f.corners.size; ++cornerIdx) {
                    if (!used.data[((PointIndex2D_F64)f.corners.get((int)cornerIdx)).index]) continue;
                    conflict = true;
                    break;
                }
                if (conflict || match != null && match.corners.size >= m.corners.size) continue;
                match = m;
            }
            if (match == null) {
                merged.add(new ECoCheckFound(f));
                continue;
            }
            match.decodedCells.addAll(f.decodedCells);
            match.touchBinary.addAll(f.touchBinary);
            for (int j = 0; j < f.corners.size; ++j) {
                ((PointIndex2D_F64)match.corners.grow()).setTo((PointIndex)((PointIndex2D_F64)f.corners.get(j)));
            }
        }
        Collections.sort(merged, Comparator.comparingInt(a -> -a.corners.size));
        for (int i = 0; i < merged.size(); ++i) {
            int target = ((ECoCheckFound)merged.get((int)i)).markerID;
            for (int j = merged.size() - 1; j >= i + 1; --j) {
                if (((ECoCheckFound)merged.get((int)j)).markerID != target) continue;
                merged.remove(j);
            }
        }
        return merged;
    }

    public double getDataBitWidthFraction() {
        return this.dataBitWidthFraction;
    }

    public void setDataBitWidthFraction(double dataBitWidthFraction) {
        this.dataBitWidthFraction = dataBitWidthFraction;
    }

    public double getDataBorderFraction() {
        return this.dataBorderFraction;
    }

    public void setDataBorderFraction(double dataBorderFraction) {
        this.dataBorderFraction = dataBorderFraction;
    }

    public int getBitSampleCount() {
        return this.bitSampleCount;
    }
}

