/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.microqr;

import boofcv.alg.fiducial.microqr.MicroQrCode;
import boofcv.alg.fiducial.microqr.MicroQrCodeEncoder;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeCodecBitsUtils;
import boofcv.alg.fiducial.qrcode.ReidSolomonCodes;
import boofcv.misc.BoofMiscOps;
import java.io.PrintStream;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray_I8;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class MicroQrCodeDecoderBits
implements VerbosePrint {
    ReidSolomonCodes rscodes = new ReidSolomonCodes(8, 285);
    DogArray_I8 message = new DogArray_I8();
    DogArray_I8 ecc = new DogArray_I8();
    QrCodeCodecBitsUtils utils;
    PackedBits8 decodeBits = new PackedBits8();
    @Nullable
    PrintStream verbose = null;

    public MicroQrCodeDecoderBits(@Nullable String forceEncoding, String defaultEncoding) {
        this.utils = new QrCodeCodecBitsUtils(forceEncoding, defaultEncoding);
    }

    public boolean applyErrorCorrection(MicroQrCode qr) {
        MicroQrCode.VersionInfo info = MicroQrCode.VERSION_INFO[qr.version];
        MicroQrCode.DataInfo block = Objects.requireNonNull(info.levels.get((Object)qr.error));
        int wordsEcc = info.codewords - block.dataCodewords;
        qr.corrected = new byte[block.dataCodewords];
        this.ecc.resize(wordsEcc);
        this.rscodes.generator(wordsEcc);
        this.message.resize(block.dataCodewords);
        System.arraycopy(qr.rawbits, 0, this.message.data, 0, this.message.size);
        System.arraycopy(qr.rawbits, block.dataCodewords, this.ecc.data, 0, this.ecc.size);
        QrCodeCodecBitsUtils.flipBits8(this.message);
        QrCodeCodecBitsUtils.flipBits8(this.ecc);
        if (!this.rscodes.correct(this.message, this.ecc)) {
            return false;
        }
        qr.totalBitErrors = this.rscodes.getTotalErrors();
        QrCodeCodecBitsUtils.flipBits8(this.message);
        System.arraycopy(this.message.data, 0, qr.corrected, 0, this.message.size);
        return true;
    }

    public boolean decodeMessage(MicroQrCode qr) {
        if (this.verbose != null) {
            this.verbose.println("decode: version=" + qr.version + " error=" + qr.error + " corrected.length=" + qr.corrected.length);
        }
        this.decodeBits.data = qr.corrected;
        this.decodeBits.size = qr.getMaxDataBits();
        this.utils.workString.setLength(0);
        int terminatorBits = qr.terminatorBits();
        String byteEncoding = "";
        int location = 0;
        while (location <= this.decodeBits.size) {
            QrCode.Mode mode;
            int adjustedTerminatorBits = Math.min(this.decodeBits.size - location, terminatorBits);
            int terminator = this.decodeBits.read(location, adjustedTerminatorBits, false);
            if (terminator == 0) {
                location += terminatorBits;
                break;
            }
            int modeLength = MicroQrCode.modeIndicatorBitCount(qr.version);
            if (location + modeLength > this.decodeBits.size) {
                if (this.verbose != null) {
                    this.verbose.println("reading mode overflowed");
                }
                qr.failureCause = QrCode.Failure.MESSAGE_OVERFLOW;
                return false;
            }
            if (modeLength >= 0) {
                int modeBits = this.decodeBits.read(location, modeLength, true);
                location += modeLength;
                mode = MicroQrCode.valueToMode(modeBits);
                if (mode == QrCode.Mode.UNKNOWN) {
                    if (this.verbose != null) {
                        this.verbose.println("mode=UNKNOWN Bad encoding?");
                    }
                    return false;
                }
            } else {
                mode = QrCode.Mode.NUMERIC;
            }
            qr.mode = this.updateModeLogic(qr.mode, mode);
            if (this.verbose != null) {
                this.verbose.println("_ mode=" + mode);
            }
            switch (mode) {
                case NUMERIC: {
                    location = this.decodeNumeric(qr, this.decodeBits, location);
                    break;
                }
                case ALPHANUMERIC: {
                    location = this.decodeAlphanumeric(qr, this.decodeBits, location);
                    break;
                }
                case BYTE: {
                    location = this.decodeByte(qr, this.decodeBits, location);
                    if (!byteEncoding.isEmpty()) break;
                    byteEncoding = this.utils.selectedByteEncoding;
                    break;
                }
                case KANJI: {
                    location = this.decodeKanji(qr, this.decodeBits, location);
                    break;
                }
                default: {
                    if (this.verbose != null) {
                        this.verbose.println("Bad mode. mode=" + mode);
                    }
                    qr.failureCause = QrCode.Failure.UNKNOWN_MODE;
                    return false;
                }
            }
            if (this.verbose != null) {
                this.verbose.println("_ work.length=" + this.utils.workString.length() + " location=" + location);
            }
            if (location >= 0) continue;
            if (this.verbose != null) {
                this.verbose.println("_ Failed: cause=" + this.utils.failureCause);
            }
            qr.failureCause = this.utils.failureCause;
            return false;
        }
        if (location < this.decodeBits.size && !this.checkPadding(location)) {
            if (this.verbose != null) {
                this.verbose.println("_ bad padding");
            }
            qr.failureCause = QrCode.Failure.READING_PADDING;
            return false;
        }
        qr.byteEncoding = byteEncoding;
        qr.message = this.utils.workString.toString();
        return true;
    }

    private boolean checkPadding(int location) {
        int filler;
        if (this.decodeBits.size - location < 8) {
            return true;
        }
        int fillerBits = (8 - location % 8) % 8;
        if (fillerBits > 0 && (filler = this.decodeBits.read(location, fillerBits, false)) != 0) {
            return false;
        }
        boolean even = true;
        for (int bit = (location += fillerBits) + 8; bit <= this.decodeBits.size; bit += 8) {
            int padding = this.decodeBits.read(bit - 8, 8, false);
            if (even ? padding != 55 : padding != 136) {
                return false;
            }
            even = !even;
        }
        return true;
    }

    private QrCode.Mode updateModeLogic(QrCode.Mode current, QrCode.Mode candidate) {
        if (current == candidate) {
            return current;
        }
        if (current == QrCode.Mode.UNKNOWN) {
            return candidate;
        }
        return QrCode.Mode.MIXED;
    }

    private int decodeNumeric(MicroQrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = MicroQrCodeEncoder.getLengthBitsNumeric(qr.version);
        return this.utils.decodeNumeric(data, bitLocation, lengthBits);
    }

    private int decodeAlphanumeric(MicroQrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = MicroQrCodeEncoder.getLengthBitsAlphanumeric(qr.version);
        return this.utils.decodeAlphanumeric(data, bitLocation, lengthBits);
    }

    private int decodeByte(MicroQrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = MicroQrCodeEncoder.getLengthBitsBytes(qr.version);
        return this.utils.decodeByte(data, bitLocation, lengthBits);
    }

    private int decodeKanji(MicroQrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = MicroQrCodeEncoder.getLengthBitsKanji(qr.version);
        return this.utils.decodeKanji(data, bitLocation, lengthBits);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)out, configuration, (VerbosePrint[])new VerbosePrint[]{this.utils});
    }

    public QrCodeCodecBitsUtils getUtils() {
        return this.utils;
    }
}

