/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.microqr;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.microqr.MicroQrCode;
import boofcv.alg.fiducial.microqr.MicroQrCodeDecoderBits;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.PositionPatternNode;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeAlignmentPatternLocator;
import boofcv.alg.fiducial.qrcode.QrCodeBinaryGridReader;
import boofcv.alg.fiducial.qrcode.QrCodeDecoderImage;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageGray;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class MicroQrCodeDecoderImage<T extends ImageGray<T>>
implements VerbosePrint {
    MicroQrCodeDecoderBits decoder;
    public boolean considerTransposed = true;
    DogArray<MicroQrCode> storageQR = new DogArray(MicroQrCode::new, MicroQrCode::reset);
    List<MicroQrCode> found = new ArrayList<MicroQrCode>();
    List<MicroQrCode> failures = new ArrayList<MicroQrCode>();
    PackedBits8 bits = new PackedBits8();
    QrCodeAlignmentPatternLocator<T> alignmentLocator;
    QrCodeBinaryGridReader<T> gridReader;
    DogArray_F32 intensityBits = new DogArray_F32();
    @Nullable
    PrintStream verbose = null;

    public MicroQrCodeDecoderImage(@Nullable String forceEncoding, String defaultEncoding, Class<T> imageType) {
        this.decoder = new MicroQrCodeDecoderBits(forceEncoding, defaultEncoding);
        this.gridReader = new QrCodeBinaryGridReader<T>(imageType);
        this.alignmentLocator = new QrCodeAlignmentPatternLocator<T>(imageType);
    }

    public void process(List<PositionPatternNode> pps, T gray) {
        this.gridReader.setImage(gray);
        this.storageQR.reset();
        this.found.clear();
        this.failures.clear();
        for (int i = 0; i < pps.size(); ++i) {
            PositionPatternNode ppn = pps.get(i);
            MicroQrCode qr = (MicroQrCode)this.storageQR.grow();
            qr.thresholdPP = ppn.grayThreshold;
            qr.pp.setTo(ppn.square);
            boolean success = false;
            block1: for (int transposed = 0; transposed < (this.considerTransposed ? 2 : 1); ++transposed) {
                if (transposed == 1) {
                    QrCodeDecoderImage.transposeCorners(qr.pp);
                }
                for (int orientation = 0; orientation < 4; ++orientation) {
                    if (this.verbose != null) {
                        this.verbose.printf("idx=%d trans=%d orientation=%d pp=%s\n", i, transposed, orientation, qr.pp);
                    }
                    if (this.decode(qr)) {
                        this.found.add(qr);
                        qr.bitsTransposed = transposed == 1;
                        success = true;
                        break block1;
                    }
                    UtilPolygons2D_F64.shiftDown((Polygon2D_F64)qr.pp);
                }
            }
            if (success) continue;
            this.failures.add(qr);
        }
    }

    private boolean decode(MicroQrCode qr) {
        qr.failureCause = QrCode.Failure.NONE;
        if (!this.readFormatBitValues(qr)) {
            return false;
        }
        qr.Hinv.setTo(this.gridReader.getTransformGrid().Hinv);
        if (!this.decodeFormatBitValues(qr)) {
            qr.bounds.setTo(qr.pp);
            if (this.verbose != null) {
                this.verbose.print("_ failed: reading format\n");
            }
            qr.failureCause = QrCode.Failure.FORMAT;
            return false;
        }
        this.setBoundsOfMarker(qr);
        if (this.verbose != null) {
            this.verbose.printf("valid: version=%d error=%s mask=%s\n", new Object[]{qr.version, qr.error, qr.mask});
        }
        if (!this.readRawData(qr)) {
            if (this.verbose != null) {
                this.verbose.print("_ failed: reading bits\n");
            }
            qr.failureCause = QrCode.Failure.READING_BITS;
            return false;
        }
        if (!this.decoder.applyErrorCorrection(qr)) {
            if (this.verbose != null) {
                this.verbose.print("_ failed: error correction\n");
            }
            qr.failureCause = QrCode.Failure.ERROR_CORRECTION;
            return false;
        }
        if (!this.decoder.decodeMessage(qr)) {
            if (this.verbose != null) {
                this.verbose.print("_ failed: decoding message\n");
            }
            qr.failureCause = QrCode.Failure.DECODING_MESSAGE;
            return false;
        }
        if (this.verbose != null) {
            this.verbose.printf("_ success: message='%s'\n", qr.message);
        }
        return true;
    }

    private void setBoundsOfMarker(MicroQrCode qr) {
        int N = qr.getNumberOfModules();
        qr.bounds.get(0).setTo(qr.pp.get(0));
        HomographyPointOps_F64.transform((Homography2D_F64)qr.Hinv, (double)N, (double)0.0, (Point2D_F64)qr.bounds.get(1));
        HomographyPointOps_F64.transform((Homography2D_F64)qr.Hinv, (double)N, (double)N, (Point2D_F64)qr.bounds.get(2));
        HomographyPointOps_F64.transform((Homography2D_F64)qr.Hinv, (double)0.0, (double)N, (Point2D_F64)qr.bounds.get(3));
    }

    private boolean decodeFormatBitValues(MicroQrCode qr) {
        int bitField = this.bits.read(0, 15, false);
        if (bitField == 0 || (bitField & Short.MAX_VALUE) == Short.MAX_VALUE) {
            return false;
        }
        return qr.decodeFormatBits(bitField ^= 0x4445);
    }

    boolean readFormatBitValues(MicroQrCode qr) {
        int i;
        this.gridReader.setSquare(qr.pp, (float)qr.thresholdPP);
        this.bits.resize(15);
        this.bits.zero();
        for (i = 0; i < 8; ++i) {
            this.read(i, i + 1, 8);
        }
        for (i = 0; i < 7; ++i) {
            this.read(i + 8, 8, 7 - i);
        }
        return true;
    }

    boolean readRawData(MicroQrCode qr) {
        MicroQrCode.VersionInfo info = MicroQrCode.VERSION_INFO[qr.version];
        List<Point2D_I32> locationBits = MicroQrCode.LOCATION_BITS[qr.version];
        qr.rawbits = new byte[info.codewords];
        this.readBitIntensityValues(locationBits);
        this.bitIntensityToBitValue(qr, locationBits);
        System.arraycopy(this.bits.data, 0, qr.rawbits, 0, qr.rawbits.length);
        return true;
    }

    void readBitIntensityValues(List<Point2D_I32> locationBits) {
        this.intensityBits.reserve(locationBits.size() * 5);
        this.intensityBits.reset();
        for (int bitIndex = 0; bitIndex < locationBits.size(); ++bitIndex) {
            Point2D_I32 b = locationBits.get(bitIndex);
            this.gridReader.readBitIntensity(b.y, b.x, this.intensityBits);
        }
    }

    void bitIntensityToBitValue(MicroQrCode qr, List<Point2D_I32> locationBits) {
        int numDataBits = qr.getMaxDataBits();
        if (numDataBits % 8 == 0) {
            numDataBits = Integer.MAX_VALUE;
        }
        this.bits.resize(locationBits.size());
        this.bits.zero();
        float threshold = (float)qr.thresholdPP;
        int intensityIndex = 0;
        while (intensityIndex < this.intensityBits.size) {
            int bit;
            int bitIndex = intensityIndex / 5;
            Point2D_I32 b = locationBits.get(bitIndex);
            int votes = 0;
            votes += this.intensityBits.data[intensityIndex++] < threshold ? 1 : 0;
            votes += this.intensityBits.data[intensityIndex++] < threshold ? 1 : 0;
            votes += this.intensityBits.data[intensityIndex++] < threshold ? 1 : 0;
            votes += this.intensityBits.data[intensityIndex++] < threshold ? 1 : 0;
            int n = bit = (votes += this.intensityBits.data[intensityIndex++] < threshold ? 1 : 0) >= 3 ? 1 : 0;
            if (bitIndex >= numDataBits) {
                bitIndex += 4;
            }
            this.bits.set(bitIndex, qr.mask.apply(b.y, b.x, bit));
        }
    }

    private void read(int bit, int row, int col) {
        int value = this.gridReader.readBit(row, col);
        if (value == -1) {
            value = 0;
        }
        this.bits.set(bit, value);
    }

    public void setLensDistortion(int width, int height, @Nullable LensDistortionNarrowFOV model) {
        this.alignmentLocator.setLensDistortion(width, height, model);
        this.gridReader.setLensDistortion(width, height, model);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)out, configuration, (VerbosePrint[])new VerbosePrint[]{this.decoder});
    }

    public List<MicroQrCode> getFound() {
        return this.found;
    }

    public List<MicroQrCode> getFailures() {
        return this.failures;
    }
}

