/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.PackedBits;
import java.util.Arrays;

public class PackedBits8
implements PackedBits {
    public byte[] data = new byte[1];
    public int size;

    public static PackedBits8 wrap(byte[] data, int numberOfBits) {
        PackedBits8 a = new PackedBits8();
        a.data = data;
        a.size = numberOfBits;
        return a;
    }

    public PackedBits8(int totalBits) {
        this.resize(totalBits);
    }

    public PackedBits8() {
    }

    public void setTo(PackedBits8 src) {
        this.resize(src.size);
        System.arraycopy(src.data, 0, this.data, 0, src.arrayLength());
    }

    @Override
    public int get(int which) {
        int index = which / 8;
        int offset = which % 8;
        return (this.data[index] & 1 << offset) >> offset;
    }

    @Override
    public void set(int which, int value) {
        int index = which / 8;
        int offset = which % 8;
        int n = index;
        this.data[n] = (byte)(this.data[n] ^ (byte)((-value ^ this.data[index]) & 1 << offset));
    }

    public void append(int bits, int numberOfBits, boolean swapOrder) {
        if (numberOfBits > 32) {
            throw new IllegalArgumentException("Number of bits exceeds the size of bits");
        }
        int indexTail = this.size;
        this.growArray(numberOfBits, true);
        if (swapOrder) {
            for (int i = 0; i < numberOfBits; ++i) {
                this.set(indexTail + i, bits >> i & 1);
            }
        } else {
            for (int i = 0; i < numberOfBits; ++i) {
                this.set(indexTail + numberOfBits - i - 1, bits >> i & 1);
            }
        }
    }

    public void append(PackedBits8 bits, int numberOfBits) {
        if (numberOfBits > bits.size) {
            throw new IllegalArgumentException("numberOfBits must be <= bits.size");
        }
        int numWords = bits.size / 8;
        for (int i = 0; i < numWords; ++i) {
            this.append(bits.data[i] & 0xFF, 8, true);
        }
        int remaining = bits.size - numWords * 8;
        if (remaining == 0) {
            return;
        }
        int tail = bits.read(numWords * 8, remaining, true);
        this.append(tail, remaining, false);
    }

    public int read(int location, int length, boolean swapOrder) {
        if (length < 0 || length > 32) {
            throw new IllegalArgumentException("Length can't exceed 32");
        }
        if (location + length > this.size) {
            throw new IllegalArgumentException("Attempting to read past the end. length=" + length + " remaining=" + (this.size - location));
        }
        int output = 0;
        if (swapOrder) {
            for (int i = 0; i < length; ++i) {
                output |= this.get(location + i) << length - i - 1;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                output |= this.get(location + i) << i;
            }
        }
        return output;
    }

    public int getArray(int index) {
        return this.data[index] & 0xFF;
    }

    @Override
    public void resize(int totalBits) {
        this.size = totalBits;
        int N = this.arrayLength();
        if (this.data.length < N) {
            this.data = new byte[N];
        }
    }

    public void growArray(int amountBits, boolean saveValue) {
        this.size += amountBits;
        int N = this.size / 8 + (this.size % 8 == 0 ? 0 : 1);
        if (N > this.data.length) {
            int extra = Math.min(1024, N + 10);
            byte[] tmp = new byte[N + extra];
            if (saveValue) {
                System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            }
            this.data = tmp;
        }
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, 0, this.arrayLength(), (byte)0);
    }

    @Override
    public int length() {
        return this.size;
    }

    @Override
    public int arrayLength() {
        if (this.size % 8 == 0) {
            return this.size / 8;
        }
        return this.size / 8 + 1;
    }

    @Override
    public int elementBits() {
        return 8;
    }
}

