/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.EciEncoding;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeCodecBitsUtils;
import boofcv.alg.fiducial.qrcode.QrCodeEncoder;
import boofcv.alg.fiducial.qrcode.ReidSolomonCodes;
import java.util.Objects;
import org.ddogleg.struct.DogArray_I8;
import org.jetbrains.annotations.Nullable;

public class QrCodeDecoderBits {
    ReidSolomonCodes rscodes = new ReidSolomonCodes(8, 285);
    DogArray_I8 message = new DogArray_I8();
    DogArray_I8 ecc = new DogArray_I8();
    @Nullable
    String encodingEci;
    final QrCodeCodecBitsUtils utils;
    int totalErrorBits;

    public QrCodeDecoderBits(@Nullable String forceEncoding, String defaultEncoding) {
        this.utils = new QrCodeCodecBitsUtils(forceEncoding, defaultEncoding);
    }

    public boolean applyErrorCorrection(QrCode qr) {
        QrCode.VersionInfo info = QrCode.VERSION_INFO[qr.version];
        QrCode.BlockInfo block = Objects.requireNonNull(info.levels.get((Object)qr.error));
        int wordsBlockAllA = block.codewords;
        int wordsBlockDataA = block.dataCodewords;
        int wordsEcc = wordsBlockAllA - wordsBlockDataA;
        int numBlocksA = block.blocks;
        int wordsBlockAllB = wordsBlockAllA + 1;
        int wordsBlockDataB = wordsBlockDataA + 1;
        int numBlocksB = (info.codewords - wordsBlockAllA * numBlocksA) / wordsBlockAllB;
        int totalBlocks = numBlocksA + numBlocksB;
        int totalDataBytes = wordsBlockDataA * numBlocksA + wordsBlockDataB * numBlocksB;
        qr.corrected = new byte[totalDataBytes];
        this.ecc.resize(wordsEcc);
        this.rscodes.generator(wordsEcc);
        this.totalErrorBits = 0;
        if (!this.decodeBlocks(qr, wordsBlockDataA, numBlocksA, 0, 0, totalDataBytes, totalBlocks)) {
            return false;
        }
        if (!this.decodeBlocks(qr, wordsBlockDataB, numBlocksB, numBlocksA * wordsBlockDataA, numBlocksA, totalDataBytes, totalBlocks)) {
            return false;
        }
        qr.totalBitErrors = this.totalErrorBits;
        return true;
    }

    private boolean decodeBlocks(QrCode qr, int bytesInDataBlock, int numberOfBlocks, int bytesDataRead, int offsetBlock, int offsetEcc, int stride) {
        this.message.resize(bytesInDataBlock);
        for (int idxBlock = 0; idxBlock < numberOfBlocks; ++idxBlock) {
            this.copyFromRawData(qr.rawbits, this.message, this.ecc, offsetBlock + idxBlock, stride, offsetEcc);
            QrCodeCodecBitsUtils.flipBits8(this.message);
            QrCodeCodecBitsUtils.flipBits8(this.ecc);
            if (!this.rscodes.correct(this.message, this.ecc)) {
                return false;
            }
            this.totalErrorBits += this.rscodes.getTotalErrors();
            QrCodeCodecBitsUtils.flipBits8(this.message);
            System.arraycopy(this.message.data, 0, qr.corrected, bytesDataRead, this.message.size);
            bytesDataRead += this.message.size;
        }
        return true;
    }

    private void copyFromRawData(byte[] input, DogArray_I8 message, DogArray_I8 ecc, int offsetBlock, int stride, int offsetEcc) {
        int i;
        for (i = 0; i < message.size; ++i) {
            message.data[i] = input[i * stride + offsetBlock];
        }
        for (i = 0; i < ecc.size; ++i) {
            ecc.data[i] = input[i * stride + offsetBlock + offsetEcc];
        }
    }

    public boolean decodeMessage(QrCode qr) {
        int lengthBytes;
        qr.byteEncoding = "";
        this.encodingEci = null;
        PackedBits8 bits = new PackedBits8();
        bits.data = qr.corrected;
        bits.size = qr.corrected.length * 8;
        this.utils.workString.setLength(0);
        String byteEncoding = "";
        int location = 0;
        while (location + 4 <= bits.size) {
            int modeBits = bits.read(location, 4, true);
            location += 4;
            if (modeBits == 0) break;
            QrCode.Mode mode = QrCode.Mode.lookup(modeBits);
            qr.mode = this.updateModeLogic(qr.mode, mode);
            switch (mode) {
                case NUMERIC: {
                    location = this.decodeNumeric(qr, bits, location);
                    break;
                }
                case ALPHANUMERIC: {
                    location = this.decodeAlphanumeric(qr, bits, location);
                    break;
                }
                case BYTE: {
                    location = this.decodeByte(qr, bits, location);
                    if (!byteEncoding.isEmpty()) break;
                    byteEncoding = this.utils.selectedByteEncoding;
                    break;
                }
                case KANJI: {
                    location = this.decodeKanji(qr, bits, location);
                    break;
                }
                case ECI: {
                    location = this.decodeEci(bits, location);
                    break;
                }
                case FNC1_FIRST: 
                case FNC1_SECOND: {
                    break;
                }
                default: {
                    qr.failureCause = QrCode.Failure.UNKNOWN_MODE;
                    return false;
                }
            }
            if (location >= 0) continue;
            qr.failureCause = this.utils.failureCause;
            return false;
        }
        if (!this.checkPaddingBytes(qr, lengthBytes = (location = QrCodeDecoderBits.alignToBytes(location)) / 8)) {
            qr.failureCause = QrCode.Failure.READING_PADDING;
            return false;
        }
        qr.byteEncoding = byteEncoding;
        qr.message = this.utils.workString.toString();
        return true;
    }

    private QrCode.Mode updateModeLogic(QrCode.Mode current, QrCode.Mode candidate) {
        if (current == candidate) {
            return current;
        }
        if (current == QrCode.Mode.UNKNOWN) {
            return candidate;
        }
        return QrCode.Mode.MIXED;
    }

    public static int alignToBytes(int lengthBits) {
        return lengthBits + (8 - lengthBits % 8) % 8;
    }

    boolean checkPaddingBytes(QrCode qr, int lengthBytes) {
        boolean a = true;
        for (int i = lengthBytes; i < qr.corrected.length; ++i) {
            if (a) {
                if (55 != (qr.corrected[i] & 0xFF)) {
                    return false;
                }
            } else if (136 != (qr.corrected[i] & 0xFF)) {
                if (55 == (qr.corrected[i] & 0xFF)) {
                    a = true;
                } else {
                    return false;
                }
            }
            a = !a;
        }
        return true;
    }

    private int decodeNumeric(QrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = QrCodeEncoder.getLengthBitsNumeric(qr.version);
        return this.utils.decodeNumeric(data, bitLocation, lengthBits);
    }

    private int decodeAlphanumeric(QrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = QrCodeEncoder.getLengthBitsAlphanumeric(qr.version);
        return this.utils.decodeAlphanumeric(data, bitLocation, lengthBits);
    }

    private int decodeByte(QrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = QrCodeEncoder.getLengthBitsBytes(qr.version);
        this.utils.encodingEci = this.encodingEci;
        return this.utils.decodeByte(data, bitLocation, lengthBits);
    }

    private int decodeKanji(QrCode qr, PackedBits8 data, int bitLocation) {
        int lengthBits = QrCodeEncoder.getLengthBitsKanji(qr.version);
        return this.utils.decodeKanji(data, bitLocation, lengthBits);
    }

    int decodeEci(PackedBits8 data, int bitLocation) {
        int firstByte = data.read(bitLocation, 8, true);
        bitLocation += 8;
        int numCodeWords = 1;
        while ((firstByte & 1 << 7 - numCodeWords) != 0) {
            ++numCodeWords;
        }
        if (numCodeWords > 1) {
            firstByte <<= numCodeWords - 1;
            firstByte >>= numCodeWords - 1;
        }
        int assignmentValue = firstByte;
        for (int i = 1; i < numCodeWords; ++i) {
            assignmentValue <<= 8;
            assignmentValue |= data.read(bitLocation, 8, true);
            bitLocation += 8;
        }
        this.encodingEci = EciEncoding.getEciCharacterSet(assignmentValue);
        return bitLocation;
    }
}

