/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.kmeans;

import boofcv.struct.feature.TupleDesc_F32;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.LArrayAccessor;

public class ComputeMeanTuple_F32
implements ComputeMeanClusters<TupleDesc_F32> {
    DogArray_I32 counts = new DogArray_I32();

    public void process(LArrayAccessor<TupleDesc_F32> points, DogArray_I32 assignments, FastAccess<TupleDesc_F32> clusters) {
        if (assignments.size != points.size()) {
            throw new IllegalArgumentException("Points and assignments need to be the same size");
        }
        this.counts.resetResize(clusters.size, 0);
        for (int i = 0; i < clusters.size; ++i) {
            ((TupleDesc_F32)clusters.get(i)).fill(0.0f);
        }
        for (int pointIdx = 0; pointIdx < points.size(); ++pointIdx) {
            int clusterIdx;
            float[] point = ((TupleDesc_F32)points.getTemp((int)pointIdx)).data;
            int n = clusterIdx = assignments.get(pointIdx);
            this.counts.data[n] = this.counts.data[n] + 1;
            float[] cluster = ((TupleDesc_F32)clusters.get((int)clusterIdx)).data;
            for (int i = 0; i < point.length; ++i) {
                int n2 = i;
                cluster[n2] = cluster[n2] + point[i];
            }
        }
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            float[] cluster = ((TupleDesc_F32)clusters.get((int)clusterIdx)).data;
            float divisor = this.counts.get(clusterIdx);
            int i = 0;
            while (i < cluster.length) {
                int n = i++;
                cluster[n] = cluster[n] / divisor;
            }
        }
    }

    public ComputeMeanClusters<TupleDesc_F32> newInstanceThread() {
        return new ComputeMeanTuple_F32();
    }
}

