/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.kmeans;

import boofcv.struct.feature.TupleDesc_F64;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.LArrayAccessor;

public class ComputeMeanTuple_F64
implements ComputeMeanClusters<TupleDesc_F64> {
    DogArray_I32 counts = new DogArray_I32();

    public void process(LArrayAccessor<TupleDesc_F64> points, DogArray_I32 assignments, FastAccess<TupleDesc_F64> clusters) {
        int i;
        if (assignments.size != points.size()) {
            throw new IllegalArgumentException("Points and assignments need to be the same size");
        }
        this.counts.resetResize(clusters.size, 0);
        for (int i2 = 0; i2 < clusters.size; ++i2) {
            ((TupleDesc_F64)clusters.get(i2)).fill(0.0);
        }
        for (int pointIdx = 0; pointIdx < points.size(); ++pointIdx) {
            int clusterIdx;
            double[] point = ((TupleDesc_F64)points.getTemp((int)pointIdx)).data;
            int n = clusterIdx = assignments.get(pointIdx);
            this.counts.data[n] = this.counts.data[n] + 1;
            double[] cluster = ((TupleDesc_F64)clusters.get((int)clusterIdx)).data;
            for (i = 0; i < point.length; ++i) {
                int n2 = i;
                cluster[n2] = cluster[n2] + point[i];
            }
        }
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            double[] cluster = ((TupleDesc_F64)clusters.get((int)clusterIdx)).data;
            double divisor = this.counts.get(clusterIdx);
            i = 0;
            while (i < cluster.length) {
                int n = i++;
                cluster[n] = cluster[n] / divisor;
            }
        }
    }

    public ComputeMeanClusters<TupleDesc_F64> newInstanceThread() {
        return new ComputeMeanTuple_F64();
    }
}

