/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.kmeans;

import boofcv.struct.feature.TupleDesc_B;
import java.util.Arrays;
import org.ddogleg.clustering.ComputeMeanClusters;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.LArrayAccessor;

public class ComputeMedianTuple_B
implements ComputeMeanClusters<TupleDesc_B> {
    protected final DogArray_I32 assignmentCounts = new DogArray_I32();
    protected final DogArray<int[]> bitCounts = new DogArray(() -> new int[DOF]);
    protected final int dof;

    public ComputeMedianTuple_B(int DOF) {
        this.dof = DOF;
    }

    public void process(LArrayAccessor<TupleDesc_B> points, DogArray_I32 assignments, FastAccess<TupleDesc_B> clusters) {
        if (assignments.size != points.size()) {
            throw new IllegalArgumentException("Points and assignments need to be the same size");
        }
        this.assignmentCounts.resetResize(clusters.size, 0);
        this.bitCounts.resize(clusters.size);
        for (int i = 0; i < this.bitCounts.size; ++i) {
            Arrays.fill((int[])this.bitCounts.get(i), 0);
        }
        this.countBitsInEachCluster(points, assignments);
        this.countsToBits(clusters);
    }

    protected void countBitsInEachCluster(LArrayAccessor<TupleDesc_B> points, DogArray_I32 assignments) {
        for (int pointIdx = 0; pointIdx < points.size(); ++pointIdx) {
            int clusterIdx;
            int n = clusterIdx = assignments.get(pointIdx);
            this.assignmentCounts.data[n] = this.assignmentCounts.data[n] + 1;
            TupleDesc_B tuple = (TupleDesc_B)points.getTemp(pointIdx);
            int[] bitCount = (int[])this.bitCounts.get(clusterIdx);
            int bit = 0;
            while (bit + 32 < this.dof) {
                int value = tuple.data[bit / 32];
                if ((value & 1) != 0) {
                    int n2 = bit;
                    bitCount[n2] = bitCount[n2] + 1;
                }
                if ((value & 2) != 0) {
                    int n3 = bit + 1;
                    bitCount[n3] = bitCount[n3] + 1;
                }
                if ((value & 4) != 0) {
                    int n4 = bit + 2;
                    bitCount[n4] = bitCount[n4] + 1;
                }
                if ((value & 8) != 0) {
                    int n5 = bit + 3;
                    bitCount[n5] = bitCount[n5] + 1;
                }
                if ((value & 0x10) != 0) {
                    int n6 = bit + 4;
                    bitCount[n6] = bitCount[n6] + 1;
                }
                if ((value & 0x20) != 0) {
                    int n7 = bit + 5;
                    bitCount[n7] = bitCount[n7] + 1;
                }
                if ((value & 0x40) != 0) {
                    int n8 = bit + 6;
                    bitCount[n8] = bitCount[n8] + 1;
                }
                if ((value & 0x80) != 0) {
                    int n9 = bit + 7;
                    bitCount[n9] = bitCount[n9] + 1;
                }
                if ((value & 0x100) != 0) {
                    int n10 = bit + 8;
                    bitCount[n10] = bitCount[n10] + 1;
                }
                if ((value & 0x200) != 0) {
                    int n11 = bit + 9;
                    bitCount[n11] = bitCount[n11] + 1;
                }
                if ((value & 0x400) != 0) {
                    int n12 = bit + 10;
                    bitCount[n12] = bitCount[n12] + 1;
                }
                if ((value & 0x800) != 0) {
                    int n13 = bit + 11;
                    bitCount[n13] = bitCount[n13] + 1;
                }
                if ((value & 0x1000) != 0) {
                    int n14 = bit + 12;
                    bitCount[n14] = bitCount[n14] + 1;
                }
                if ((value & 0x2000) != 0) {
                    int n15 = bit + 13;
                    bitCount[n15] = bitCount[n15] + 1;
                }
                if ((value & 0x4000) != 0) {
                    int n16 = bit + 14;
                    bitCount[n16] = bitCount[n16] + 1;
                }
                if ((value & 0x8000) != 0) {
                    int n17 = bit + 15;
                    bitCount[n17] = bitCount[n17] + 1;
                }
                if ((value & 0x10000) != 0) {
                    int n18 = bit + 16;
                    bitCount[n18] = bitCount[n18] + 1;
                }
                if ((value & 0x20000) != 0) {
                    int n19 = bit + 17;
                    bitCount[n19] = bitCount[n19] + 1;
                }
                if ((value & 0x40000) != 0) {
                    int n20 = bit + 18;
                    bitCount[n20] = bitCount[n20] + 1;
                }
                if ((value & 0x80000) != 0) {
                    int n21 = bit + 19;
                    bitCount[n21] = bitCount[n21] + 1;
                }
                if ((value & 0x100000) != 0) {
                    int n22 = bit + 20;
                    bitCount[n22] = bitCount[n22] + 1;
                }
                if ((value & 0x200000) != 0) {
                    int n23 = bit + 21;
                    bitCount[n23] = bitCount[n23] + 1;
                }
                if ((value & 0x400000) != 0) {
                    int n24 = bit + 22;
                    bitCount[n24] = bitCount[n24] + 1;
                }
                if ((value & 0x800000) != 0) {
                    int n25 = bit + 23;
                    bitCount[n25] = bitCount[n25] + 1;
                }
                if ((value & 0x1000000) != 0) {
                    int n26 = bit + 24;
                    bitCount[n26] = bitCount[n26] + 1;
                }
                if ((value & 0x2000000) != 0) {
                    int n27 = bit + 25;
                    bitCount[n27] = bitCount[n27] + 1;
                }
                if ((value & 0x4000000) != 0) {
                    int n28 = bit + 26;
                    bitCount[n28] = bitCount[n28] + 1;
                }
                if ((value & 0x8000000) != 0) {
                    int n29 = bit + 27;
                    bitCount[n29] = bitCount[n29] + 1;
                }
                if ((value & 0x10000000) != 0) {
                    int n30 = bit + 28;
                    bitCount[n30] = bitCount[n30] + 1;
                }
                if ((value & 0x20000000) != 0) {
                    int n31 = bit + 29;
                    bitCount[n31] = bitCount[n31] + 1;
                }
                if ((value & 0x40000000) != 0) {
                    int n32 = bit + 30;
                    bitCount[n32] = bitCount[n32] + 1;
                }
                if ((value & Integer.MIN_VALUE) != 0) {
                    int n33 = bit + 31;
                    bitCount[n33] = bitCount[n33] + 1;
                }
                bit += 32;
            }
            while (bit < this.dof) {
                if (tuple.isBitTrue(bit)) {
                    int n34 = bit;
                    bitCount[n34] = bitCount[n34] + 1;
                }
                ++bit;
            }
        }
    }

    protected void countsToBits(FastAccess<TupleDesc_B> clusters) {
        for (int clusterIdx = 0; clusterIdx < clusters.size; ++clusterIdx) {
            int[] bitCount = (int[])this.bitCounts.get(clusterIdx);
            int threshold = this.assignmentCounts.get(clusterIdx) / 2;
            TupleDesc_B cluster = (TupleDesc_B)clusters.get(clusterIdx);
            Arrays.fill(cluster.data, 0);
            for (int i = 0; i < this.dof; ++i) {
                cluster.setBit(i, bitCount[i] > threshold);
            }
        }
    }

    public ComputeMeanClusters<TupleDesc_B> newInstanceThread() {
        return new ComputeMedianTuple_B(this.dof);
    }
}

