/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.kmeans;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.kmeans.ComputeMedianTuple_B;
import java.util.Arrays;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.LArrayAccessor;
import pabeles.concurrency.GrowArray;

public class ComputeMedianTuple_MT_B
extends ComputeMedianTuple_B {
    int minimumForConcurrent = 0;
    GrowArray<ThreadData> threadData = new GrowArray(() -> new ThreadData());

    public ComputeMedianTuple_MT_B(int DOF) {
        super(DOF);
    }

    @Override
    protected void countBitsInEachCluster(LArrayAccessor<TupleDesc_B> points, DogArray_I32 assignments) {
        if (points.size() < this.minimumForConcurrent) {
            super.countBitsInEachCluster(points, assignments);
            return;
        }
        int numClusters = this.assignmentCounts.size;
        BoofConcurrency.loopBlocks((int)0, (int)points.size(), this.threadData, (data, idx0, idx1) -> {
            TupleDesc_B tuple = data.point;
            DogArray<int[]> bitCounts = data.bitCounts;
            DogArray_I32 assignmentCounts = data.assignmentCounts;
            assignmentCounts.resetResize(numClusters, 0);
            bitCounts.resize(numClusters);
            for (int i = 0; i < bitCounts.size; ++i) {
                Arrays.fill(((int[][])bitCounts.data)[i], 0);
            }
            for (int pointIdx = idx0; pointIdx < idx1; ++pointIdx) {
                int clusterIdx;
                int n = clusterIdx = assignments.get(pointIdx);
                assignmentCounts.data[n] = assignmentCounts.data[n] + 1;
                points.getCopy(pointIdx, (Object)tuple);
                int[] bitCount = (int[])bitCounts.get(clusterIdx);
                int bit = 0;
                while (bit + 32 < this.dof) {
                    int value = tuple.data[bit / 32];
                    if ((value & 1) != 0) {
                        int n2 = bit;
                        bitCount[n2] = bitCount[n2] + 1;
                    }
                    if ((value & 2) != 0) {
                        int n3 = bit + 1;
                        bitCount[n3] = bitCount[n3] + 1;
                    }
                    if ((value & 4) != 0) {
                        int n4 = bit + 2;
                        bitCount[n4] = bitCount[n4] + 1;
                    }
                    if ((value & 8) != 0) {
                        int n5 = bit + 3;
                        bitCount[n5] = bitCount[n5] + 1;
                    }
                    if ((value & 0x10) != 0) {
                        int n6 = bit + 4;
                        bitCount[n6] = bitCount[n6] + 1;
                    }
                    if ((value & 0x20) != 0) {
                        int n7 = bit + 5;
                        bitCount[n7] = bitCount[n7] + 1;
                    }
                    if ((value & 0x40) != 0) {
                        int n8 = bit + 6;
                        bitCount[n8] = bitCount[n8] + 1;
                    }
                    if ((value & 0x80) != 0) {
                        int n9 = bit + 7;
                        bitCount[n9] = bitCount[n9] + 1;
                    }
                    if ((value & 0x100) != 0) {
                        int n10 = bit + 8;
                        bitCount[n10] = bitCount[n10] + 1;
                    }
                    if ((value & 0x200) != 0) {
                        int n11 = bit + 9;
                        bitCount[n11] = bitCount[n11] + 1;
                    }
                    if ((value & 0x400) != 0) {
                        int n12 = bit + 10;
                        bitCount[n12] = bitCount[n12] + 1;
                    }
                    if ((value & 0x800) != 0) {
                        int n13 = bit + 11;
                        bitCount[n13] = bitCount[n13] + 1;
                    }
                    if ((value & 0x1000) != 0) {
                        int n14 = bit + 12;
                        bitCount[n14] = bitCount[n14] + 1;
                    }
                    if ((value & 0x2000) != 0) {
                        int n15 = bit + 13;
                        bitCount[n15] = bitCount[n15] + 1;
                    }
                    if ((value & 0x4000) != 0) {
                        int n16 = bit + 14;
                        bitCount[n16] = bitCount[n16] + 1;
                    }
                    if ((value & 0x8000) != 0) {
                        int n17 = bit + 15;
                        bitCount[n17] = bitCount[n17] + 1;
                    }
                    if ((value & 0x10000) != 0) {
                        int n18 = bit + 16;
                        bitCount[n18] = bitCount[n18] + 1;
                    }
                    if ((value & 0x20000) != 0) {
                        int n19 = bit + 17;
                        bitCount[n19] = bitCount[n19] + 1;
                    }
                    if ((value & 0x40000) != 0) {
                        int n20 = bit + 18;
                        bitCount[n20] = bitCount[n20] + 1;
                    }
                    if ((value & 0x80000) != 0) {
                        int n21 = bit + 19;
                        bitCount[n21] = bitCount[n21] + 1;
                    }
                    if ((value & 0x100000) != 0) {
                        int n22 = bit + 20;
                        bitCount[n22] = bitCount[n22] + 1;
                    }
                    if ((value & 0x200000) != 0) {
                        int n23 = bit + 21;
                        bitCount[n23] = bitCount[n23] + 1;
                    }
                    if ((value & 0x400000) != 0) {
                        int n24 = bit + 22;
                        bitCount[n24] = bitCount[n24] + 1;
                    }
                    if ((value & 0x800000) != 0) {
                        int n25 = bit + 23;
                        bitCount[n25] = bitCount[n25] + 1;
                    }
                    if ((value & 0x1000000) != 0) {
                        int n26 = bit + 24;
                        bitCount[n26] = bitCount[n26] + 1;
                    }
                    if ((value & 0x2000000) != 0) {
                        int n27 = bit + 25;
                        bitCount[n27] = bitCount[n27] + 1;
                    }
                    if ((value & 0x4000000) != 0) {
                        int n28 = bit + 26;
                        bitCount[n28] = bitCount[n28] + 1;
                    }
                    if ((value & 0x8000000) != 0) {
                        int n29 = bit + 27;
                        bitCount[n29] = bitCount[n29] + 1;
                    }
                    if ((value & 0x10000000) != 0) {
                        int n30 = bit + 28;
                        bitCount[n30] = bitCount[n30] + 1;
                    }
                    if ((value & 0x20000000) != 0) {
                        int n31 = bit + 29;
                        bitCount[n31] = bitCount[n31] + 1;
                    }
                    if ((value & 0x40000000) != 0) {
                        int n32 = bit + 30;
                        bitCount[n32] = bitCount[n32] + 1;
                    }
                    if ((value & Integer.MIN_VALUE) != 0) {
                        int n33 = bit + 31;
                        bitCount[n33] = bitCount[n33] + 1;
                    }
                    bit += 32;
                }
                while (bit < this.dof) {
                    if (tuple.isBitTrue(bit)) {
                        int n34 = bit;
                        bitCount[n34] = bitCount[n34] + 1;
                    }
                    ++bit;
                }
            }
        });
        for (int threadIdx = 0; threadIdx < this.threadData.size(); ++threadIdx) {
            ThreadData data2 = (ThreadData)this.threadData.get(threadIdx);
            for (int clusterIdx = 0; clusterIdx < numClusters; ++clusterIdx) {
                int n = clusterIdx;
                this.assignmentCounts.data[n] = this.assignmentCounts.data[n] + data2.assignmentCounts.data[clusterIdx];
                int[] allCounts = (int[])this.bitCounts.get(clusterIdx);
                int[] threadCounts = (int[])data2.bitCounts.get(clusterIdx);
                for (int bitIdx = 0; bitIdx < this.dof; ++bitIdx) {
                    int n2 = bitIdx;
                    allCounts[n2] = allCounts[n2] + threadCounts[bitIdx];
                }
            }
        }
    }

    public int getMinimumForConcurrent() {
        return this.minimumForConcurrent;
    }

    public void setMinimumForConcurrent(int minimumForConcurrent) {
        this.minimumForConcurrent = minimumForConcurrent;
    }

    class ThreadData {
        DogArray<int[]> bitCounts = new DogArray(() -> new int[ComputeMedianTuple_MT_B.this.dof]);
        TupleDesc_B point;
        DogArray_I32 assignmentCounts;

        ThreadData() {
            this.point = new TupleDesc_B(ComputeMedianTuple_MT_B.this.dof);
            this.assignmentCounts = new DogArray_I32();
        }
    }
}

