/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialStability;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class FourPointSyntheticStability {
    List<Point2D3D> points2D3D = new ArrayList<Point2D3D>();
    List<Point2D_F64> refPixels = new ArrayList<Point2D_F64>();
    List<Point2D_F64> refNorm = new ArrayList<Point2D_F64>();
    protected Point2Transform2_F64 pixelToNorm;
    protected Point2Transform2_F64 normToPixel;
    private Estimate1ofPnP estimatePnP = FactoryMultiView.pnp_1((EnumPNP)EnumPNP.IPPE, (int)-1, (int)-1);
    Se3_F64 referenceCameraToTarget = new Se3_F64();
    Se3_F64 targetToCameraSample = new Se3_F64();
    Se3_F64 difference = new Se3_F64();
    Rodrigues_F64 rodrigues = new Rodrigues_F64();
    double maxOrientation = 0.0;
    double maxLocation = 0.0;

    public FourPointSyntheticStability() {
        for (int i = 0; i < 4; ++i) {
            this.points2D3D.add(new Point2D3D());
            this.refPixels.add(new Point2D_F64());
            this.refNorm.add(new Point2D_F64());
        }
    }

    public void setTransforms(Point2Transform2_F64 pixelToNorm, Point2Transform2_F64 normToPixel) {
        this.pixelToNorm = pixelToNorm;
        this.normToPixel = normToPixel;
    }

    public void setShape(double width, double height) {
        this.points2D3D.get((int)0).location.setTo(-width / 2.0, -height / 2.0, 0.0);
        this.points2D3D.get((int)1).location.setTo(-width / 2.0, height / 2.0, 0.0);
        this.points2D3D.get((int)2).location.setTo(width / 2.0, height / 2.0, 0.0);
        this.points2D3D.get((int)3).location.setTo(width / 2.0, -height / 2.0, 0.0);
    }

    public void computeStability(Se3_F64 targetToCamera, double disturbance, FiducialStability results) {
        int i;
        targetToCamera.invert(this.referenceCameraToTarget);
        this.maxOrientation = 0.0;
        this.maxLocation = 0.0;
        Point3D_F64 cameraPt = new Point3D_F64();
        for (i = 0; i < this.points2D3D.size(); ++i) {
            Point2D3D p23 = this.points2D3D.get(i);
            targetToCamera.transform(p23.location, cameraPt);
            p23.observation.x = cameraPt.x / cameraPt.z;
            p23.observation.y = cameraPt.y / cameraPt.z;
            this.refNorm.get(i).setTo((GeoTuple2D_F64)p23.observation);
            this.normToPixel.compute(p23.observation.x, p23.observation.y, this.refPixels.get(i));
        }
        for (i = 0; i < this.points2D3D.size(); ++i) {
            this.perturb(disturbance, this.refPixels.get(i), this.points2D3D.get(i));
            this.points2D3D.get((int)i).observation.setTo((GeoTuple2D_F64)this.refNorm.get(i));
        }
        results.location = this.maxLocation;
        results.orientation = this.maxOrientation;
    }

    private void perturb(double disturbance, Point2D_F64 pixel, Point2D3D p23) {
        double y = pixel.y;
        double x = pixel.x + disturbance;
        this.computeDisturbance(x, y, p23);
        x = pixel.x - disturbance;
        this.computeDisturbance(x, y, p23);
        x = pixel.x;
        y = pixel.y + disturbance;
        this.computeDisturbance(x, y, p23);
        y = pixel.y - disturbance;
        this.computeDisturbance(x, y, p23);
    }

    private void computeDisturbance(double x, double y, Point2D3D p23) {
        this.pixelToNorm.compute(x, y, p23.observation);
        if (this.estimatePnP.process(this.points2D3D, (Object)this.targetToCameraSample)) {
            this.referenceCameraToTarget.concat(this.targetToCameraSample, this.difference);
            double d = this.difference.getT().norm();
            ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)this.difference.getR(), (Rodrigues_F64)this.rodrigues);
            double theta = Math.abs(this.rodrigues.theta);
            if (theta > this.maxOrientation) {
                this.maxOrientation = theta;
            }
            if (d > this.maxLocation) {
                this.maxLocation = d;
            }
        }
    }
}

