/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.dots;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.RefineEpipolar;
import boofcv.alg.feature.describe.llah.LlahDocument;
import boofcv.alg.feature.describe.llah.LlahOperations;
import boofcv.factory.geo.EpipolarError;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.GeoTuple;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.homography.UtilHomography_F64;
import georegression.struct.point.Point2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class UchiyaMarkerTracker
implements VerbosePrint {
    LlahOperations llahOps;
    int minLandmarkDoc = 8;
    int minDotHits = 5;
    boolean tracking = true;
    @Nullable
    private PrintStream verbose = null;
    List<LlahOperations.FoundDocument> foundDocs = new ArrayList<LlahOperations.FoundDocument>();
    DogArray<Track> currentTracks = new DogArray(Track::new, Track::reset);
    TIntObjectHashMap<Track> globalId_to_track = new TIntObjectHashMap();
    TIntIntHashMap trackId_to_globalId = new TIntIntHashMap();
    LlahOperations llahTrackingOps;
    double timeTrack;
    double timeDetect;
    double timeUpdate;
    Ransac<Homography2D_F64, AssociatedPair> ransac;
    Estimate1ofEpipolar estimateHomography = FactoryMultiView.homographyTLS();
    RefineEpipolar refineHomography = FactoryMultiView.homographyRefine((double)0.01, (int)50, (EpipolarError)EpipolarError.SAMPSON);
    DMatrixRMaj foundH = new DMatrixRMaj(3, 3);
    DMatrixRMaj refinedH = new DMatrixRMaj(3, 3);
    DogArray<AssociatedPair> ransacPairs = new DogArray(AssociatedPair::new);
    List<AssociatedPair> inlierPairs = new ArrayList<AssociatedPair>();
    DogArray_I32 ransacDotIdx = new DogArray_I32();

    public UchiyaMarkerTracker(LlahOperations llahOps, Ransac<Homography2D_F64, AssociatedPair> ransac) {
        this.llahOps = llahOps;
        this.ransac = ransac;
        this.llahTrackingOps = new LlahOperations(llahOps.getNumberOfNeighborsN(), llahOps.getSizeOfCombinationM(), llahOps.getHasher());
    }

    public void resetTracking() {
        this.llahTrackingOps.clearDocuments();
        this.trackId_to_globalId.clear();
        this.globalId_to_track.clear();
        this.ransac.reset();
    }

    public void process(List<Point2D_F64> detectedDots) {
        this.currentTracks.reset();
        this.globalId_to_track.clear();
        double nano0 = System.nanoTime();
        this.performTracking(detectedDots);
        double nano1 = System.nanoTime();
        this.performDetection(detectedDots);
        double nano2 = System.nanoTime();
        this.setTrackDescriptionsAndID();
        double nano3 = System.nanoTime();
        this.timeTrack = (nano1 - nano0) * 1.0E-6;
        this.timeDetect = (nano2 - nano1) * 1.0E-6;
        this.timeUpdate = (nano3 - nano2) * 1.0E-6;
    }

    void performTracking(List<Point2D_F64> detectedDots) {
        this.llahTrackingOps.lookupDocuments(detectedDots, this.minLandmarkDoc, this.foundDocs);
        for (int i = 0; i < this.foundDocs.size(); ++i) {
            Track track;
            LlahOperations.FoundDocument foundTrackDoc = this.foundDocs.get(i);
            if (this.fitHomographAndPredict(detectedDots, foundTrackDoc, track = (Track)this.currentTracks.grow())) {
                int globalID = this.trackId_to_globalId.get(foundTrackDoc.document.documentID);
                track.globalDoc = (LlahDocument)this.llahOps.getDocuments().get(globalID);
                this.globalId_to_track.put(globalID, (Object)track);
                if (this.verbose == null) continue;
                this.verbose.println(" tracked doc " + globalID);
                continue;
            }
            if (this.verbose != null) {
                this.verbose.println(" failed to fit homography while tracking");
            }
            this.currentTracks.removeTail();
        }
    }

    void performDetection(List<Point2D_F64> detectedDots) {
        this.llahOps.lookupDocuments(detectedDots, this.minLandmarkDoc, this.foundDocs);
        for (int i = 0; i < this.foundDocs.size(); ++i) {
            LlahOperations.FoundDocument foundDoc = this.foundDocs.get(i);
            if (this.globalId_to_track.containsKey(foundDoc.document.documentID)) continue;
            Track track = (Track)this.currentTracks.grow();
            track.globalDoc = foundDoc.document;
            if (this.fitHomographAndPredict(detectedDots, foundDoc, track)) {
                this.globalId_to_track.put(track.globalDoc.documentID, (Object)track);
                if (this.verbose == null) continue;
                this.verbose.println(" detected doc " + track.globalDoc.documentID);
                continue;
            }
            this.currentTracks.removeTail();
        }
    }

    private void setTrackDescriptionsAndID() {
        this.llahTrackingOps.clearDocuments();
        this.trackId_to_globalId.clear();
        this.globalId_to_track.forEachEntry((globalID, track) -> {
            track.trackDoc = this.llahTrackingOps.createDocument(track.predicted.toList());
            track.trackDoc.landmarks.reset();
            track.trackDoc.landmarks.copyAll(track.globalDoc.landmarks.toList(), (src, dst) -> dst.setTo((GeoTuple2D_F64)src));
            this.trackId_to_globalId.put(track.trackDoc.documentID, globalID);
            return true;
        });
    }

    private boolean fitHomographAndPredict(List<Point2D_F64> detectedDots, LlahOperations.FoundDocument doc, Track track) {
        if (!this.fitHomography(detectedDots, doc)) {
            return false;
        }
        this.inlierPairs.clear();
        int N = this.ransac.getMatchSet().size();
        for (int i = 0; i < N; ++i) {
            int inputIdx = this.ransac.getInputIndex(i);
            int dotIdx = this.ransacDotIdx.get(inputIdx);
            int landmarkIdx = doc.landmarkToDots.indexOf(dotIdx);
            ((PointIndex2D_F64)track.observed.grow()).setTo((GeoTuple)detectedDots.get(dotIdx), landmarkIdx);
            this.inlierPairs.add((AssociatedPair)this.ransacPairs.get(inputIdx));
        }
        this.estimateHomography.process(this.inlierPairs, (Object)this.foundH);
        this.refineHomography.fitModel(this.inlierPairs, (Object)this.foundH, (Object)this.refinedH);
        UtilHomography_F64.convert((DMatrixRMaj)this.refinedH, (Homography2D_F64)track.doc_to_imagePixel);
        track.predicted.resize(doc.document.landmarks.size);
        for (int landmarkIdx = 0; landmarkIdx < doc.document.landmarks.size; ++landmarkIdx) {
            Point2D_F64 predictedPixel = (Point2D_F64)track.predicted.get(landmarkIdx);
            HomographyPointOps_F64.transform((Homography2D_F64)track.doc_to_imagePixel, (Point2D_F64)((Point2D_F64)doc.document.landmarks.get(landmarkIdx)), (Point2D_F64)predictedPixel);
        }
        return true;
    }

    boolean fitHomography(List<Point2D_F64> dots, LlahOperations.FoundDocument observed) {
        this.ransacPairs.reset();
        this.ransacDotIdx.reset();
        for (int landmarkIdx = 0; landmarkIdx < observed.document.landmarks.size; ++landmarkIdx) {
            Point2D_F64 landmark = (Point2D_F64)observed.document.landmarks.get(landmarkIdx);
            int dotIdx = observed.landmarkToDots.get(landmarkIdx);
            if (dotIdx < 0) continue;
            this.ransacDotIdx.add(dotIdx);
            ((AssociatedPair)this.ransacPairs.grow()).setTo(landmark, dots.get(dotIdx));
        }
        if (this.ransacPairs.size < this.ransac.getMinimumSize()) {
            return false;
        }
        if (this.ransac.process(this.ransacPairs.toList())) {
            return this.ransac.getMatchSet().size() >= this.minLandmarkDoc;
        }
        return false;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }

    public LlahOperations getLlahOps() {
        return this.llahOps;
    }

    public void setLlahOps(LlahOperations llahOps) {
        this.llahOps = llahOps;
    }

    public int getMinLandmarkDoc() {
        return this.minLandmarkDoc;
    }

    public void setMinLandmarkDoc(int minLandmarkDoc) {
        this.minLandmarkDoc = minLandmarkDoc;
    }

    public int getMinDotHits() {
        return this.minDotHits;
    }

    public void setMinDotHits(int minDotHits) {
        this.minDotHits = minDotHits;
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public void setTracking(boolean tracking) {
        this.tracking = tracking;
    }

    public DogArray<Track> getCurrentTracks() {
        return this.currentTracks;
    }

    public double getTimeTrack() {
        return this.timeTrack;
    }

    public double getTimeDetect() {
        return this.timeDetect;
    }

    public double getTimeUpdate() {
        return this.timeUpdate;
    }

    public static class Track {
        public LlahDocument trackDoc;
        public LlahDocument globalDoc;
        public final Homography2D_F64 doc_to_imagePixel = new Homography2D_F64();
        public final DogArray<Point2D_F64> predicted = new DogArray(Point2D_F64::new);
        public final DogArray<PointIndex2D_F64> observed = new DogArray(PointIndex2D_F64::new);

        public void reset() {
            this.trackDoc = null;
            this.globalDoc = null;
            this.predicted.reset();
            this.observed.reset();
            this.doc_to_imagePixel.reset();
        }
    }
}

