/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.alg.fiducial.qrcode.PackedBits32;
import boofcv.factory.fiducial.HammingDictionary;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ddogleg.struct.FastArray;

public class ConfigHammingMarker
implements Configuration {
    public double borderWidthFraction = 0.25;
    public int gridWidth = -1;
    public int minimumHamming;
    public FastArray<Marker> encoding = new FastArray(Marker.class);
    public HammingDictionary dictionary;
    public double targetWidth = 1.0;

    public void checkValidity() {
        BoofMiscOps.checkTrue((this.borderWidthFraction > 0.0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.gridWidth > 0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.minimumHamming >= 0 ? 1 : 0) != 0);
        BoofMiscOps.checkTrue((this.targetWidth > 0.0 ? 1 : 0) != 0);
        for (int i = 0; i < this.encoding.size(); ++i) {
            ((Marker)this.encoding.get(i)).checkValidity();
        }
    }

    public void serializeInitialize() {
        if (this.dictionary == HammingDictionary.CUSTOM) {
            return;
        }
        this.encoding = ConfigHammingMarker.loadDictionary((HammingDictionary)this.dictionary).encoding;
    }

    public List<String> serializeActiveFields() {
        ArrayList<String> active = new ArrayList<String>();
        active.add("borderWidthFraction");
        active.add("gridWidth");
        active.add("minimumHamming");
        active.add("dictionary");
        if (this.dictionary == HammingDictionary.CUSTOM) {
            active.add("encoding");
        }
        return active;
    }

    public ConfigHammingMarker setTo(ConfigHammingMarker src) {
        this.borderWidthFraction = src.borderWidthFraction;
        this.gridWidth = src.gridWidth;
        this.minimumHamming = src.minimumHamming;
        this.dictionary = src.dictionary;
        this.targetWidth = src.targetWidth;
        this.encoding.clear();
        this.encoding.addAll(src.encoding);
        return this;
    }

    public int bitsPerGrid() {
        return this.gridWidth * this.gridWidth;
    }

    public void addMarker(long encoding) {
        Marker m = new Marker();
        this.encoding.add((Object)m);
        m.pattern.resize(this.gridWidth * this.gridWidth);
        for (int bit = 0; bit < m.pattern.size; ++bit) {
            m.pattern.set(bit, (int)(encoding >> bit & 1L));
        }
    }

    public static ConfigHammingMarker decodeDictionaryString(String text) {
        ConfigHammingMarker config = new ConfigHammingMarker();
        String[] lines = text.split("\n");
        block10: for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.isEmpty() || line.charAt(0) == '#') continue;
            String[] words = line.split("=");
            if (words.length != 2) {
                throw new RuntimeException("Expected 2 words on line " + i);
            }
            switch (words[0]) {
                case "grid_width": {
                    config.gridWidth = Integer.parseInt(words[1]);
                    continue block10;
                }
                case "minimum_hamming": {
                    config.minimumHamming = Integer.parseInt(words[1]);
                    continue block10;
                }
                case "dictionary": {
                    String[] ids = words[1].split(",");
                    for (int idIdx = 0; idIdx < ids.length; ++idIdx) {
                        if (ids[idIdx].startsWith("0x")) {
                            config.addMarker(Long.parseUnsignedLong(ids[idIdx].substring(2), 16));
                            continue;
                        }
                        config.addMarker(Long.parseUnsignedLong(ids[idIdx]));
                    }
                    continue block10;
                }
                default: {
                    throw new RuntimeException("Unknown key='" + words[0] + "'");
                }
            }
        }
        config.borderWidthFraction = 1.0 / ((double)config.gridWidth + 2.0);
        return config;
    }

    public static ConfigHammingMarker loadPredefined(String name) {
        ConfigHammingMarker configHammingMarker;
        block8: {
            URL path = Objects.requireNonNull(ConfigHammingMarker.class.getResource(name + ".txt"));
            InputStream stream = path.openStream();
            try {
                String text = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                configHammingMarker = ConfigHammingMarker.decodeDictionaryString(text);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return configHammingMarker;
    }

    public static ConfigHammingMarker loadDictionary(HammingDictionary dictionary) {
        ConfigHammingMarker configHammingMarker;
        switch (dictionary) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case CUSTOM: {
                throw new IllegalArgumentException("Need to manually specify a custom dictionary");
            }
            case ARUCO_ORIGINAL: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("aruco_original");
                break;
            }
            case ARUCO_MIP_16h3: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("aruco_mip_16h3");
                break;
            }
            case ARUCO_MIP_25h7: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("aruco_mip_25h7");
                break;
            }
            case ARUCO_MIP_36h12: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("aruco_mip_36h12");
                break;
            }
            case ARUCO_OCV_4x4_1000: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("aruco_ocv_4x4_1000");
                break;
            }
            case ARUCO_OCV_5x5_1000: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("aruco_ocv_5x5_1000");
                break;
            }
            case ARUCO_OCV_6x6_1000: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("aruco_ocv_6x6_1000");
                break;
            }
            case ARUCO_OCV_7x7_1000: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("aruco_ocv_7x7_1000");
                break;
            }
            case APRILTAG_16h5: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("apriltag_16h5");
                break;
            }
            case APRILTAG_25h7: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("apriltag_25h7");
                break;
            }
            case APRILTAG_25h9: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("apriltag_25h9");
                break;
            }
            case APRILTAG_36h10: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("apriltag_36h10");
                break;
            }
            case APRILTAG_36h11: {
                configHammingMarker = ConfigHammingMarker.loadPredefined("apriltag_36h11");
            }
        }
        ConfigHammingMarker config = configHammingMarker;
        config.dictionary = dictionary;
        return config;
    }

    public static class Marker {
        public final PackedBits32 pattern = new PackedBits32();

        public void checkValidity() {
            BoofMiscOps.checkTrue((this.pattern.size > 0 ? 1 : 0) != 0);
        }

        public void setTo(Marker src) {
            this.pattern.setTo(src.pattern);
        }
    }
}

