/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.misc.BoofMiscOps;
import boofcv.struct.Configuration;
import boofcv.struct.GridShape;
import java.util.List;
import org.ddogleg.struct.FastArray;

public class ConfigECoCheckMarkers
implements Configuration {
    public static final int DEFAULT_CHECKSUM = 6;
    public static final int DEFAULT_ECC = 3;
    public double dataBitWidthFraction = 0.7;
    public double dataBorderFraction = 0.15;
    public int firstTargetDuplicated = 1;
    public final FastArray<MarkerShape> markerShapes = new FastArray(MarkerShape.class);
    public int errorCorrectionLevel = 3;
    public int checksumBits = 6;

    public static ConfigECoCheckMarkers singleShape(int rows, int cols, int numMarkers, double squareSize) {
        ConfigECoCheckMarkers config = new ConfigECoCheckMarkers();
        config.firstTargetDuplicated = numMarkers;
        config.markerShapes.add((Object)new MarkerShape(rows, cols, squareSize));
        return config;
    }

    public static ConfigECoCheckMarkers parse(String description, double squareSize) {
        int locN = -1;
        int locE = -1;
        int locC = -1;
        block5: for (int i = 0; i < description.length(); ++i) {
            switch (description.charAt(i)) {
                case 'n': {
                    locN = i;
                    continue block5;
                }
                case 'e': {
                    locE = i;
                    continue block5;
                }
                case 'c': {
                    locC = i;
                }
            }
        }
        String[] shape = description.substring(0, locN).split("x");
        int rows = Integer.parseInt(shape[0]);
        int cols = Integer.parseInt(shape[1]);
        int numMarkers = locE == -1 ? Integer.parseInt(description.substring(locN + 1)) : Integer.parseInt(description.substring(locN + 1, locE));
        ConfigECoCheckMarkers config = ConfigECoCheckMarkers.singleShape(rows, cols, numMarkers, squareSize);
        if (locE != -1) {
            config.errorCorrectionLevel = locC == -1 ? Integer.parseInt(description.substring(locE + 1)) : Integer.parseInt(description.substring(locE + 1, locC));
        }
        if (locC != -1) {
            config.checksumBits = Integer.parseInt(description.substring(locC + 1));
        }
        return config;
    }

    public void convertToGridList(List<GridShape> markers) {
        int i;
        markers.clear();
        MarkerShape first = (MarkerShape)this.markerShapes.get(0);
        for (i = 0; i < this.firstTargetDuplicated; ++i) {
            markers.add(new GridShape(first.numRows, first.numCols));
        }
        for (i = 1; i < this.markerShapes.size(); ++i) {
            MarkerShape s = (MarkerShape)this.markerShapes.get(i);
            markers.add(new GridShape(s.numRows, s.numCols));
        }
    }

    public ConfigECoCheckMarkers setTo(ConfigECoCheckMarkers src) {
        this.dataBitWidthFraction = src.dataBitWidthFraction;
        this.dataBorderFraction = src.dataBorderFraction;
        this.firstTargetDuplicated = src.firstTargetDuplicated;
        this.errorCorrectionLevel = src.errorCorrectionLevel;
        this.checksumBits = src.checksumBits;
        this.markerShapes.clear();
        for (int i = 0; i < src.markerShapes.size(); ++i) {
            MarkerShape s = new MarkerShape();
            s.setTo((MarkerShape)src.markerShapes.get(i));
            this.markerShapes.add((Object)s);
        }
        return this;
    }

    public String compactName() {
        BoofMiscOps.checkEq((int)1, (int)this.markerShapes.size(), (String)"Only one unique shape allowed");
        MarkerShape shape = (MarkerShape)this.markerShapes.get(0);
        String text = String.format("%dx%dn%de%dc%d", shape.numRows, shape.numCols, this.firstTargetDuplicated, this.errorCorrectionLevel, this.checksumBits);
        if (this.checksumBits == 6) {
            text = text.substring(0, text.length() - 2);
            if (this.errorCorrectionLevel == 3) {
                text = text.substring(0, text.length() - 2);
            }
        }
        return text;
    }

    public void checkValidity() {
        BoofMiscOps.checkFraction((double)this.dataBitWidthFraction, (String)"dataBitWidthFraction must be 0 to 1.0.");
        BoofMiscOps.checkFraction((double)this.dataBorderFraction, (String)"dataBorderFraction must be 0 to 1.0.");
        BoofMiscOps.checkTrue((this.firstTargetDuplicated >= 1 ? 1 : 0) != 0, (String)"firstTargetDuplicated <= 0");
        BoofMiscOps.checkTrue((this.markerShapes.size() >= 1 ? 1 : 0) != 0, (String)"Shapes not defined");
        BoofMiscOps.checkTrue((this.errorCorrectionLevel >= 0 && this.errorCorrectionLevel <= 9 ? 1 : 0) != 0, (String)"error correction must be from 0 to 9, inclusive.");
        BoofMiscOps.checkTrue((this.checksumBits >= 0 && this.checksumBits <= 8 ? 1 : 0) != 0, (String)"checksum bits must be from 0 to 8, inclusive.");
    }

    public static class MarkerShape
    implements Configuration {
        public int numRows = -1;
        public int numCols = -1;
        public double squareSize;

        public MarkerShape(int numRows, int numCols, double squareSize) {
            this.numRows = numRows;
            this.numCols = numCols;
            this.squareSize = squareSize;
        }

        public MarkerShape() {
        }

        public int getNumCorners() {
            return (this.numCols - 1) * (this.numRows - 1);
        }

        public double getWidth() {
            return (double)(this.numCols - 1) * this.squareSize;
        }

        public double getHeight() {
            return (double)(this.numRows - 1) * this.squareSize;
        }

        public void setTo(MarkerShape src) {
            this.numRows = src.numRows;
            this.numCols = src.numCols;
            this.squareSize = src.squareSize;
        }

        public void checkValidity() {
            BoofMiscOps.checkTrue((this.numRows >= 0 ? 1 : 0) != 0);
            BoofMiscOps.checkTrue((this.numCols >= 0 ? 1 : 0) != 0);
            BoofMiscOps.checkTrue((this.squareSize > 0.0 ? 1 : 0) != 0);
        }
    }
}

