/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.ecocheck;

import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.struct.geo.PointIndex;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.GeoTuple;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;

public class ECoCheckFound {
    public int markerID;
    public int squareRows;
    public int squareCols;
    public final DogArray<PointIndex2D_F64> corners = new DogArray(PointIndex2D_F64::new, c -> c.setTo(-1.0, -1.0, -1));
    public final DogArray<ChessboardCorner> metadata = new DogArray(ChessboardCorner::new);
    public final DogArray_B touchBinary = new DogArray_B();
    public DogArray_I32 decodedCells = new DogArray_I32();

    public ECoCheckFound(ECoCheckFound src) {
        this.setTo(src);
    }

    public ECoCheckFound() {
    }

    public void addCorner(ChessboardCorner corner, int cornerID) {
        ((PointIndex2D_F64)this.corners.grow()).setTo((GeoTuple)corner, cornerID);
        ((ChessboardCorner)this.metadata.grow()).setTo(corner);
    }

    public void reset() {
        this.markerID = -1;
        this.squareCols = -1;
        this.squareRows = -1;
        this.corners.reset();
        this.touchBinary.reset();
        this.decodedCells.reset();
        this.metadata.reset();
    }

    public void setTo(ECoCheckFound src) {
        int i;
        this.markerID = src.markerID;
        this.squareCols = src.squareCols;
        this.squareRows = src.squareRows;
        this.corners.resize(src.corners.size);
        for (i = 0; i < src.corners.size; ++i) {
            ((PointIndex2D_F64)this.corners.get(i)).setTo((PointIndex)((PointIndex2D_F64)src.corners.get(i)));
        }
        this.touchBinary.setTo(src.touchBinary);
        this.decodedCells.setTo(src.decodedCells);
        this.metadata.reset().resize(src.metadata.size);
        for (i = 0; i < src.metadata.size; ++i) {
            ((ChessboardCorner)this.metadata.get(i)).setTo((ChessboardCorner)src.metadata.get(i));
        }
    }
}

