/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeBinaryGridReader;
import boofcv.struct.image.ImageGray;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class QrCodeAlignmentPatternLocator<T extends ImageGray<T>> {
    private final FastArray<QrCode.Alignment> lookup = new FastArray(QrCode.Alignment.class);
    QrCodeBinaryGridReader<T> reader;
    float[] arrayX = new float[12];
    float[] arrayY = new float[12];
    QrCode qr;
    float threshold;
    float[] samples = new float[9];

    public QrCodeAlignmentPatternLocator(Class<T> imageType) {
        this.reader = new QrCodeBinaryGridReader<T>(imageType);
    }

    public boolean process(T image, QrCode qr) {
        this.qr = qr;
        qr.alignment.reset();
        this.reader.setImage(image);
        this.reader.setMarker(qr);
        this.threshold = (float)qr.threshCorner;
        this.initializePatterns(qr);
        if (qr.version <= 1) {
            return true;
        }
        return this.localizePositionPatterns(QrCode.VERSION_INFO[qr.version].alignment);
    }

    public void setLensDistortion(int width, int height, @Nullable LensDistortionNarrowFOV model) {
        this.reader.setLensDistortion(width, height, model);
    }

    void initializePatterns(QrCode qr) {
        int[] where = QrCode.VERSION_INFO[qr.version].alignment;
        qr.alignment.reset();
        this.lookup.reset();
        for (int row = 0; row < where.length; ++row) {
            for (int col = 0; col < where.length; ++col) {
                boolean skip = false;
                if (row == 0 && col == 0) {
                    skip = true;
                } else if (row == 0 && col == where.length - 1) {
                    skip = true;
                } else if (row == where.length - 1 && col == 0) {
                    skip = true;
                }
                if (skip) {
                    this.lookup.add(null);
                    continue;
                }
                QrCode.Alignment a = (QrCode.Alignment)qr.alignment.grow();
                a.moduleX = where[col];
                a.moduleY = where[row];
                this.lookup.add((Object)a);
            }
        }
    }

    boolean localizePositionPatterns(int[] alignmentLocations) {
        int size = alignmentLocations.length;
        for (int row = 0; row < size; ++row) {
            for (int col = 0; col < size; ++col) {
                QrCode.Alignment p;
                QrCode.Alignment a = (QrCode.Alignment)this.lookup.get(row * size + col);
                if (a == null) continue;
                double adjY = 0.0;
                double adjX = 0.0;
                if (row > 0 && (p = (QrCode.Alignment)this.lookup.get((row - 1) * size + col)) != null) {
                    adjY = (double)p.moduleY + 0.5 - p.moduleFound.y;
                }
                if (col > 0 && (p = (QrCode.Alignment)this.lookup.get(row * size + col - 1)) != null) {
                    adjX = (double)p.moduleX + 0.5 - p.moduleFound.x;
                }
                if (!this.centerOnSquare(a, (float)((double)a.moduleY + 0.5 + adjY), (float)((double)a.moduleX + 0.5 + adjX))) {
                    return false;
                }
                if (this.meanshift(a, (float)a.moduleFound.y, (float)a.moduleFound.x)) continue;
                return false;
            }
        }
        return true;
    }

    boolean centerOnSquare(QrCode.Alignment pattern, float guessY, float guessX) {
        float step = 1.0f;
        float bestMag = Float.MAX_VALUE;
        float bestX = guessX;
        float bestY = guessY;
        for (int i = 0; i < 10; ++i) {
            for (int row = 0; row < 3; ++row) {
                float gridy = guessY - 1.0f + (float)row;
                for (int col = 0; col < 3; ++col) {
                    float gridx = guessX - 1.0f + (float)col;
                    this.samples[row * 3 + col] = this.reader.read(gridy, gridx);
                }
            }
            float dx = this.samples[2] + this.samples[5] + this.samples[8] - (this.samples[0] + this.samples[3] + this.samples[6]);
            float dy = this.samples[6] + this.samples[7] + this.samples[8] - (this.samples[0] + this.samples[1] + this.samples[2]);
            float r = (float)Math.sqrt(dx * dx + dy * dy);
            if (bestMag > r) {
                bestMag = r;
                bestX = guessX;
                bestY = guessY;
            } else {
                step *= 0.75f;
            }
            if (!(r > 0.0f)) break;
            guessX = bestX + step * dx / r;
            guessY = bestY + step * dy / r;
        }
        pattern.moduleFound.x = bestX;
        pattern.moduleFound.y = bestY;
        this.reader.gridToImage((double)((float)pattern.moduleFound.y), (double)((float)pattern.moduleFound.x), pattern.pixel);
        return true;
    }

    boolean localize(QrCode.Alignment pattern, float guessY, float guessX) {
        for (int i = 0; i < this.arrayY.length; ++i) {
            float x = guessX - 1.5f + (float)i * 3.0f / 12.0f;
            float y = guessY - 1.5f + (float)i * 3.0f / 12.0f;
            this.arrayX[i] = this.reader.read(guessY, x);
            this.arrayY[i] = this.reader.read(y, guessX);
        }
        int downX = QrCodeAlignmentPatternLocator.greatestDown(this.arrayX);
        if (downX == -1) {
            return false;
        }
        int upX = QrCodeAlignmentPatternLocator.greatestUp(this.arrayX, downX);
        if (upX == -1) {
            return false;
        }
        int downY = QrCodeAlignmentPatternLocator.greatestDown(this.arrayY);
        if (downY == -1) {
            return false;
        }
        int upY = QrCodeAlignmentPatternLocator.greatestUp(this.arrayY, downY);
        if (upY == -1) {
            return false;
        }
        pattern.moduleFound.x = guessX - 1.5f + (float)(downX + upX) * 3.0f / 24.0f;
        pattern.moduleFound.y = guessY - 1.5f + (float)(downY + upY) * 3.0f / 24.0f;
        this.reader.gridToImage((double)((float)pattern.moduleFound.y), (double)((float)pattern.moduleFound.x), pattern.pixel);
        return true;
    }

    boolean meanshift(QrCode.Alignment pattern, float guessY, float guessX) {
        float step = 1.0f;
        float decay = 0.7f;
        for (int i = 0; i < 10; ++i) {
            float sumX = 0.0f;
            float sumY = 0.0f;
            float total = 0.0f;
            for (int y = 0; y < 8; ++y) {
                float dy = -1.5f + 3.0f * (float)y / 7.0f;
                float gridY = guessY + dy;
                for (int x = 0; x < 8; ++x) {
                    float dx = -1.5f + 3.0f * (float)x / 7.0f;
                    float gridX = guessX + dx;
                    float v = this.reader.read(gridY, gridX);
                    float r = (float)Math.sqrt(dx * dx + dy * dy);
                    float w = Math.max(-10.0f, (double)r > 0.5 ? v - this.threshold : this.threshold - v);
                    total += Math.abs(w);
                    sumX += w * dx;
                    sumY += w * dy;
                }
            }
            guessX += step * sumX / total;
            guessY += step * sumY / total;
            step *= decay;
        }
        pattern.moduleFound.x = guessX;
        pattern.moduleFound.y = guessY;
        this.reader.gridToImage((double)((float)pattern.moduleFound.y), (double)((float)pattern.moduleFound.x), pattern.pixel);
        return true;
    }

    static int greatestDown(float[] array) {
        int best = -1;
        float bestScore = 0.0f;
        for (int i = 5; i < array.length; ++i) {
            float diff = 2.0f * (array[i - 5] + array[i]);
            if (!((diff -= array[i - 4] + array[i - 3] + array[i - 2] + array[i - 1]) > bestScore)) continue;
            bestScore = diff;
            best = i - 4;
        }
        return best;
    }

    static int greatestUp(float[] array, int start) {
        int best = -1;
        float bestScore = 0.0f;
        for (int i = start; i < array.length; ++i) {
            float diff = array[i] - array[i - 1];
            if (!(diff > bestScore)) continue;
            bestScore = diff;
            best = i - 1;
        }
        return best;
    }
}

