/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.fiducial.calib.ConfigChessboardBinary;
import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.geo.calibration.DetectSingleFiducialCalibration;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.calib.chess.DetectChessboardBinaryPattern;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CalibrationDetectorChessboardBinary
implements DetectSingleFiducialCalibration {
    DetectChessboardBinaryPattern<GrayF32> alg;
    List<Point2D_F64> layoutPoints;
    CalibrationObservation detected;

    public CalibrationDetectorChessboardBinary(ConfigChessboardBinary configDet, ConfigGridDimen configGrid) {
        DetectPolygonBinaryGrayRefine detectorSquare = FactoryShapeDetector.polygon((ConfigPolygonDetector)configDet.square, GrayF32.class);
        InputToBinary inputToBinary = FactoryThresholdBinary.threshold((ConfigThreshold)configDet.thresholding, GrayF32.class);
        this.alg = new DetectChessboardBinaryPattern(configGrid.numRows, configGrid.numCols, configDet.maximumCornerDistance, detectorSquare, inputToBinary);
        this.layoutPoints = CalibrationDetectorChessboardBinary.gridChess(configGrid.numRows, configGrid.numCols, configGrid.shapeSize);
    }

    public boolean process(GrayF32 input) {
        this.detected = new CalibrationObservation();
        if (this.alg.process(input)) {
            List<PointIndex2D_F64> found = this.alg.getCalibrationPoints();
            for (int i = 0; i < found.size(); ++i) {
                this.detected.add(i, (Point2D_F64)found.get((int)i).p);
            }
            return true;
        }
        return false;
    }

    public CalibrationObservation getDetectedPoints() {
        return this.detected;
    }

    public List<Point2D_F64> getLayout() {
        return this.layoutPoints;
    }

    public void setLensDistortion(@Nullable LensDistortionNarrowFOV distortion, int width, int height) {
        if (distortion == null) {
            this.alg.getFindSeeds().getDetectorSquare().setLensDistortion(width, height, null, null);
        } else {
            Point2Transform2_F32 pointDistToUndist = distortion.undistort_F32(true, true);
            Point2Transform2_F32 pointUndistToDist = distortion.distort_F32(true, true);
            PointToPixelTransform_F32 distToUndist = new PointToPixelTransform_F32(pointDistToUndist);
            PointToPixelTransform_F32 undistToDist = new PointToPixelTransform_F32(pointUndistToDist);
            this.alg.getFindSeeds().getDetectorSquare().setLensDistortion(width, height, (PixelTransform)distToUndist, (PixelTransform)undistToDist);
        }
    }

    public int getGridRows() {
        return this.alg.getRows();
    }

    public int getGridColumns() {
        return this.alg.getColumns();
    }

    public DetectChessboardBinaryPattern<GrayF32> getAlgorithm() {
        return this.alg;
    }

    public static List<Point2D_F64> gridChess(int numRows, int numCols, double squareWidth) {
        ArrayList<Point2D_F64> all = new ArrayList<Point2D_F64>();
        double startX = -((double)(--numCols - 1) * squareWidth) / 2.0;
        double startY = -((double)(--numRows - 1) * squareWidth) / 2.0;
        for (int i = numRows - 1; i >= 0; --i) {
            double y = startY + (double)i * squareWidth;
            for (int j = 0; j < numCols; ++j) {
                double x = startX + (double)j * squareWidth;
                all.add(new Point2D_F64(x, y));
            }
        }
        return all;
    }
}

