/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import boofcv.alg.fiducial.aztec.AztecCode;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.ReedSolomonCodes_U8;
import boofcv.misc.BoofMiscOps;
import org.ddogleg.struct.DogArray_I8;

public class AztecMessageModeCodec {
    ReedSolomonCodes_U8 rscodes = new ReedSolomonCodes_U8(4, 19, 1);
    DogArray_I8 eccInput = new DogArray_I8();
    DogArray_I8 eccOutput = new DogArray_I8();

    public void encodeMode(AztecCode marker, PackedBits8 bits) {
        int word;
        bits.resize(0);
        switch (marker.structure) {
            case COMPACT: {
                bits.append(marker.dataLayers - 1, 2, false);
                bits.append(marker.messageWordCount - 1, 6, false);
                this.eccInput.resize(2);
                this.rscodes.generator(5);
                break;
            }
            case FULL: {
                bits.append(marker.dataLayers - 1, 5, false);
                bits.append(marker.messageWordCount - 1, 11, false);
                this.eccInput.resize(4);
                this.rscodes.generator(6);
            }
        }
        for (word = 0; word < this.eccInput.size; ++word) {
            this.eccInput.data[word] = (byte)bits.read(word * 4, 4, true);
        }
        this.rscodes.computeECC(this.eccInput, this.eccOutput);
        for (word = 0; word < this.eccOutput.size; ++word) {
            bits.append(this.eccOutput.get(word), 4, false);
        }
    }

    public boolean decodeMode(PackedBits8 bits, AztecCode marker) {
        if (!this.correctDataBits(bits, marker.structure)) {
            return false;
        }
        switch (marker.structure) {
            case COMPACT: {
                marker.dataLayers = bits.read(0, 2, true) + 1;
                marker.messageWordCount = bits.read(2, 6, true) + 1;
                break;
            }
            case FULL: {
                marker.dataLayers = bits.read(0, 5, true) + 1;
                marker.messageWordCount = bits.read(5, 11, true) + 1;
            }
        }
        return true;
    }

    boolean correctDataBits(PackedBits8 bits, AztecCode.Structure structure) {
        switch (structure) {
            case COMPACT: {
                BoofMiscOps.checkEq((int)28, (int)bits.size, (String)"Invalid number of bits");
                this.eccInput.resize(2);
                this.eccOutput.resize(5);
                break;
            }
            case FULL: {
                BoofMiscOps.checkEq((int)40, (int)bits.size, (String)"Invalid number of bits");
                this.eccInput.resize(4);
                this.eccOutput.resize(6);
            }
        }
        this.rscodes.generator(this.eccOutput.size);
        int bitLocation = 0;
        int word = 0;
        while (word < this.eccInput.size) {
            this.eccInput.data[word] = (byte)bits.read(bitLocation, 4, true);
            ++word;
            bitLocation += 4;
        }
        word = 0;
        while (word < this.eccOutput.size) {
            this.eccOutput.data[word] = (byte)bits.read(bitLocation, 4, true);
            ++word;
            bitLocation += 4;
        }
        if (!this.rscodes.correct(this.eccInput, this.eccOutput)) {
            return false;
        }
        bits.resize(0);
        for (word = 0; word < this.eccInput.size; ++word) {
            bits.append(this.eccInput.get(word), 4, false);
        }
        return true;
    }
}

