/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.square;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.descriptor.DescriptorDistance;
import boofcv.alg.fiducial.qrcode.PackedBits32;
import boofcv.alg.fiducial.square.BaseDetectFiducialSquare;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.factory.fiducial.ConfigHammingMarker;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class DetectFiducialSquareHamming<T extends ImageGray<T>>
extends BaseDetectFiducialSquare<T> {
    public final ConfigHammingMarker description;
    protected final GrayU8 binaryInner = new GrayU8(1, 1);
    protected final GrayF32 grayNoBorder = new GrayF32();
    public double ambiguousPenaltyFrac = 0.5;
    protected static final int w = 10;
    protected static final int N = 36;
    final PackedBits32 bits = new PackedBits32();
    final GrayU8 bitImage = new GrayU8(1, 1);
    final GrayU8 workImage = new GrayU8(1, 1);
    int ambiguousBitCount = 0;

    public DetectFiducialSquareHamming(ConfigHammingMarker description, double minimumBlackBorderFraction, InputToBinary<T> inputToBinary, DetectPolygonBinaryGrayRefine<T> quadDetector, Class<T> inputType) {
        super(inputToBinary, quadDetector, false, description.borderWidthFraction, minimumBlackBorderFraction, (int)Math.round((double)(10 * description.gridWidth) / (1.0 - description.borderWidthFraction * 2.0)), inputType);
        this.description = description;
        this.binaryInner.reshape(10 * description.gridWidth, 10 * description.gridWidth);
        this.bitImage.reshape(description.gridWidth, description.gridWidth);
    }

    @Override
    protected boolean processSquare(GrayF32 square, BaseDetectFiducialSquare.Result result, double edgeInside, double edgeOutside) {
        int off = (square.width - this.binaryInner.width) / 2;
        square.subimage(off, off, off + this.binaryInner.width, off + this.binaryInner.width, (ImageGray)this.grayNoBorder);
        double threshold = (edgeInside + edgeOutside) / 2.0;
        int errorPureColor = this.decodeDataBits(this.grayNoBorder, threshold);
        if (this.verbose != null) {
            this.verbose.printf("_ square: threshold=%.1f ambiguous=%d errorPure=%d", threshold, this.ambiguousBitCount, errorPureColor);
        }
        if (errorPureColor == 0) {
            if (this.verbose != null) {
                this.verbose.println();
            }
            return false;
        }
        int bestMarker = -1;
        int bestOrientation = -1;
        int bestError = Integer.MAX_VALUE;
        for (int orientation = 0; orientation < 4 && bestError != 0; ++orientation) {
            this.convertBitImageToBitArray();
            int numWords = this.bits.arrayLength();
            for (int markerIdx = 0; markerIdx < this.description.encoding.size(); ++markerIdx) {
                int[] data = ((ConfigHammingMarker.Marker)this.description.encoding.get((int)markerIdx)).pattern.data;
                int error = 0;
                for (int wordIdx = 0; wordIdx < numWords; ++wordIdx) {
                    error += DescriptorDistance.hamming((int)(this.bits.data[wordIdx] ^ data[wordIdx]));
                }
                if (error >= bestError) continue;
                bestError = error;
                bestOrientation = orientation;
                bestMarker = markerIdx;
                if (bestError == 0) break;
            }
            ImageMiscOps.rotateCW((GrayI8)this.bitImage, (GrayI8)this.workImage);
            this.bitImage.setTo((ImageGray)this.workImage);
        }
        if (this.verbose != null) {
            this.verbose.printf(" hamming_error=%d minimum=%d", bestError, this.description.minimumHamming);
        }
        if ((double)bestError + (double)this.ambiguousBitCount * this.ambiguousPenaltyFrac > (double)this.description.minimumHamming || bestError >= errorPureColor) {
            if (this.verbose != null) {
                this.verbose.println();
            }
            return false;
        }
        result.which = bestMarker;
        result.lengthSide = 1.0;
        result.rotation = bestOrientation;
        result.error = bestError;
        if (this.verbose != null) {
            this.verbose.printf(" id=%d orientation=%d\n", result.which, result.rotation);
        }
        return true;
    }

    void convertBitImageToBitArray() {
        this.bits.resize(this.bitImage.width * this.bitImage.height);
        int i = 0;
        for (int y = 0; y < this.bitImage.height; ++y) {
            int x = 0;
            while (x < this.bitImage.width) {
                this.bits.set(this.bits.size - i - 1, this.bitImage.data[i]);
                ++x;
                ++i;
            }
        }
    }

    protected int decodeDataBits(GrayF32 gray, double threshold) {
        ThresholdImageOps.threshold((GrayF32)gray, (GrayU8)this.binaryInner, (float)((float)threshold), (boolean)true);
        int voteThreshold = 18;
        int ambiguousThreshold = 9;
        int gridWidth = this.description.gridWidth;
        this.ambiguousBitCount = 0;
        int countOnes = 0;
        for (int row = 0; row < gridWidth; ++row) {
            int y0 = row * this.binaryInner.width / gridWidth + 2;
            int y1 = (row + 1) * this.binaryInner.width / gridWidth - 2;
            for (int col = 0; col < gridWidth; ++col) {
                int x0 = col * this.binaryInner.width / gridWidth + 2;
                int x1 = (col + 1) * this.binaryInner.width / gridWidth - 2;
                int total = 0;
                for (int i = y0; i < y1; ++i) {
                    int index = i * this.binaryInner.width + x0;
                    for (int j = x0; j < x1; ++j) {
                        total += this.binaryInner.data[index++];
                    }
                }
                if ((total > 18 ? 36 - total : total) >= 9) {
                    ++this.ambiguousBitCount;
                }
                int bit = total <= 18 ? 1 : 0;
                this.bitImage.data[row * gridWidth + col] = (byte)bit;
                countOnes += bit;
            }
        }
        return Math.min(countOnes, gridWidth * gridWidth - countOnes);
    }

    public ConfigHammingMarker getDescription() {
        return this.description;
    }

    public GrayU8 getBinaryInner() {
        return this.binaryInner;
    }

    public GrayF32 getGrayNoBorder() {
        return this.grayNoBorder;
    }

    public double getAmbiguousPenaltyFrac() {
        return this.ambiguousPenaltyFrac;
    }

    public void setAmbiguousPenaltyFrac(double ambiguousPenaltyFrac) {
        this.ambiguousPenaltyFrac = ambiguousPenaltyFrac;
    }
}

