/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.scene;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.scene.ConfigFeatureToSceneRecognition;
import boofcv.abst.scene.FeatureSceneRecognition;
import boofcv.abst.scene.SceneRecognition;
import boofcv.misc.BoofLambdas;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class WrapFeatureToSceneRecognition<Image extends ImageBase<Image>, TD extends TupleDesc<TD>>
implements SceneRecognition<Image> {
    protected DetectDescribePoint<Image, TD> detector;
    protected BoofLambdas.Transform<Image> downSample;
    protected FeatureSceneRecognition<TD> recognizer;
    public ConfigFeatureToSceneRecognition config;
    FeatureSceneRecognition.Features<TD> wrappedDetector = this.wrap();

    public WrapFeatureToSceneRecognition(DetectDescribePoint<Image, TD> detector, BoofLambdas.Transform<Image> downSample, FeatureSceneRecognition<TD> recognizer) {
        this.detector = detector;
        this.downSample = downSample;
        this.recognizer = recognizer;
    }

    @Override
    public void learnModel(final Iterator<Image> images) {
        this.recognizer.learnModel(new Iterator<FeatureSceneRecognition.Features<TD>>(){

            @Override
            public boolean hasNext() {
                return images.hasNext();
            }

            @Override
            public FeatureSceneRecognition.Features<TD> next() {
                WrapFeatureToSceneRecognition.this.detector.detect((ImageBase)images.next());
                return WrapFeatureToSceneRecognition.this.wrappedDetector;
            }
        });
    }

    @Override
    public void clearDatabase() {
        this.recognizer.clearDatabase();
    }

    @Override
    public void addImage(String id, Image image) {
        this.detector.detect(image);
        this.recognizer.addImage(id, this.wrappedDetector);
    }

    @Override
    public boolean query(Image queryImage, @Nullable BoofLambdas.Filter<String> filter, int limit, DogArray<SceneRecognition.Match> matches) {
        this.detector.detect(queryImage);
        return this.recognizer.query(this.wrappedDetector, filter, limit, matches);
    }

    @Override
    public List<String> getImageIds(@Nullable List<String> storage) {
        return this.recognizer.getImageIds(storage);
    }

    @Override
    public ImageType<Image> getImageType() {
        return this.detector.getInputType();
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> options) {
        this.recognizer.setVerbose(out, options);
    }

    private FeatureSceneRecognition.Features<TD> wrap() {
        return new FeatureSceneRecognition.Features<TD>(){

            @Override
            public Point2D_F64 getPixel(int index) {
                return WrapFeatureToSceneRecognition.this.detector.getLocation(index);
            }

            @Override
            public TD getDescription(int index) {
                return WrapFeatureToSceneRecognition.this.detector.getDescription(index);
            }

            @Override
            public int size() {
                return WrapFeatureToSceneRecognition.this.detector.getNumberOfFeatures();
            }
        };
    }

    public <T extends FeatureSceneRecognition<TD>> T getRecognizer() {
        return (T)this.recognizer;
    }

    public DetectDescribePoint<Image, TD> getDetector() {
        return this.detector;
    }

    public void setDetector(DetectDescribePoint<Image, TD> detector) {
        this.detector = detector;
    }

    public void setRecognizer(FeatureSceneRecognition<TD> recognizer) {
        this.recognizer = recognizer;
    }

    public ConfigFeatureToSceneRecognition getConfig() {
        return this.config;
    }

    public void setConfig(ConfigFeatureToSceneRecognition config) {
        this.config = config;
    }
}

