/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.meanshift;

import boofcv.alg.color.ColorHsv;
import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;
import georegression.struct.shapes.RectangleLength2D_I32;

public class LikelihoodHueSatHistCoupled_PL_U8
implements PixelLikelihood<Planar<GrayU8>> {
    private GrayU8 imageRed;
    private GrayU8 imageGreen;
    private GrayU8 imageBlue;
    private final float[] hsv = new float[3];
    protected int numHistogramBins;
    protected int maxElementInBin;
    protected float minimumValue;
    protected float[] bins;
    protected float sizeH;
    protected float sizeS;

    public LikelihoodHueSatHistCoupled_PL_U8(int maxPixelValue, int numHistogramBins) {
        this.minimumValue = (float)(maxPixelValue + 1) * 0.01f;
        this.numHistogramBins = numHistogramBins;
        this.bins = new float[numHistogramBins * numHistogramBins];
        this.sizeH = (float)(6.286326899833176 / (double)numHistogramBins);
        this.sizeS = 1.001f / (float)numHistogramBins;
    }

    public void setImage(Planar<GrayU8> image) {
        this.imageRed = (GrayU8)image.getBand(0);
        this.imageGreen = (GrayU8)image.getBand(1);
        this.imageBlue = (GrayU8)image.getBand(2);
    }

    public boolean isInBounds(int x, int y) {
        return this.imageRed.isInBounds(x, y);
    }

    @Override
    public void createModel(RectangleLength2D_I32 target) {
        float total = 0.0f;
        for (int y = 0; y < target.height; ++y) {
            int index = this.imageRed.startIndex + (y + target.y0) * this.imageRed.stride + target.x0;
            int x = 0;
            while (x < target.width) {
                int r = this.imageRed.data[index] & 0xFF;
                int g = this.imageGreen.data[index] & 0xFF;
                int b = this.imageBlue.data[index] & 0xFF;
                ColorHsv.rgbToHsv((float)r, (float)g, (float)b, (float[])this.hsv);
                if (!(this.hsv[2] < this.minimumValue)) {
                    int binH = (int)(this.hsv[0] / this.sizeH);
                    int binS = (int)(this.hsv[1] / this.sizeS);
                    int n = binH * this.numHistogramBins + binS;
                    this.bins[n] = this.bins[n] + 1.0f;
                    total += 1.0f;
                }
                ++x;
                ++index;
            }
        }
        int i = 0;
        while (i < this.bins.length) {
            int n = i++;
            this.bins[n] = this.bins[n] / total;
        }
    }

    public float compute(int x, int y) {
        int index = this.imageRed.getIndex(x, y);
        int r = this.imageRed.data[index] & 0xFF;
        int g = this.imageGreen.data[index] & 0xFF;
        int b = this.imageBlue.data[index] & 0xFF;
        ColorHsv.rgbToHsv((float)r, (float)g, (float)b, (float[])this.hsv);
        if (this.hsv[2] < this.minimumValue) {
            return 0.0f;
        }
        int binH = (int)(this.hsv[0] / this.sizeH);
        int binS = (int)(this.hsv[1] / this.sizeS);
        return this.bins[binH * this.numHistogramBins + binS];
    }
}

