/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import java.util.Objects;

public class ConfigFiducialImage
implements Configuration {
    public double maxErrorFraction = 0.2;
    public double borderWidthFraction = 0.25;
    public double minimumBlackBorderFraction = 0.65;
    public ConfigPolygonDetector squareDetector = new ConfigPolygonDetector();

    public ConfigFiducialImage() {
        ((ConfigPolylineSplitMerge)this.squareDetector.detector.contourToPoly).cornerScorePenalty = 0.2;
        ((ConfigPolylineSplitMerge)this.squareDetector.detector.contourToPoly).thresholdSideSplitScore = 0.0;
        this.squareDetector.detector.minimumContour = ConfigLength.fixed((double)20.0);
        Objects.requireNonNull(this.squareDetector.refineGray).cornerOffset = 0.0;
    }

    public ConfigFiducialImage setTo(ConfigFiducialImage src) {
        this.maxErrorFraction = src.maxErrorFraction;
        this.borderWidthFraction = src.borderWidthFraction;
        this.minimumBlackBorderFraction = src.minimumBlackBorderFraction;
        this.squareDetector.setTo(src.squareDetector);
        return this;
    }

    public void checkValidity() {
        if (this.borderWidthFraction <= 0.0 || this.borderWidthFraction >= 0.5) {
            throw new IllegalArgumentException("Border width fraction must be 0 < fraction < 0.5");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ maxErrorFraction=" + this.maxErrorFraction + " borderWidthFraction=" + this.borderWidthFraction + " squareDetector=" + this.squareDetector + " }";
    }

    public double getMaxErrorFraction() {
        return this.maxErrorFraction;
    }

    public double getBorderWidthFraction() {
        return this.borderWidthFraction;
    }

    public double getMinimumBlackBorderFraction() {
        return this.minimumBlackBorderFraction;
    }

    public ConfigPolygonDetector getSquareDetector() {
        return this.squareDetector;
    }

    public void setMaxErrorFraction(double maxErrorFraction) {
        this.maxErrorFraction = maxErrorFraction;
    }

    public void setBorderWidthFraction(double borderWidthFraction) {
        this.borderWidthFraction = borderWidthFraction;
    }

    public void setMinimumBlackBorderFraction(double minimumBlackBorderFraction) {
        this.minimumBlackBorderFraction = minimumBlackBorderFraction;
    }

    public void setSquareDetector(ConfigPolygonDetector squareDetector) {
        this.squareDetector = squareDetector;
    }
}

